/*
    BattleTRANS Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTRANS.

    BattleTRANS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleInvItem4Switching extends Inventory;

simulated event Tick(float DeltaTime)
{
  local PlayerController PC;
  local BattlePRI BPRI;

  if (Owner != None) { 
    PC = PlayerController (Owner.Owner);
    if (UTPlayerController(PC) != None) {
      if (UTPawn(Owner) != None && PC.PlayerReplicationInfo != None) {
        BPRI = class'BattleTRANS'.static.GetBattlePRI (PC.PlayerReplicationInfo);
        if (BPRI != None) {
          UTPawn(Owner).MaxFallSpeed = 1250 * BPRI.MaxFallSpeed / 100; // Protect the pawn from damage if landing after a translocation        
          if (PC.PlayerReplicationInfo.bHasFlag || BPRI.TranslocatorMode == "off") {
            UTPawn(Owner).bHasHoverboard = true;
            if (UTPawn(Owner).Weapon != None && UTPawn(Owner).Weapon.Class == class'BattleTranslocator' && UTInventoryManager(UTPawn(Owner).InvManager) != None) {
              UTInventoryManager(UTPawn(Owner).InvManager).SwitchToPreviousWeapon();          
            }
          } else {
            UTPawn(Owner).bHasHoverboard = false;
          }
        }
      }
    }
  }
}

defaultproperties
{
  Name="BattleGenInvItem4Switching"
}