/*
    BattleTRANS Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTRANS.

    BattleTRANS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleBoard extends UTVehicle_Hoverboard;

simulated function UpdateSettings ()
{
  local BattlePRI BPRI;
  if (PlayerController (Controller)  != None) {
    if (PlayerController(Controller).PlayerReplicationInfo != None) {
      BPRI = class'BattleTRANS'.static.GetBattlePRI (PlayerController(Controller).PlayerReplicationInfo);
      if (BPRI != None && UTVehicleSimHoverboard(SimObj) != None) {
        UTVehicleSimHoverboard(SimObj).MaxThrustForce  = 200 * BPRI.HoverboardSpeed / 100;
        UTVehicleSimHoverboard(SimObj).UphillHelpThrust = 150 * BPRI.HoverboardSpeed / 100;
        UTVehicleSimHoverboard(SimObj).MaxUphillHelpThrust = 100 * BPRI.HoverboardSpeed / 100;
        UTVehicleSimHoverboard(SimObj).MaxReverseForce = 40 * BPRI.HoverboardSpeed / 100;
        UTVehicleSimHoverboard(SimObj).MaxReverseVelocity = 200 * BPRI.HoverboardSpeed / 100;
        UTVehicleSimHoverboard(SimObj).MaxStrafeForce = 150 * BPRI.HoverboardSpeed / 100;
        UTVehicleSimHoverboard(SimObj).TurnTorqueFactor = 800 * BPRI.HoverboardSpeed / 100;
        UTVehicleSimHoverboard(SimObj).MaxTurnTorque = 1000 * BPRI.HoverboardSpeed / 100;
        MaxSpeed = 3500 * BPRI.HoverboardSpeed / 100;
        GroundSpeed = 900 * BPRI.HoverboardSpeed / 100;
        AirSpeed = 900 * BPRI.HoverboardSpeed / 100;
      }
    }
  }
}

simulated function PostBeginPlay()
{
  UpdateSettings ();
  Super.PostBeginPlay ();
}

simulated function Tick(float DeltaTime)
{
  UpdateSettings ();
  Super.Tick (DeltaTime);
}

defaultproperties
{
  VehicleNameString="Battle Hoverboard"
  Name="Battle Board"
}