/* 
    BattleRPG Copyright (C) 2007-2008 Nico de Vries.

    This file is part of BattleTRANS.

    BattleTRANS is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see http://www.gnu.org/licenses/.
*/

class BattleTRANS extends UTMutator;

function PostBeginPlay()
{
  local UTGame G;
 
  Super.PostBeginPlay();
  G = UTGame(WorldInfo.Game);

  // Replace the translocator
  G.TranslocatorClass = class'BattleTRANS.BattleTranslocator';

  // Disable the hoverboard and enable the translocator
  G.bAllowHoverboard = False;
  G.bAllowTranslocator = True;
}

simulated function ModifyPlayer(Pawn Other)
{
  local UTPawn P;
  
  if (Other != None) {
    P = UTPawn (Other);
    if (P != None) {
      P.MaxFallSpeed = 2500.0; // Protect the pawn from damage if landing after a translocation
    }
  }
}

defaultproperties
{
  Name="BattleTRANS"
}