class HardPCM__Vh_SFT extends UTRemoteRedeemer
	notplaceable;

/* ----------------------------------------------------*/
/* XxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxX */
/*                                                     */
/*             This mutator was done by                */
/*             HardPCM Technologies 2010               */
/*                hardpcm666@gmail.com                 */
/*           hardpcmtechnologies.blogspot.com          */
/*                                                     */
/* XxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxX */
/* ----------------------------------------------------*/
/*anti_noob*/

/* --------------------------------------------------------------------*/
/*                                                                     */
/* --------------------------------------------------------------------*/



/* --------------------------------------------------------------------*/
/*  Variable                                                           */
/* --------------------------------------------------------------------*/

var				Actor					NextTargetActor;

var				SoundCue				Sound_Enter;
var				SoundCue				Sound_Exit;
var				SoundCue				Sound_Engine;

var				Array<SoundCue>			Sound_Bounce;

var				name					DrivingAnim;			/** Anim to play when a visible driver is driving */

/* --------------------------------------------------------------------*/

var				int						Bounce_Count;
var				int						Bounce_CountMax;

/* --------------------------------------------------------------------*/

var				class<Interaction>		Interaction_Class;
var				Interaction				Interaction_Driver;		/** PlayerController Only */

/* --------------------------------------------------------------------*/

var				float					BOT_Input_aTurn;
var				float					BOT_Input_aLookUp;

var				float					BOT_Looking_Distance;

var				vector					BOT_Error_Offset;

var				Actor					BOT_Last_Target;
var				HardPCM__SkyPointer		BOT_Last_SkyPointer;

/* --------------------------------------------------------------------*/

var				HardPCM__SkyNet			Hellfire_SkyNet;
var				HardPCM__SkyClient		Hellfire_SkyClient;

/* --------------------------------------------------------------------*/
/*  Event                                                              */
/* --------------------------------------------------------------------*/

simulated function PostBeginPlay()
{
	/* Update the creation time */
	SpawnTime = WorldInfo.TimeSeconds;

	/* Give a kick while entering vehicle */
	Velocity = AirSpeed * vector(Rotation);
	Acceleration = AccelRate * vector(Rotation);

	BOT_Error_Offset = VRand() * 4.0;

	if(WorldInfo.NetMode != NM_DedicatedServer)
	{
		Trail.SetTemplate(RedeemerProjClass.default.ProjFlightTemplate);
	}

	if( (Sound_Engine != None) && (WorldInfo.NetMode != NM_DedicatedServer) )
	{
		PawnAmbientSound = CreateAudioComponent(Sound_Engine, true, true);
		if ( PawnAmbientSound != None )
		{
			PawnAmbientSound.bShouldRemainActiveIfDropped = true;
			PawnAmbientSound.Play();
		}
	}

	/* SKYNET!!! */
	Install_SkyNet();
}

/* --------------------------------------------------------------------*/
/*  SkyNet                                                             */
/* --------------------------------------------------------------------*/

function Actor GetFirstActorsOfClass(class<Actor> ActorClass)
{
	local Actor TestActor;

	foreach AllActors(ActorClass,TestActor)
	{
		return TestActor;
	}
	return None;
}

/* --------------------------------------------------------------------*/

function Install_SkyNet()
{
	Hellfire_SkyNet = HardPCM__SkyNet(GetFirstActorsOfClass(class'HardPCM__SkyNet'));
	if( (Role != ROLE_Authority) || (Hellfire_SkyNet != None) )
	{
		return;
	}

	Hellfire_SkyNet = WorldInfo.Spawn(class'HardPCM__SkyNet');
///	LogInternal("Install_SkyNet Hellfire_SkyNet="$Hellfire_SkyNet);
}

/* --------------------------------------------------------------------*/

function Install_SkyClient()
{
	if(Hellfire_SkyClient != None)
	{
		return;
	}
	if( (Role != ROLE_Authority) || (Hellfire_SkyNet == None) || (UTBot(Controller)==None) )
	{
		return;
	}

	Hellfire_SkyClient = Hellfire_SkyNet.Get_Client(Self,Controller);
}

/* --------------------------------------------------------------------*/
/*  Player ID                                                          */
/* --------------------------------------------------------------------*/

/** Work only in network game, when (WorldInfo.NetMode != NM_Standalone) */
function UniqueNetId GetUniqueId(Pawn NewPawn)
{
	local UniqueNetId BigFuckingShit;

///	LogInternal("--- GetUniqueId() NewPawn="$NewPawn );

	if(NewPawn == None) return BigFuckingShit;
	if(NewPawn.PlayerReplicationInfo == None) return BigFuckingShit;

	return NewPawn.PlayerReplicationInfo.UniqueId;
}

/* --------------------------------------------------------------------*/

/** Work only in local game, when (WorldInfo.NetMode == NM_Standalone) */
function int GetPlayerNum(Pawn NewPawn)
{
///	LogInternal("--- GetPlayerNum() NewPawn="$NewPawn );

	if(NewPawn == None) return -1;
	LogInternal(" NewPawn.Controller="$NewPawn.Controller );
	if(NewPawn.Controller == None) return -1;
	LogInternal(" NewPawn.Controller.PlayerNum="$NewPawn.Controller.PlayerNum );
	return NewPawn.Controller.PlayerNum;
}

/* --------------------------------------------------------------------*/

/** Work only in network game, when (WorldInfo.NetMode != NM_Standalone) */
function Controller GetControllerFromUniqueId(UniqueNetId NewUniqueId)
{
	local Controller C;

///	LogInternal("--- GetControllerFromUniqueId()");

	foreach WorldInfo.AllControllers(class'Controller', C)
	{
		if(C.PlayerReplicationInfo == None) continue;
		if(C.PlayerReplicationInfo.UniqueId != NewUniqueId) continue;
///		LogInternal("found C="$C);
		return C;
	}
	return None;
}

/* --------------------------------------------------------------------*/

/** Work only in local game, when (WorldInfo.NetMode == NM_Standalone) */
function Controller GetControllerFromPlayerNum(int NewPlayerNum)
{
	local Controller C;

///	LogInternal("--- GetControllerFromPlayerNum() NewPlayerNum="$NewPlayerNum );

	foreach WorldInfo.AllControllers(class'Controller', C)
	{
		if(C.PlayerNum != NewPlayerNum) continue;
///		LogInternal("found C="$C);
		return C;
	}
	return None;
}

/* --------------------------------------------------------------------*/
/*  Interaction                                                        */
/* --------------------------------------------------------------------*/

simulated function ServerPrevWeapon(int NewState)
{

}

/* --------------------------------------------------------------------*/

simulated function ServerNextWeapon(int NewState)
{

}

/* --------------------------------------------------------------------*/

simulated function ClientJumpKey(int NewState)
{
	if(NewState == 1)
	{
		Server_DriverLeave(true);		// HardPCM.Todo: not sure If I must force the exit
	}
}

/* --------------------------------------------------------------------*/

simulated function ClientDuckKey(int NewState)
{

}

/* --------------------------------------------------------------------*/

// expected argument values range [-1,1], with the except of a code of 2, meaning "ignore"
simulated function ClientProcessLean(int NewY, int NewX)
{

}

/* --------------------------------------------------------------------*/
/*  Interaction Installer                                              */
/* --------------------------------------------------------------------*/

reliable server function Server_InstallInteraction(UniqueNetId NewUniqueId, int NewPlayerNum)
{
	local int i;
	local bool bFound;
	local PlayerController PC;
	//local PlayerInput PI;

///	LogInternal(" --- Server_InstallInteraction()");
///	LogInternal(" Role="$Role );
///	LogInternal(" RemoteRole="$RemoteRole );
///	LogInternal(" WorldInfo.NetMode="$WorldInfo.NetMode );

	if((WorldInfo.NetMode != NM_Standalone)&&(WorldInfo.NetMode != NM_ListenServer))
	{
		PC = PlayerController(GetControllerFromUniqueId(NewUniqueId));
	}
	else
	{
		PC = PlayerController(GetControllerFromPlayerNum(NewPlayerNum));
	}
	if(PC == None)
	{
///		LogInternal(" --- Server_InstallInteraction()  NewPlayerNum="$NewPlayerNum);
///		LogInternal(" Role="$Role );
///		LogInternal(" RemoteRole="$RemoteRole );
///		LogInternal(" WorldInfo.NetMode="$WorldInfo.NetMode );
		return;
	}

	/* --- Validate if this is the local player --- */
	if(NetConnection(PC.Player) != None)
	{
///		return;
	}
///	LogInternal(" PC.PlayerNum="$PC.PlayerNum );
///	LogInternal(" PC.GetTeamNum()="$PC.GetTeamNum() );
///	LogInternal(" PC.PlayerReplicationInfo.PlayerName="$PC.PlayerReplicationInfo.PlayerName );

///	LogInternal("Inspecting "$PC$" for interactions :");
	for (i = 0; i < PC.Interactions.Length; i++)
	{
///		LogInternal("... found "$PC.Interactions[i]);
		if (HardPCM__Interaction_SFT(PC.Interactions[i]) != none) bFound = true;
		//else if (PlayerInput(PC.Interactions[i]) != none) PI = PlayerInput(PC.Interactions[i]);
	}

	if (!bFound)
	{
		PC.Interactions.Insert(0, 1);
		PC.Interactions[0] = new(PC) Interaction_Class;
		Interaction_Driver = PC.Interactions[0];
		HardPCM__Interaction_SFT(PC.Interactions[0]).InitStrangeLove(PC,self);
///		LogInternal("PC added a HardPCM__Interaction_SFT");
	}
}

/* --------------------------------------------------------------------*/

///simulated function Client_InstallInteraction(UniqueNetId NewUniqueId, int NewPlayerNum)
reliable client function Client_InstallInteraction(UniqueNetId NewUniqueId, int NewPlayerNum)
{
	local int i;
	local bool bFound;
	local PlayerController PC;
	//local PlayerInput PI;

///	LogInternal(" --- Client_InstallInteraction()");
///	LogInternal(" Role="$Role );
///	LogInternal(" RemoteRole="$RemoteRole );
///	LogInternal(" WorldInfo.NetMode="$WorldInfo.NetMode );

	if((WorldInfo.NetMode != NM_Standalone)&&(WorldInfo.NetMode != NM_ListenServer))
	{
		PC = PlayerController(GetControllerFromUniqueId(NewUniqueId));
	}
	else
	{
		PC = PlayerController(GetControllerFromPlayerNum(NewPlayerNum));
	}
	if(PC == none)
	{
///		LogInternal(" --- Client_InstallInteraction()  NewPlayerNum="$NewPlayerNum);
///		LogInternal(" Role="$Role );
///		LogInternal(" RemoteRole="$RemoteRole );
///		LogInternal(" WorldInfo.NetMode="$WorldInfo.NetMode );
		return;
	}

	/* --- Validate if this is the local player --- */
	if(NetConnection(PC.Player) != None)
	{
///		return;
	}
///	LogInternal(" PC.PlayerNum="$PC.PlayerNum );
///	LogInternal(" PC.GetTeamNum()="$PC.GetTeamNum() );
///	LogInternal(" PC.PlayerReplicationInfo.PlayerName="$PC.PlayerReplicationInfo.PlayerName );

///	LogInternal("Inspecting "$PC$" for interactions :");
	for (i = 0; i < PC.Interactions.Length; i++)
	{
///		LogInternal("... found "$PC.Interactions[i]);
		if (HardPCM__Interaction_SFT(PC.Interactions[i]) != none) bFound = true;
		//else if (PlayerInput(PC.Interactions[i]) != none) PI = PlayerInput(PC.Interactions[i]);
	}

	if (!bFound)
	{
		PC.Interactions.Insert(0, 1);
		PC.Interactions[0] = new(PC) Interaction_Class;
		Interaction_Driver = PC.Interactions[0];
		HardPCM__Interaction_SFT(PC.Interactions[0]).InitStrangeLove(PC,self);
///		LogInternal("PC added a HardPCM__Interaction_SFT");
	}
}

/* --------------------------------------------------------------------*/

function InstallInteraction(UniqueNetId NewUniqueId, int NewPlayerNum)
{
	Server_InstallInteraction(NewUniqueId, NewPlayerNum);
	Client_InstallInteraction(NewUniqueId, NewPlayerNum);
}

/* --------------------------------------------------------------------*/
/*  Interaction Desinstaller                                           */
/* --------------------------------------------------------------------*/

reliable server function Server_DesinstallInteraction(UniqueNetId NewUniqueId, int NewPlayerNum)
{
	local int i;
	local bool bFound;
	local PlayerController PC;
	//local PlayerInput PI;

///	LogInternal(" --- Server_DesinstallInteraction()");
///	LogInternal(" Role="$Role );
///	LogInternal(" RemoteRole="$RemoteRole );
///	LogInternal(" WorldInfo.NetMode="$WorldInfo.NetMode );

	if((WorldInfo.NetMode != NM_Standalone)&&(WorldInfo.NetMode != NM_ListenServer))
	{
		PC = PlayerController(GetControllerFromUniqueId(NewUniqueId));
	}
	else
	{
		PC = PlayerController(GetControllerFromPlayerNum(NewPlayerNum));
	}
	if(PC == none)
	{
///		LogInternal(" --- Server_DesinstallInteraction()  NewPlayerNum="$NewPlayerNum);
///		LogInternal(" Role="$Role );
///		LogInternal(" RemoteRole="$RemoteRole );
///		LogInternal(" WorldInfo.NetMode="$WorldInfo.NetMode );
		return;
	}

	/* --- Validate if this is the local player --- */
	if(NetConnection(PC.Player) != None)
	{
///		return;
	}
///	LogInternal(" PC.PlayerNum="$PC.PlayerNum );
///	LogInternal(" PC.GetTeamNum()="$PC.GetTeamNum() );
///	LogInternal(" PC.PlayerReplicationInfo.PlayerName="$PC.PlayerReplicationInfo.PlayerName );

///	LogInternal("Inspecting "$PC$" for interactions :");
	for(i = 0; i < PC.Interactions.Length; i++)
	{
///		LogInternal("... found "$PC.Interactions[i]);
///		if(HardPCM__Interaction_SFT(PC.Interactions[i]) != none)
		if((PC.Interactions[i]!=None) && (Interaction_Class == PC.Interactions[i].class))
		{
			bFound = true;
			break; // HardPCM.Todo: I need the index location
		}
	}

	if(bFound)
	{
		if(i < PC.Interactions.Length)
		{
			PC.Interactions.Remove(i, 1);
			Interaction_Driver = None;
		}
	}
}

/* --------------------------------------------------------------------*/

///simulated function Client_DesinstallInteraction(UniqueNetId NewUniqueId, int NewPlayerNum)
reliable client function Client_DesinstallInteraction(UniqueNetId NewUniqueId, int NewPlayerNum)
{
	local int i;
	local bool bFound;
	local PlayerController PC;
	//local PlayerInput PI;

///	LogInternal(" --- Client_DesinstallInteraction()");
///	LogInternal(" Role="$Role );
///	LogInternal(" RemoteRole="$RemoteRole );
///	LogInternal(" WorldInfo.NetMode="$WorldInfo.NetMode );

	if((WorldInfo.NetMode != NM_Standalone)&&(WorldInfo.NetMode != NM_ListenServer))
	{
		PC = PlayerController(GetControllerFromUniqueId(NewUniqueId));
	}
	else
	{
		PC = PlayerController(GetControllerFromPlayerNum(NewPlayerNum));
	}
	if(PC == none)
	{
///		LogInternal(" --- Client_DesinstallInteraction()  NewPlayerNum="$NewPlayerNum);
///		LogInternal(" Role="$Role );
///		LogInternal(" RemoteRole="$RemoteRole );
///		LogInternal(" WorldInfo.NetMode="$WorldInfo.NetMode );
		return;
	}

	/* --- Validate if this is the local player --- */
	if(NetConnection(PC.Player) != None)
	{
///		return;
	}
///	LogInternal(" PC.PlayerNum="$PC.PlayerNum );
///	LogInternal(" PC.GetTeamNum()="$PC.GetTeamNum() );
///	LogInternal(" PC.PlayerReplicationInfo.PlayerName="$PC.PlayerReplicationInfo.PlayerName );

///	LogInternal("Inspecting "$PC$" for interactions :");
	for(i = 0; i < PC.Interactions.Length; i++)
	{
///		LogInternal("... found "$PC.Interactions[i]);
///		if(HardPCM__Interaction_SFT(PC.Interactions[i]) != none)
		if((PC.Interactions[i]!=None) && (Interaction_Class == PC.Interactions[i].class))
		{
			bFound = true;
			break; // HardPCM.Todo: I need the index location
		}
	}

	if(bFound)
	{
		if(i < PC.Interactions.Length)
		{
			PC.Interactions.Remove(i, 1);
			Interaction_Driver = None;
		}
	}
}

/* --------------------------------------------------------------------*/

function DesinstallInteraction(UniqueNetId NewUniqueId, int NewPlayerNum)
{
	Server_DesinstallInteraction(NewUniqueId, NewPlayerNum);
	Client_DesinstallInteraction(NewUniqueId, NewPlayerNum);
}

/* --------------------------------------------------------------------*/
/*  Weapons control                                                    */
/* --------------------------------------------------------------------*/

simulated function StartFire(byte FireModeNum)
{
///	LogInternal( " --- StartFire FireModeNum="$FireModeNum );

	if(FireModeNum == 1)
	{
		Server_DriverLeave(true);				// HardPCM.Todo: not sure If I must force the exit
	}
	else if(FireModeNum == 0)
	{ 
		
	}	
}

/* --------------------------------------------------------------------*/
/*  Capture The Flag Shits                                             */
/* --------------------------------------------------------------------*/

function Flag_SetHolder(UTCTFFlag NewCtfFlag, Controller C)
{
	local int i;
	local UTPlayerController PC;
	local UTBot B;
	local Controller OtherC;

	NewCtfFlag.LogTaken(c);
	NewCtfFlag.Holder = Driver;
	if ( UTPawn(NewCtfFlag.Holder) != None )
	{
		UTPawn(NewCtfFlag.Holder).DeactivateSpawnProtection();
	}
	NewCtfFlag.HolderPRI = UTPlayerReplicationInfo(NewCtfFlag.Holder.PlayerReplicationInfo);
	if(NewCtfFlag.HolderPRI == None)
	{
		NewCtfFlag.HolderPRI = UTPlayerReplicationInfo(Self.PlayerReplicationInfo);
	}
	NewCtfFlag.HolderPRI.SetFlag(NewCtfFlag);
	NewCtfFlag.HolderPRI.bForceNetUpdate = TRUE;
	NewCtfFlag.LastFlagSeeTime = WorldInfo.TimeSeconds - 11;
	NewCtfFlag.GotoState('Held');

	// AI Related
	C.MoveTimer = -1;
	NewCtfFlag.Holder.MakeNoise(2.0);

	// update players and bots that were coming for this object
	PC = UTPlayerController(C);
	if (PC != None)
	{
		PC.CheckAutoObjective(true);
	}
	foreach WorldInfo.AllControllers(class'Controller', OtherC)
	{
		PC = UTPlayerController(OtherC);
		if (PC != None)
		{
			if (PC.LastAutoObjective == self)
			{
				PC.CheckAutoObjective(true);
			}
		}
		else if (OtherC.MoveTarget == NewCtfFlag || OtherC.MoveTarget == NewCtfFlag.HomeBase || OtherC.RouteGoal == NewCtfFlag || OtherC.RouteGoal == NewCtfFlag.HomeBase)
		{
			B = UTBot(OtherC);
			if (B != None && B.Squad != None)
			{
				B.Squad.Retask(B);
			}
		}
	}

	// Track First Touch
	if (NewCtfFlag.FirstTouch == None)
		NewCtfFlag.FirstTouch = C;

	// Track Assists
	for (i=0;i<NewCtfFlag.Assists.Length;i++)
		if (NewCtfFlag.Assists[i] == C)
		  return;

	NewCtfFlag.Assists.Length = NewCtfFlag.Assists.Length+1;
  	NewCtfFlag.Assists[NewCtfFlag.Assists.Length-1] = C;

	NewCtfFlag.SendFlagMessage(C);
}

/* --------------------------------------------------------------------*/

function bool Flag_ValidHolder(UTCTFFlag NewCtfFlag, Actor other)
{
	local UTPawn UTP;
	local UTBot B;

	if(other == None) return false;
	if(NewCtfFlag == None) return false;
	if(NewCtfFlag.Team == None) return false;

	// feigning death pawns can't pick up flags
	UTP = UTPawn(other);
	if (UTP != None && UTP.IsInState('FeigningDeath'))
	{
		return false;
	}

	B = UTBot(Controller);
	if (B != None)
	{
		B.NoVehicleGoal = None;
	}

	if( WorldInfo.GRI.OnSameTeam(NewCtfFlag,Controller) )
	{
		NewCtfFlag.SameTeamTouch(Controller);
		return false;
	}

    return true;
}

/* --------------------------------------------------------------------*/

function Flag_TryToGetOrGive(UTCTFFlag NewCtfFlag)
{
///	LogInternal(" --- Flag_TryToGetOrGive() NewCtfFlag="$NewCtfFlag );

	if(NewCtfFlag == None) return;
	if(NewCtfFlag.Team == None) return;

	if(Driver == None) return;
	if(Controller == None) return;

	if(Flag_ValidHolder(NewCtfFlag, Driver))
	{
		Flag_SetHolder(NewCtfFlag, Controller);
	}
}

/* --------------------------------------------------------------------*/
/*  Collision                                                          */
/* --------------------------------------------------------------------*/

function Actor Collision_FilterActor(Actor Other, optional string sInstigatorEvent)
{
///	LogInternal( " --- Collision_FilterActor Driver="$Driver$" Other="$Other$" Other.Base="$Other.Base$" Other.Owner="$Other.Owner$" sInstigatorEvent="$sInstigatorEvent );

///	LogInternal( " ---a10");

	Flag_TryToGetOrGive(UTCTFFlag(Other));

///	LogInternal( " ---a11");

	if(NavigationPoint(Other) != None) return None;
///	LogInternal( " ---a12");
	if(Other == Self) return None;
	if(Other.Base == Self) return None;
	if(Other.Owner == Self) return None;
///	LogInternal( " ---a13");
	if(Other == Driver) return None;
	if(Other == Instigator) return None;
///	LogInternal( " ---a14");

	/* Make explode stupid UTPawn.S */
	if( (Pawn(Other) != None) && (Vehicle(Other) == None) )
	{
///		LogInternal( " ---a1");
		// If its a non-vehicle pawn, do lots of damage.
		Other.TakeDamage(10000, GetCollisionDamageInstigator(), Other.Location, Velocity * Pawn(Other).Mass, CrushedDamageType);
		return None;
	}
///	LogInternal( " ---a2");

	return Other;
}

/* --------------------------------------------------------------------*/

event EncroachedBy(Actor Other)
{
	Other = Collision_FilterActor(Other, "EncroachedBy"); if(Other != None) Super.EncroachedBy(Other);
}

/* --------------------------------------------------------------------*/

event Landed(vector HitNormal, Actor FloorActor)
{
	FloorActor = Collision_FilterActor(FloorActor, "Landed"); if(FloorActor != None) Super.Landed(HitNormal, FloorActor);
}

/* --------------------------------------------------------------------*/

reliable client function Client_BounceCount(int NewCount)
{
	Bounce_Count = NewCount;
}

/* --------------------------------------------------------------------*/

function bool Bounce_HitWall(vector HitNormal, Actor Wall, PrimitiveComponent WallComp)
{
	local vector realhn;

	if((Controller == None)&&(Driver == None)) return true;
	Bounce_Count++;
	Client_BounceCount(Bounce_Count);
	if((Bounce_Count >= Bounce_CountMax)) return true;
///	if(Role == ROLE_Authority)
///	{
///		Health -= Self.default.Health / Bounce_CountMax;
///	}

	realhn = HitNormal;
	HitNormal = normal(HitNormal + 0.4 * vrand());

	/* They are facing? */
	if((HitNormal Dot realhn) < 0)
	{
		HitNormal *= -0.5;
	}
	Velocity = 0.5 * (Velocity - 2 * HitNormal * (Velocity Dot HitNormal));

	Driver.PlaySound(Sound_Bounce[Rand(1)]);

	return false;
}

/* --------------------------------------------------------------------*/

event HitWall(vector HitNormal, Actor Wall, PrimitiveComponent WallComp)
{
///	LogInternal( " --- HitWall HitNormal="$HitNormal$" Wall="$Wall$" WallComp="$WallComp$" DotProduct="$((HitNormal Dot vector(Rotation)) < 0) );

	/* When spawned, the missile tail touch the wall */
	if( ((HitNormal Dot vector(Rotation)) < 0) && (WorldInfo.TimeSeconds < (SpawnTime + 2.0)) )
	{
		return;
	}

	if(Wall != None)
	{
		Wall = Collision_FilterActor(Wall);
		if(Wall != None)
		{
			if(Bounce_HitWall(HitNormal, Wall, WallComp))
			{
				Super.HitWall(HitNormal, Wall, WallComp);
			}
		}
	}
	else
	{
		if(Bounce_HitWall(HitNormal, Wall, WallComp))
		{
			Super.HitWall(HitNormal, Wall, WallComp);
		}
	}
}

/* --------------------------------------------------------------------*/

singular event Touch(Actor Other, PrimitiveComponent OtherComp, vector HitLocation, vector HitNormal)
{
	Other = Collision_FilterActor(Other, "Touch");
	if(Other == None) return;

	if (Other.bProjTarget && !Other.IsA('Volume') && (bCanHitDriver || Other != Driver) && (Projectile(Other) == None) )
	{
		BlowUp();
	}
}

/* --------------------------------------------------------------------*/

singular event Bump(Actor Other, PrimitiveComponent OtherComp, vector HitNormal)
{
	Other = Collision_FilterActor(Other, "Bump");
	if(Other == None) return;

	BlowUp();
}

/* --------------------------------------------------------------------*/
/*  Player Control                                                     */
/* --------------------------------------------------------------------*/

function PossessedBy(Controller C, bool bVehicleTransition)
{
	Super.PossessedBy(C, bVehicleTransition);
}

/* --------------------------------------------------------------------*/

function UnPossessed()
{
	Super.UnPossessed();
}

/* --------------------------------------------------------------------*/
/*  Native Driving                                                     */
/* --------------------------------------------------------------------*/

simulated event Vector GetPawnViewLocation()
{
	return Location + vect(0,0,45) * BaseEyeHeight;
}

/* --------------------------------------------------------------------*/

event bool ContinueOnFoot()
{
	return false;
}

/* --------------------------------------------------------------------*/

function bool DriverEnter(Pawn P)
{
	local Controller C;
	local UTPawn UTP;

///	LogInternal(" --- DriverEnter() P="$P );
///	LogInternal(" Role="$Role );
///	LogInternal(" RemoteRole="$RemoteRole );

	/* Try to start with UTPawn speed */
	if(P != None)
	{
		if(VSize(P.Velocity) > 0.1)
		{
			Velocity = P.Velocity;
		}
		else
		{
			Velocity = 1.0 * vector(P.Rotation);
		}
///		Acceleration = P.Acceleration;
	}

	/* Crouch!!! */
	P.ForceCrouch();

	UTP = UTPawn(P);
	if(UTP != None)
	{
		///if(Mesh != None) Mesh.AddImpulse(P.Velocity,,, true);
///		if(Mesh != None) Mesh.AddImpulse(VSize(P.Velocity) * vect(0,0,1.0),,, true);
	}
	Super.DriverEnter(P);
///	if ( !Super.DriverEnter(P) )
///	{
///		LogInternal(" --- big fucking shit -- 22 -- ");
///		BlowUp();
///		return false;
///	}

	// Set pawns current controller to control the vehicle pawn instead
	C = P.Controller;
	Driver = P;
	Driver.StartDriving( self );
	if ( Driver.Health <= 0 )
	{
		Driver = None;
		return false;
	}
	SetDriving(true);

	// Disconnect PlayerController from Driver and connect to Vehicle.
	if(C!=None)
	{
		C.Unpossess();
	}
	Driver.SetOwner( Self ); // This keeps the driver relevant.
	if(C!=None)
	{
		C.Possess( Self, true );
	}

	if( PlayerController(C) != None )
	{
		PlayerController(C).GotoState( LandMovementState );
	}

	WorldInfo.Game.DriverEnteredVehicle(self, P);

	/* The Pawn controller is not replicated on the client side */
	if(Controller != None)
	{
		InstallInteraction(GetUniqueId(P),Controller.PlayerNum);
	}
	else if(P.Controller != None)
	{
		InstallInteraction(GetUniqueId(P),P.Controller.PlayerNum);
	}
	else if(C != None)
	{
		InstallInteraction(GetUniqueId(P),C.PlayerNum);
	}

	Install_SkyClient();

	Self.InvManager = P.InvManager;
	Self.bCanPickupInventory = True;
	Weapon = None;

	P.ForceCrouch();

	return true;
}

/* --------------------------------------------------------------------*/

/** Server suck so server will do that */
reliable server function bool Server_DriverLeave( bool bForceLeave )
{
	return DriverLeave( bForceLeave );
}

/* --------------------------------------------------------------------*/

event bool DriverLeave( bool bForceLeave )
{
	local Controller		C;
	local PlayerController	PC;
	local Rotator ExitRotation;

///	LogInternal(" --- DriverLeave() Controller="$Controller );
///	LogInternal(" Role="$Role );
///	LogInternal(" RemoteRole="$RemoteRole );

	if(Controller != None)
	{
		Self.InvManager = None;
		Self.bCanPickupInventory = False;
		Weapon = None;

		DesinstallInteraction(GetUniqueId(Self),Controller.PlayerNum);
	}

	if(Driver != None)
	{
		Driver.UnCrouch();
	}

	SetRotation(rotator(Velocity));	// HardPCM.Fix: ?

///	return Super.DriverLeave( bForceLeave );

	if (Role < ROLE_Authority)
	{
		WarnInternal("DriverLeave() called on client");
		ScriptTrace();
		return false;
	}

	if( !bForceLeave && !WorldInfo.Game.CanLeaveVehicle(self, Driver) )
	{
		return false;
	}

	// Do nothing if we're not being driven
	if ( Controller == None )
	{
		return false;
	}

	// Before we can exit, we need to find a place to put the driver.
	// Iterate over array of possible exit locations.
	if ( Driver != None )
    {
	    Driver.SetHardAttach(false);
	    Driver.bCollideWorld = true;
	    Driver.SetCollision(true, true);

		if ( !PlaceExitingDriver() )
	    {
			if ( !bForceLeave )
			{
				// If we could not find a place to put the driver, leave driver inside as before.
			    Driver.SetHardAttach(true);
				Driver.bCollideWorld = false;
				Driver.SetCollision(false, false);
				return false;
			}
			else
			{
				Driver.SetLocation(GetTargetLocation());
			}
	    }
	}

	ExitRotation.Yaw = Controller.Rotation.Yaw;
	SetDriving(False);

	// Reconnect Controller to Driver.
	if(Controller != None) C = Controller;
	if (C.RouteGoal == self)
	{
		C.RouteGoal = None;
	}
	if (C.MoveTarget == self)
	{
		C.MoveTarget = None;
	}
	if(Controller != None) Controller.UnPossess();

	if ( (Driver != None) && (Driver.Health > 0) )
	{
		Driver.SetRotation(ExitRotation);
		Driver.SetOwner( C );
		if(C != None) C.Possess( Driver, true );

		PC = PlayerController(C);
		if ( PC != None )
		{
			PC.ClientSetViewTarget( Driver ); // Set playercontroller to view the person that got out
		}

		Driver.StopDriving( Self );
	}

	if ( C == Controller )	// If controller didn't change, clear it...
	{
		Controller = None;
	}

	WorldInfo.Game.DriverLeftVehicle(self, Driver);

	// Vehicle now has no driver
	DriverLeft();
	return true;
}

/* --------------------------------------------------------------------*/

simulated function AttachDriver( Pawn P )
{
	local UTPawn UTP;

///	LogInternal(" --- AttachDriver() P="$P );
///	LogInternal(" Role="$Role );
///	LogInternal(" RemoteRole="$RemoteRole );

	UTP = UTPawn(P);

	if( !bAttachDriver )
	{
		return;
	}

	P.SetCollision( false, false);
	P.bCollideWorld = false;
	P.SetBase(none);
	P.SetHardAttach(true);
	P.SetPhysics( PHYS_None );

    //UTP.SetLocation( Location );
	//UTP.SetLocation(Location + vect(-20,0,70));
    //UTP.SetRotation(rotator(Velocity));
///	P.SetRotation(P.Rotation + rotator(Velocity));

	Driver.SetLocation(Location + vect(0,-4,26));
	if( (UTP != None) && (UTP.Mesh != None) )
	{
		UTP.Mesh.ForceUpdate(true);
	}
	if ( (P.Mesh != None) && (Mesh != None) )
	{
		P.Mesh.SetOwnerNoSee(True); // HardPCM.Fix: Pawn Fucking up the camera
		P.Mesh.SetShadowParent(Mesh);
	}

	if ( !bDriverIsVisible )
	{
		P.SetHidden(False);
		P.SetLocation( Location );
	}
	P.SetBase(self);
	P.SetRelativeRotation(rot(0,0,0));
	P.SetPhysics( PHYS_None );	// need to set PHYS_None again, because SetBase() changes physics to PHYS_Falling

	if(Sound_Enter!=None)
	{
		Driver.PlaySound(Sound_Enter, true);
	}

	/* set a low speed */
///	Client_SetSpeed(0);
///	Driving_MoveRocket(1.0, Velocity, P.Rotation);
}

/* --------------------------------------------------------------------*/

simulated function DetachDriver( Pawn P )
{
///	LogInternal(" --- DetachDriver() P="$P );
///	LogInternal(" Role="$Role );
///	LogInternal(" RemoteRole="$RemoteRole );

	if(Sound_Exit!=None)
	{
		Driver.PlaySound(Sound_Exit, true);
	}

	Super.DetachDriver(P);
	bCanHitDriver = false;
	P.SetLocation(Location + (normal(Velocity) * -200) ); // give clearance to fall?
	Driver.SetHardAttach(false);
	Driver.bCollideWorld = true;
	Driver.SetCollision(true, true);

	P.SetRotation(rotator(Velocity));
	P.SetBase(self);

	SetRotation(rotator(Velocity));	// HardPCM.Fix: ?
}

/* --------------------------------------------------------------------*/
/*  Damage                                                             */
/* --------------------------------------------------------------------*/

reliable server function ServerBlowUp()
{
///	LogInternal(" --- ServerBlowUp");
///	ScriptTrace();

	Super.ServerBlowUp();
}

/* --------------------------------------------------------------------*/

function BlowUp()
{
///	LogInternal(" --- BlowUp");
///	ScriptTrace();

	if(Role == ROLE_Authority)
	{
		GotoState('Dying');
	}
}

/* --------------------------------------------------------------------*/
/*  Bot Control                                                        */
/* --------------------------------------------------------------------*/

function int NormaliseAngle(int n)
{
	n = n & 65535;

	while(n < -32768) n += 65536;
	while(n > +32768) n -= 65536;

	return n;
}

/* --------------------------------------------------------------------*/

function int BotDriver_MinimumDelta(int nA, int nB)
{
	nA = nA & 65535;
	nB = nB & 65535;

	if(abs(nA - nB) >= 32768)
	{
		if(nA < nB)
		{
			return (nA + (65536 - nB));
		}
		else if(nA > nB)
		{
			return (nB + (65536 - nA));
		}
		else return 0;
	}

	if(nA < nB)
	{
		return (nB - nA);
	}
	else if(nA > nB)
	{
		return (nA - nB);
	}
	else return 0;
}

/* --------------------------------------------------------------------*/

function float BotDriver_Direction(int nA, int nB)
{
	nA = nA & 65535;
	nB = nB & 65535;

	if(BotDriver_MinimumDelta(nA, nB) < 768)
	{
		return 0.0;
	}

	if(abs(nA - nB) >= 32768)
	{
		if(nA < nB) return -1.0;
		else if(nA > nB) return +1.0;
		else return 0.0;
	}

	if(nA < nB) return +1.0;
	else if(nA > nB) return -1.0;
	else return 0.0;
}

/* --------------------------------------------------------------------*/

function BotDriver_FaceRotation(rotator NewRotation, float DeltaTime)
{
	local vector X,Y,Z;
	local float PitchThreshold, YMag, SmoothRoll;
	local int Pitch, CurrentRoll;
	local Rotator RolledRotation;

	BOT_Input_aTurn = BotDriver_Direction(Rotation.Yaw, NewRotation.Yaw);
	BOT_Input_aLookUp = BotDriver_Direction(Rotation.Pitch, NewRotation.Pitch);

	BOT_Input_aTurn *= 64.0;
	BOT_Input_aLookUp *= 45.0;

///	LogInternal(" --- BotDriver_FaceRotation BOT_Input_aTurn="$BOT_Input_aTurn$" BOT_Input_aLookUp="$BOT_Input_aLookUp);

	// process input and adjust acceleration
	YawAccel = (1 - 2 * DeltaTime) * YawAccel + DeltaTime * BOT_Input_aTurn;
	PitchAccel = (1 - 2 * DeltaTime) * PitchAccel + DeltaTime * BOT_Input_aLookUp;
	GetAxes(Rotation,X,Y,Z);
	PitchThreshold = 3000;
	Pitch = Rotation.Pitch & 65535;
	if (Pitch > 16384 - PitchThreshold && Pitch < 49152 + PitchThreshold)
	{
		if (Pitch > 49152 - PitchThreshold)
		{
			PitchAccel = Max(PitchAccel, 0);
		}
		else if (Pitch < 16384 + PitchThreshold)
		{
			PitchAccel = Min(PitchAccel,0);
		}
	}
//	Acceleration = Velocity + 5 * (YawAccel * Y + PitchAccel * Z);
	Acceleration = Velocity + 5 * (YawAccel * Y + PitchAccel * Z);
	if (Acceleration == vect(0,0,0))
	{
		Acceleration = Velocity;
	}
	if(Acceleration == vect(0,0,0))
	{
		Acceleration = 4.0 * vector(NewRotation);	/* cuz I fucking take the pawn speed at DriverEnter event */
	}
	if ( ForcedDirectionVolume != None )
	{
		// make sure still touching it
		ForcedDirectionVolume = None;
		ForEach TouchingActors(class'ForcedDirVolume', ForcedDirectionVolume)
		{
			break;
		}
		if ( ForcedDirectionVolume != None )
		{
			Acceleration = ForcedDirectionVolume.ArrowDirection;
		}
	}
	if ( Location.Z > WorldInfo.StallZ )
	{
		Acceleration = Normal(Acceleration);
		Acceleration.Z = -1;
	}

	Acceleration = Normal(Acceleration) * AccelRate;
	Velocity = Normal(Acceleration) * AirSpeed;
	RolledRotation = rotator(Velocity);
	YMag = Acceleration Dot Y;
	if( YMag > 0 )
	{
		RolledRotation.Roll = Min( 6000, 4*YMag);
	}
	else
	{
		RolledRotation.Roll = Max( 59536, 65536 + 4*YMag );
	}

	//smoothly change rotation
	CurrentRoll = Rotation.Roll & 65535;
	if (RolledRotation.Roll > 32768)
	{
		if (CurrentRoll < 32768)
		{
			CurrentRoll += 65536;
		}
	}
	else if (CurrentRoll > 32768)
	{
		CurrentRoll -= 65536;
	}

	SmoothRoll = FMin( 2.0, 2.0 * deltaTime );
	RolledRotation.Roll = float(RolledRotation.Roll) * SmoothRoll + float(CurrentRoll) * (1.0 - SmoothRoll);
	setRotation(RolledRotation);

///	LogInternal(" --- BotDriver_FaceRotation Acceleration="$Acceleration$" Velocity="$Velocity);
}

/* --------------------------------------------------------------------*/

function BotDriver_FaceLocation(float DeltaTime, vector NewLocation)
{
	DestinationOffset = 32.0;
	BotDriver_FaceRotation( rotator(NewLocation - Location), DeltaTime );
}

/* --------------------------------------------------------------------*/

function Actor BotDriver_FilterTargetActor(Actor NewTarget)
{
	local UTBot _Bot;

	if((NewTarget == Self) || (NewTarget == Driver))
	{
		return None;
	}

	_Bot = UTBot(Controller);
	if(_Bot != None)
	{
		if((Pawn(NewTarget)!=None)&&(_Bot.Squad.GetOrders() == 'ATTACK'))
		{
			return None;
		}
	}

	return NewTarget;
}

/* --------------------------------------------------------------------*/

function Actor BotDriver_GetTargetActor()
{
	local UTBot a_MyUTBot;
	local Actor	a_MyTarget;

	/* Get from skynet */
///	LogInternal(" --a1 Hellfire_SkyClient="$Hellfire_SkyClient);
	if( (Hellfire_SkyClient != None) )
	{
///		LogInternal(" --a2 Hellfire_SkyNet.isSkyNetReady()="$Hellfire_SkyNet.isSkyNetReady());
		if(Hellfire_SkyNet.isSkyNetReady())
		{
			a_MyTarget = Hellfire_SkyClient.Get_Current_SkyNode();
			if(a_MyTarget != None)
			{
///				LogInternal(" --- BotDriver_GetTargetActor Get_Current_SkyNode a_MyTarget="$a_MyTarget);

///				return a_MyTarget;
			}
		}
	}

	/* Fallback to the stupid utbot controller */
	a_MyUTBot = UTBot(Controller);
	if(a_MyUTBot != None)
	{
///		LogInternal(" --- BotDriver_GetTargetActor");
///		LogInternal("Self="$Self);
///		LogInternal("Driver="$Driver);
///		LogInternal("a_MyUTBot.MoveTarget="$a_MyUTBot.MoveTarget);
///		LogInternal("a_MyUTBot.ShotTarget="$a_MyUTBot.ShotTarget);
///		LogInternal("a_MyUTBot.Focus="$a_MyUTBot.Focus);

		/* Check for the move target */
		a_MyTarget = BotDriver_FilterTargetActor(a_MyUTBot.MoveTarget);
		if(a_MyTarget != None) return a_MyTarget;

		a_MyTarget = BotDriver_FilterTargetActor(a_MyUTBot.ShotTarget);
		if(a_MyTarget != None) return a_MyTarget;

		a_MyTarget = BotDriver_FilterTargetActor(a_MyUTBot.Focus);
		if(a_MyTarget != None) return a_MyTarget;

		a_MyTarget = BotDriver_FilterTargetActor(a_MyUTBot.Enemy);
		if(a_MyTarget != None) return a_MyTarget;
	}

	return None;
}

/* --------------------------------------------------------------------*/

function BotDriver_Debug_PutMarker(vector pLoc)
{
	Spawn(class'HardPCM__SkyMarker',,,pLoc);
}

/* --------------------------------------------------------------------*/

function vector BotDriver_GetTargetFallbackOffset(Actor Other)
{
	local float len;
	local CylinderComponent a_pCylinderComponent;

	len = 64.0;

	/* use the cylinder */
	a_pCylinderComponent = CylinderComponent(Other.CollisionComponent);
	if(a_pCylinderComponent != None)
	{
		len = FMax(a_pCylinderComponent.CollisionHeight * 1.25, len);
	}

	len = FMin(96.0, len);

	return (len * vect(0,0,1.0));
}

/* --------------------------------------------------------------------*/

function vector BotDriver_GetTargetOffset(Actor Other)
{
	local HardPCM__SkyPointer pSkyPointer, pSkyPointerB;

	if(NavigationPoint(Other) == None)
	{
///		LogInternal("a0");
		return BotDriver_GetTargetFallbackOffset(Other);
	}

	if(BOT_Last_Target != Other)
	{
///		foreach VisibleCollidingActors(Class'HardPCM__SkyPointer', pSkyPointerB, 32.0, Other.Location, False)
		foreach VisibleActors(Class'HardPCM__SkyPointer', pSkyPointerB, 32.0, Other.Location)
		{
			// fuck something big here if you want, :(:O)
			pSkyPointer = pSkyPointerB;
		}
	}
	else
	{
		pSkyPointer = BOT_Last_SkyPointer;
	}
	BOT_Last_Target = Other;
	BOT_Last_SkyPointer = pSkyPointer;

	if(pSkyPointer == None)
	{
///		LogInternal("a1");
		return BotDriver_GetTargetFallbackOffset(Other);
	}
	if(pSkyPointer.My_SkyNode == None)
	{
///		LogInternal("a2");
		return BotDriver_GetTargetFallbackOffset(Other);
	}
///		LogInternal("a3");
	return (pSkyPointer.My_SkyNode.Location - Other.Location);
}

/* --------------------------------------------------------------------*/

function vector BotDriver_GetTargetLocation()
{
	local Actor a_nNextTargetActor;
	local vector a_nNextTargetLocation;

	a_nNextTargetLocation = vect(0,0,655360);

	/* Try to get the target center and pray GOD that there is enought room to go there */
	a_nNextTargetActor = BotDriver_GetTargetActor();
	NextTargetActor = a_nNextTargetActor;

///	if(NextTargetActor != None)	// debug
///	{
///		BotDriver_Debug_PutMarker(NextTargetActor.Location);
///	}

	if(Controller != None)
	{
		Controller.MoveTarget = NextTargetActor;
	}

	if(a_nNextTargetActor != None)
	{
		a_nNextTargetLocation = a_nNextTargetActor.Location;
		if( HardPCM__SkyNode(a_nNextTargetActor) != None )
		{
			return a_nNextTargetLocation;
		}

		a_nNextTargetLocation += BOT_Error_Offset + BotDriver_GetTargetOffset(a_nNextTargetActor);
	}
	else
	{
		
	}

///	LogInternal(" --- BotDriver_GetTargetLocation a_nNextTargetLocation="$a_nNextTargetLocation);

	return a_nNextTargetLocation;
}

/* --------------------------------------------------------------------*/

function BotDriver_TickDriving(float DeltaTime)
{
	if(false)
	{
		BotDriver_FaceLocation( DeltaTime, vect(0,0,655360));
	}
	else
	{
		BotDriver_FaceLocation( DeltaTime, BotDriver_GetTargetLocation() );
	}
}

/* --------------------------------------------------------------------*/
/*  State                                                              */
/* --------------------------------------------------------------------*/

auto state Flying
{
	simulated function FaceRotation(rotator NewRotation, float DeltaTime)
	{
		local vector X,Y,Z;
		local float PitchThreshold, YMag, SmoothRoll;
		local int Pitch, CurrentRoll;
		local PlayerController PC;
		local Rotator RolledRotation;

		PC = PlayerController(Controller);
		if (PC != None && LocalPlayer(PC.Player) != None)
		{
			// process input and adjust acceleration
			YawAccel = (1 - 2 * DeltaTime) * YawAccel + DeltaTime * PC.PlayerInput.aTurn;
			PitchAccel = (1 - 2 * DeltaTime) * PitchAccel + DeltaTime * PC.PlayerInput.aLookUp;
			GetAxes(Rotation,X,Y,Z);
			PitchThreshold = 3000;
			Pitch = Rotation.Pitch & 65535;
			if (Pitch > 16384 - PitchThreshold && Pitch < 49152 + PitchThreshold)
			{
				if (Pitch > 49152 - PitchThreshold)
				{
					PitchAccel = Max(PitchAccel, 0);
				}
				else if (Pitch < 16384 + PitchThreshold)
				{
					PitchAccel = Min(PitchAccel,0);
				}
			}
			Acceleration = Velocity + 5 * (YawAccel * Y + PitchAccel * Z);
			if (Acceleration == vect(0,0,0))
			{
				Acceleration = Velocity;
			}
			if(Acceleration == vect(0,0,0))
			{
				Acceleration = 4.0 * vector(Rotation);	/* cuz I fucking take the pawn speed at DriverEnter event */
			}
			if ( ForcedDirectionVolume != None )
			{
				// make sure still touching it
				ForcedDirectionVolume = None;
				ForEach TouchingActors(class'ForcedDirVolume', ForcedDirectionVolume)
				{
					break;
				}
				if ( ForcedDirectionVolume != None )
				{
					Acceleration = ForcedDirectionVolume.ArrowDirection;
				}
			}
			if ( Location.Z > WorldInfo.StallZ )
			{
				Acceleration = Normal(Acceleration);
				Acceleration.Z = -1;
			}

			Acceleration = Normal(Acceleration) * AccelRate;
			RolledRotation = rotator(Velocity);
			YMag = Acceleration Dot Y;
			if( YMag > 0 )
			{
				RolledRotation.Roll = Min( 6000, 4*YMag);
			}
			else
			{
				RolledRotation.Roll = Max( 59536, 65536 + 4*YMag );
			}

			//smoothly change rotation
			CurrentRoll = Rotation.Roll & 65535;
			if (RolledRotation.Roll > 32768)
			{
				if (CurrentRoll < 32768)
				{
					CurrentRoll += 65536;
				}
			}
			else if (CurrentRoll > 32768)
			{
				CurrentRoll -= 65536;
			}

			SmoothRoll = FMin( 2.0, 2.0 * deltaTime );
			RolledRotation.Roll = float(RolledRotation.Roll) * SmoothRoll + float(CurrentRoll) * (1.0 - SmoothRoll);
			setRotation(RolledRotation);
		}
	}

	//------------------------------------------------------------------

	simulated function Tick(float DeltaTime)
	{
		/* Let the bot do manual driving cuz controller suck */
		if((Role == ROLE_Authority) && (Controller!=None) && (UTBot(Controller)!=None))
		{
			BotDriver_TickDriving(DeltaTime);
		}

		// if on non-owning client or on the server, just face in the same direction as velocity
		else if( (!IsLocallyControlled()) && (!bDriving) )
		{
///			SetRotation(rotator(Velocity));
		}
	}

	//------------------------------------------------------------------

	function SetMovementPhysics()
	{
		if( Physics!=PHYS_Flying )
		{
			SetPhysics(PHYS_Flying);	/// HardPCM.Todo: UTBot call that shit and put the PHYS_Falling
		}
	}

	//------------------------------------------------------------------

	function bool TooCloseToAttack(Actor Other)
	{
		return false;
	}

	//------------------------------------------------------------------

	function bool HasRangedAttack()
	{
		return true;
	}

	//------------------------------------------------------------------

	function bool BotFire(bool bFinished)
	{
		return false;
	}

	//------------------------------------------------------------------

	function bool CanAttack(Actor Other)
	{
		if(Pawn(Other)!=None) return true;
		return false;
	}

	//------------------------------------------------------------------
}

/* --------------------------------------------------------------------*/

simulated function SetInputs(float InForward, float InStrafe, float InUp)
{
	///Super.SetInputs(InForward, InStrafe, InUp);
}

/* --------------------------------------------------------------------*/
/*  Debug                                                              */
/* --------------------------------------------------------------------*/

/**
 * General Debug information
 */
simulated function DisplayDebug(HUD HUD, out float out_YL, out float out_YPos)
{
	local rotator NewRotation;
	local PlayerController PC;
	local string Str;

	local Canvas Canvas;

	Canvas = HUD.Canvas;

	super.DisplayDebug(HUD, out_YL, out_YPos);

	Canvas.DrawColor.R = 32;
	Canvas.DrawColor.G = 255;
	Canvas.DrawColor.B = 32;

	Canvas.SetPos(4,out_YPos);
	Canvas.DrawText("["$Self$"]");
	out_YPos+=out_YL;

	Canvas.SetPos(4,out_YPos);
	Canvas.DrawText("AirSpeed:"$AirSpeed$" AccelRate:"$AccelRate$" VSize(Velocity):"$VSize(Velocity)$" VSize(Acceleration):"$VSize(Acceleration));
	out_YPos+=out_YL;

	NewRotation = rotator(Velocity);
	Canvas.SetPos(4,out_YPos);
	Canvas.DrawText("Velocity.Roll:"$NewRotation.Roll$" Velocity.Yaw:"$NewRotation.Yaw$" Velocity.Pitch:"$NewRotation.Pitch);
	out_YPos+=out_YL;

	Canvas.SetPos(4,out_YPos);
	Canvas.DrawText("YawAccel:"$YawAccel$" PitchAccel:"$PitchAccel$" BOT_Input_aTurn:"$BOT_Input_aTurn$" BOT_Input_aLookUp:"$BOT_Input_aLookUp);
	out_YPos+=out_YL;

	Canvas.SetPos(4,out_YPos);
	Str = "NextTargetActor:"$NextTargetActor;
	if( (HardPCM__SkyNode(NextTargetActor) != None) && (Hellfire_SkyClient!=None) )
	{
		Str = Str$" HardPCM__SkyNode(NextTargetActor).Path_Goal["$Hellfire_SkyClient.My_Goal$"]:"$HardPCM__SkyNode(NextTargetActor).Path_Goal[Hellfire_SkyClient.My_Goal];
	}
	Canvas.DrawText(Str);
	out_YPos+=out_YL;

	PC = PlayerController(Controller);
	if(PC != None)
	{
		Canvas.SetPos(4,out_YPos);
		Canvas.DrawText(" PC.PlayerInput.aTurn:"$PC.PlayerInput.aTurn$" PC.PlayerInput.aLookUp:"$PC.PlayerInput.aLookUp);
		out_YPos+=out_YL;
	}
}

/* --------------------------------------------------------------------*/
/*  defaultproperties                                                  */
/* --------------------------------------------------------------------*/

defaultproperties
{
	BOT_Looking_Distance=64.000000

/// -------------------------------------------------------------------
///   Health
/// -------------------------------------------------------------------

	Health=100
	DriverDamageMult=1.000000

/// -------------------------------------------------------------------
///   Driver
/// -------------------------------------------------------------------

	EyeHeight=1.000000
	BaseEyeHeight=1.000000

	TeamCameraMaterials(0)=None
	TeamCameraMaterials(1)=None

	bNetInitialRotation=True

	bAttachDriver=True
	bDriverIsVisible=True
	bPathfindsAsVehicle=True

	LandMovementState="PlayerFlying"
	DrivingAnim="viper_idle_sitting"

	bCanPickupInventory=True
	InventoryManagerClass=Class'UTGame.UTInventoryManager'

/// -------------------------------------------------------------------
///   Physic
/// -------------------------------------------------------------------

	bDirectHitWall=True
	bSimulateGravity=False

	bCanFly=True
	bCanJump=False
	bCanStrafe=False
	Physics=PHYS_Flying

	AirSpeed=700.000000
	AccelRate=1400.000000

/// -------------------------------------------------------------------
///   Bounce
/// -------------------------------------------------------------------

	Bounce_Count = 0
	Bounce_CountMax = 5

/// -------------------------------------------------------------------
///   Sound
/// -------------------------------------------------------------------

	Sound_Enter=SoundCue'HardPCM_StrangeFlight010_PK.WAV.wahooCue'
	Sound_Exit=SoundCue'HardPCM_StrangeFlight010_PK.WAV.pilotejectCue'
	Sound_Engine=SoundCue'HardPCM_StrangeFlight010_PK.WAV.EnginesCue'

	Sound_Bounce(0)=SoundCue'HardPCM_StrangeFlight010_PK.WAV.bounce4Cue'
	Sound_Bounce(1)=SoundCue'HardPCM_StrangeFlight010_PK.WAV.bounce3Cue'

	Begin Object Class=UTAmbientSoundComponent Name=AudioComponent0 ObjName=AudioComponent0 Archetype=AudioComponent'UTGame.Default__UTAmbientSoundComponent'
		Name="AudioComponent0"
		ObjectArchetype=AudioComponent'UTGame.Default__UTAmbientSoundComponent'
	End Object
	PawnAmbientSound=AudioComponent0

/// -------------------------------------------------------------------
///   Shits
/// -------------------------------------------------------------------

	RedeemerProjClass=Class'HardPCM__UTProj_SFT'

	NetPriority=3.000000

/// -------------------------------------------------------------------
///   Graphic
/// -------------------------------------------------------------------

	Interaction_Class=class'HardPCM__Interaction_SFT'

	Name="Default__HardPCM__Vh_SFT"
	ObjectArchetype=UTRemoteRedeemer'UTGame.Default__UTRemoteRedeemer'
}