class HardPCM__SkyNode extends Actor;

/* ----------------------------------------------------*/
/* XxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxX */
/*                                                     */
/*             This mutator was done by                */
/*             HardPCM Technologies 2010               */
/*                hardpcm666@gmail.com                 */
/*           hardpcmtechnologies.blogspot.com          */
/*                                                     */
/* XxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxX */
/* ----------------------------------------------------*/
/*anti_noob*/

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

var		HardPCM__SkyNode			Next_SkyNode;

/* ------------------------------------------------------------------------------ */

var		HardPCM__SkyNode			Link_Node[8];		/** Next Path */
var		float						Link_Distance[8];	/** Distance from path */
var		float						Link_Radius;

/* ------------------------------------------------------------------------------ */

var		float						Path_Goal[16];		/** Jump Distance from Goal */
var		bool						Path_bGoal;			/** This is a goal? */

var		float						Path_Weight;
var		float						Path_Clearance;

var		vector						Path_Up;
var		vector						Path_Down;

var		int							Path_DeathCount;
var		int							Path_SuccessCount;

var		float						Path_Validity;
var		float						Path_ValidityFactor;

/* ------------------------------------------------------------------------------ */

var		float						Speed_Sugestion;	/** Do I need to stop/accel speed here? */

/* ------------------------------------------------------------------------------ */

var		NavigationPoint				Native_Reference;	/** Used to know from who this path is builded */

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

function Link_Insert(int index, HardPCM__SkyNode n, float dist)
{
	local int i;

	for (i = arrayCount(Link_Node) - 2; i >= index; i--)
	{
		if (Link_Node[i] != none)
		{
			Link_Node[i + 1] = Link_Node[i];
			Link_Distance[i + 1] = Link_Distance[i];
		}
	}

	Link_Node[index] = n;
	Link_Distance[index] = dist;
}

/* ------------------------------------------------------------------------------ */

function Show_Debug_Link()
{
	local int i;

	LogInternal(" --- Show_Debug_Link() Self:"$Self);
	for (i = 0; i < arrayCount(Link_Node); i++)
	{
		LogInternal("     Link_Node["$i$"]:"$Link_Node[i]);
	}
}

/* ------------------------------------------------------------------------------ */

function bool Link_Build(float nRadius)
{
	local HardPCM__SkyNode pSkyNode;
	local int i;
	local float nDistance;
	local bool bNone;

	bNone = true;

	// Use mine if it's set.
	if (Link_Radius > 0)
	{
		nRadius = Link_Radius;
	}

///	LogInternal(" --- Link_Build nRadius="$nRadius);

///	foreach VisibleActors(Class'HardPCM__SkyNode', pSkyNode, nRadius)
	foreach VisibleCollidingActors(Class'HardPCM__SkyNode', pSkyNode, nRadius, Location, true)
	{
		if((pSkyNode != Self) /* && FastTrace(pSkyNode.location, location) */ )
		{
			nDistance = vsize(location - pSkyNode.location);
			bNone = false;
///			LogInternal("     radiusActors pSkyNode="$pSkyNode);
			for (i = 0; i < arrayCount(Link_Node); i++)
			{
				if( (nDistance < Link_Distance[i]) || (Link_Distance[i] == 0) )
				{
					Link_Insert(i, pSkyNode, nDistance);
					break;
				}
			}
		}
	}

	return !bNone;
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

function vector Roof_Place(float dist)
{
	local Actor hit;
	local vector end, hl, hn;

	end = location + vect(0, 0, 1) * dist;
	hit = Trace(hl, hn, end, location, false);
	if (hit != none)
	{
		return hl;
	}
	else
	{
		return end;
	}
}

/* ------------------------------------------------------------------------------ */

function Roof_Rise()
{
///	local vector down, up;

	if(!Path_bGoal)	// Don't rise goal nodes.
	{
		Path_Up = Roof_Place(500);
		Path_Down = Roof_Place(-500);
		Path_Clearance = VSize(Path_Up - Path_Down);

		SetLocation(Path_Down + (Path_Up - Path_Down) * 0.5);
	}
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

function int Path_isDirect(HardPCM__SkyNode pPath)
{
	local int i;

	for (i = 0; i < arrayCount(Link_Node); i++)
	{
		if(Link_Node[i] == pPath)
		{
			return i;
		}
	}

	return 255;
}

/* ------------------------------------------------------------------------------ */

function int Path_isIndirect(int nGoalIndex, int nGoalLevel)
{
	local int i;

	for (i = 0; i < arrayCount(Link_Node); i++)
	{
		if(Link_Node[i] != None)
		{
			if(Link_Node[i].Path_Goal[nGoalIndex] <= nGoalLevel)
			{
				return i;
			}
		}
	}

	return 255;
}

/* ------------------------------------------------------------------------------ */

function Path_Goal_Invalidate()
{
	local int i;

	for (i = 0; i < arrayCount(Link_Node); i++)
	{
		Path_Goal[i] = 2000000000.0;
	}
}

/* ------------------------------------------------------------------------------ */

function float VSize_Distance(Actor a, Actor b)
{
	return VSize(a.Location - b.Location);
}

/* ------------------------------------------------------------------------------ */

function float Path_Goal_Setup(int nGoalIndex, optional float nGoalLevel = 0.0)
{
	local int i;
	local float min;

	min = 2000000000.0;
	for (i = 0; i < arrayCount(Link_Node); i++)
	{
		if(Link_Node[i] != None)
		{
///			LogInternal("   Link_Node[i].Path_Goal[nGoalIndex]:"$Link_Node[i].Path_Goal[nGoalIndex]);
			if(nGoalLevel <= Link_Node[i].Path_Goal[nGoalIndex] + 0.0125)
			{
				Link_Node[i].Path_Goal[nGoalIndex] = nGoalLevel + VSize_Distance(Self, Link_Node[i]);
				if(Link_Node[i].Path_Goal[nGoalIndex] < min)
				{
					min = Link_Node[i].Path_Goal[nGoalIndex];
				}
			}
		}
	}
	return min;
}

/* ------------------------------------------------------------------------------ */

function float Path_Goal_Compute(int nGoalIndex, float nGoalLevel)
{
	local int i;
	local float dst, min;

	/* is Smaller, so don't process it */
	if( Path_Goal[nGoalIndex] + 0.0125 < nGoalLevel )
	{
		return 2000000000.0;
	}

	min = 2000000000.0;
	for (i = 0; i < arrayCount(Link_Node); i++)
	{
		if(Link_Node[i] != None)
		{
			dst = Link_Node[i].Path_Goal_Setup(nGoalIndex, Path_Goal[nGoalIndex] + VSize_Distance(Self, Link_Node[i]));
///			dst = Link_Node[i].Path_Goal_Setup(nGoalIndex, nGoalLevel + VSize_Distance(Self, Link_Node[i]));
///			dst = dst;	/* HardPCM.Todo: shits to be able to loop ouside */
			if(dst < min)
			{
				min = dst;
			}
		}
	}

	return min;
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

event Tick( float DeltaTime )
{
	if(Path_Validity > 0.0)
	{
		Path_Validity -= DeltaTime * Path_ValidityFactor;
		if(Path_Validity < 0.0)
		{
			Path_Validity = 0.0;
		}
	}
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

defaultproperties
{
	Link_Radius=0.0
	Speed_Sugestion=1.0
	Path_ValidityFactor=0.01;

	Link_Distance(0)=65536.0
	Link_Distance(1)=65536.0
	Link_Distance(2)=65536.0
	Link_Distance(3)=65536.0
	Link_Distance(4)=65536.0

	bHidden=False				// must be visible for tracing
	bCollideActors=True			// must be colidable for fast tracing
	bBlockActors=False
	bProjTarget=False

	bStatic=False
	bNoDelete=False
	bGameRelevant=True
	DrawScale=2.0

///	Begin Object Class=SpriteComponent Name=Sprite ObjName=Sprite Archetype=SpriteComponent'Engine.Default__SpriteComponent'
///	  Sprite=Texture2D'EngineResources.S_Note'
///	  HiddenGame=False
///	  AlwaysLoadOnClient=True
///	  AlwaysLoadOnServer=True
///	  Name="Sprite"
///	  ObjectArchetype=SpriteComponent'Engine.Default__SpriteComponent'
///	End Object
///	Components.Add(Sprite)
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

