class HardPCM__SkyClient extends Actor;

/* ----------------------------------------------------*/
/* XxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxX */
/*                                                     */
/*             This mutator was done by                */
/*             HardPCM Technologies 2010               */
/*                hardpcm666@gmail.com                 */
/*           hardpcmtechnologies.blogspot.com          */
/*                                                     */
/* XxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxX */
/* ----------------------------------------------------*/
/*anti_noob*/

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

var		HardPCM__SkyNet				My_SkyNet;

var		HardPCM__SkyNode			My_SkyNode;
var		HardPCM__SkyNode			My_SkyNode_Last[16];
var		float						My_SkyNode_Time;
var		float						My_SkyNode_Period;

var		HardPCM__Vh_SFT				My_Pawn;
var		Controller					My_Controller;
var		int							My_Goal;

/* ------------------------------------------------------------------------------ */

var		int							a_nIndex;
var		HardPCM__SkyNode			a_pSkyNode;

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

function InitializeThat( HardPCM__SkyNet _SkyNet, HardPCM__Vh_SFT _Pawn, Controller _Controller )
{
	My_SkyNet = _SkyNet;
	My_Pawn = _Pawn;
	My_Controller = _Controller;

	GotoState('HardPCM_What_To_Do');
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

function float Square_Distance(Actor a, Actor b)
{
	local vector _d;

	_d = a.Location - b.Location;
	return (_d Dot _d);
}

/* ------------------------------------------------------------------------------ */

function bool Direct_View(Actor a, Actor b)
{
	local Actor hit;
	local vector hl, hn;

	hit = Trace(hl, hn, b.Location, a.Location, false);

	return (hit == none);
}

/* ------------------------------------------------------------------------------ */

function HardPCM__SkyNode Get_SkyNode_Nearest(vector _Location)
{
	local int i, n;
	local float	_Nearest_Distance;
	local float _Current_Distance;
	local HardPCM__SkyNode _Nearest_Node;

	_Nearest_Node = None;
	_Nearest_Distance = 10666999;

	if(My_SkyNet == None) return None;
	if(!My_SkyNet.SkyNet_Ready) return None;
	if(My_Pawn == None) return None;
	n = My_SkyNet.Path_Array_Size;

	for(i = 0; i < n; i++)
	{
		_Current_Distance = Square_Distance(My_Pawn, My_SkyNet.Get_Path_Array(i));
		if(_Nearest_Distance > _Current_Distance)
		{
			if( Direct_View(My_Pawn,My_SkyNet.Get_Path_Array(i)) )
			{
				_Nearest_Distance = _Current_Distance;
				_Nearest_Node = My_SkyNet.Get_Path_Array(i);
			}
		}
	}

	return _Nearest_Node;
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

function HardPCM__SkyNode Get_Current_SkyNode()
{
	return My_SkyNode;
}

/* ------------------------------------------------------------------------------ */

function vector Get_Trace_StartLocation(HardPCM__SkyNode pSN, optional int nGoal = 65536)
{
	return (My_Pawn.Location + (My_Pawn.BOT_Looking_Distance * vector(My_Pawn.Rotation)));
}

/* ------------------------------------------------------------------------------ */

function float Get_SkyNode_Weighting(HardPCM__SkyNode pSN, optional int nGoal = 65536)
{
	local int i, n;
	local float _nSteps;
	local float _nWeighting;
	local HardPCM__SkyNode _My_SkyNode;

	_My_SkyNode = Get_Current_SkyNode();
	if((pSN == None)||(_My_SkyNode==None))
	{
		return -1000000;
	}

///	_nWeighting = (FRand() * 5.0) - 2.5;
	_nWeighting = 0.0;

	if( !FastTrace(My_Pawn.Location, Get_Trace_StartLocation(pSN, nGoal)) )
	{
		_nWeighting -= 2000.0;
	}
///	else if( !FastTrace(My_Pawn.Location, pSN.Location) )
///	{
///		_nWeighting -= 2000.0;
///	}

	if(pSN.Path_bGoal)
	{
		_nWeighting += 5.0;
	}

	/* Add the goal target factor, if one is needed */
	if(nGoal != 65536)
	{
		if(pSN.Path_Goal[nGoal] >= 1999999999.9)
		{
			_nWeighting -= 1000000.0;
		}

		/* Get the delta step jump */
		_nSteps = _My_SkyNode.Path_Goal[nGoal] - pSN.Path_Goal[nGoal];

		/* Jumping is positive, so go to it */
		if(_nSteps > 0.0) { _nWeighting += 10.0; }

		/* Jumping is negative, go away */
		else if(_nSteps < 0.0) { _nWeighting -= 2.0; }

		/* Same level, go away */
		else { _nWeighting -= 1.0; }
	}

	/* Check for the old nodes used, so fucker don"t loop back */
	n = arrayCount(My_SkyNode_Last);
	for(i = 0; i < n; i++)
	{
		if(My_SkyNode_Last[i] == pSN)
		{
			_nWeighting -= 10.0 + ( 64.0 - ((64.0 / float(n)) * float(i)) );
		}
	}

	return _nWeighting;
}

/* ------------------------------------------------------------------------------ */

function HardPCM__SkyNode Next_SkyNode_ToGoal(int nGoal)
{
	local int i;
	local HardPCM__SkyNode _Best_SkyNode;
	local float _SkyNode_Weight, _Best_SkyNode_Weight;

	if(My_SkyNode == None) { return None; }

	_Best_SkyNode = My_SkyNode;
	_Best_SkyNode_Weight = Get_SkyNode_Weighting(My_SkyNode, nGoal) - 5.0;

	for (i = 0; i < arrayCount(My_SkyNode.Link_Node); i++)
	{
		/* Get the weight of the node */
		_SkyNode_Weight = Get_SkyNode_Weighting(My_SkyNode.Link_Node[i], nGoal);

		/* If we found a better node update info */
		if(_SkyNode_Weight > _Best_SkyNode_Weight)
		{
			_Best_SkyNode = My_SkyNode.Link_Node[i];
			_Best_SkyNode_Weight = _SkyNode_Weight;
		}
	}

	/* Return the best, if found one valid */
	if(_Best_SkyNode_Weight > -10000.0)
	{
		return _Best_SkyNode;
	}
	return None;
}

/* ------------------------------------------------------------------------------ */

function bool Validate_SkyNode_ToGoal(int nGoal, HardPCM__SkyNode pSN)
{
	return true;
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

function bool Bot_HasTheFlag()
{
	if(My_Controller == None) return false;
	if(My_Controller.PlayerReplicationInfo == None) return false;

	return My_Controller.PlayerReplicationInfo.bHasFlag;
}

/* ------------------------------------------------------------------------------ */

function Bot_WhatToDoNext()
{
	local int MyTeamIndex;

	if(My_SkyNet == None) return;
	if(My_Pawn == None) return;
	if(My_Controller == None) return;

	if(UTCTFGame(worldInfo.game)!=None)
	{
		MyTeamIndex = My_Controller.GetTeamNum();
		My_Goal = My_SkyNet.Get_Flag_Index(MyTeamIndex, !Bot_HasTheFlag());
		if(My_Goal == 255) My_Goal = 1;
///		LogInternal(" MyTeamIndex:"$MyTeamIndex$" My_Goal:"$My_Goal$" Bot_HasTheFlag:"$Bot_HasTheFlag());
	}
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

function Do_TrackGoal(int g)
{
	My_Goal = g;
	GotoState('HardPCM_Track_Goal');
}

/* ------------------------------------------------------------------------------ */
/*  States                                                                        */
/* ------------------------------------------------------------------------------ */

auto state HardPCM_Idle
{
begin:
	Sleep(0.2);
}

/* ------------------------------------------------------------------------------ */

state HardPCM_What_To_Do
{
begin:
	Sleep(2000000000.0);	// fuck you
///	LogInternal(" HardPCM__SkyClient: === HardPCM_What_To_Do->begin ==================================================== ");
	Sleep(0.2);
	if(true)
	{
		Bot_WhatToDoNext();

		if(My_Pawn == None)
		{
			Destroy();
		}
		Do_TrackGoal(My_Goal);
	}
	Sleep(3600.0);
}

/* ------------------------------------------------------------------------------ */

state HardPCM_Track_Goal
{
begin:
///	LogInternal(" HardPCM__SkyClient: === HardPCM_Track_Goal->begin ==================================================== ");
	if(true)
	{
		/* We must find where we are */
		if( ((My_SkyNode == None)&&(My_SkyNode_Time < WorldInfo.TimeSeconds)) || (!Validate_SkyNode_ToGoal(My_Goal, My_SkyNode)) )
		{
			if(My_Pawn != None)
			{
				My_SkyNode = Get_SkyNode_Nearest(My_Pawn.Location);
			}
			if(My_SkyNode == None)
			{
				GotoState('HardPCM_What_To_Do');
			}
			else
			{
				My_SkyNode_Time = WorldInfo.TimeSeconds + My_SkyNode_Period;
			}
		}
	}
tracking:
///	LogInternal(" HardPCM__SkyClient: === HardPCM_Track_Goal->tracking ==================================================== ");
	if(true)
	{
		/* If we are enought near from node */
		if(Square_Distance(My_Pawn, My_SkyNode) < (262144.0))
		{
			/* We must find the next valid SkyNode */
			a_pSkyNode = Next_SkyNode_ToGoal(My_Goal);
	
			/* If found one try to update */
			if(a_pSkyNode != None)
			{
				My_SkyNode_Last[15] = My_SkyNode_Last[14];
				My_SkyNode_Last[14] = My_SkyNode_Last[13];
				My_SkyNode_Last[13] = My_SkyNode_Last[12];
				My_SkyNode_Last[12] = My_SkyNode_Last[11];
				My_SkyNode_Last[11] = My_SkyNode_Last[10];
				My_SkyNode_Last[10] = My_SkyNode_Last[9];
				My_SkyNode_Last[9] = My_SkyNode_Last[8];
				My_SkyNode_Last[8] = My_SkyNode_Last[7];
				My_SkyNode_Last[7] = My_SkyNode_Last[6];
				My_SkyNode_Last[6] = My_SkyNode_Last[5];
				My_SkyNode_Last[5] = My_SkyNode_Last[4];
				My_SkyNode_Last[4] = My_SkyNode_Last[3];
				My_SkyNode_Last[3] = My_SkyNode_Last[2];
				My_SkyNode_Last[2] = My_SkyNode_Last[1];
				My_SkyNode_Last[1] = My_SkyNode_Last[0];
				My_SkyNode_Last[0] = My_SkyNode;
				My_SkyNode = a_pSkyNode;
				My_SkyNode_Time = WorldInfo.TimeSeconds + My_SkyNode_Period;
			}
			else
			{
				if(My_SkyNode != None)
				{
					My_SkyNode_Last[15] = My_SkyNode_Last[14];
					My_SkyNode_Last[14] = My_SkyNode_Last[13];
					My_SkyNode_Last[13] = My_SkyNode_Last[12];
					My_SkyNode_Last[12] = My_SkyNode_Last[11];
					My_SkyNode_Last[11] = My_SkyNode_Last[10];
					My_SkyNode_Last[10] = My_SkyNode_Last[9];
					My_SkyNode_Last[9] = My_SkyNode_Last[8];
					My_SkyNode_Last[8] = My_SkyNode_Last[7];
					My_SkyNode_Last[7] = My_SkyNode_Last[6];
					My_SkyNode_Last[6] = My_SkyNode_Last[5];
					My_SkyNode_Last[5] = My_SkyNode_Last[4];
					My_SkyNode_Last[4] = My_SkyNode_Last[3];
					My_SkyNode_Last[3] = My_SkyNode_Last[2];
					My_SkyNode_Last[2] = My_SkyNode_Last[1];
					My_SkyNode_Last[1] = My_SkyNode_Last[0];
					My_SkyNode_Last[0] = My_SkyNode;
				}
				My_SkyNode = a_pSkyNode;
			}
		}
	}
finishing:
///	LogInternal(" HardPCM__SkyClient: === HardPCM_Track_Goal->finishing ================================================ ");
	GotoState('HardPCM_What_To_Do');
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

defaultproperties
{
	My_Goal = 65536;
	My_SkyNode_Time = -1000.0;
	My_SkyNode_Period = 15.0;
}

/* ------------------------------------------------------------------------------ */
/*                                                                                */
/* ------------------------------------------------------------------------------ */

