class HardPCM__Interaction_SFT extends Interaction;

/* ----------------------------------------------------*/
/* XxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxX */
/*                                                     */
/*             This mutator was done by                */
/*             HardPCM Technologies 2010               */
/*                hardpcm666@gmail.com                 */
/*           hardpcmtechnologies.blogspot.com          */
/*                                                     */
/* XxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxXxX */
/* ----------------------------------------------------*/
/*anti_noob*/

/* --------------------------------------------------------------------*/
/*                                                                     */
/* --------------------------------------------------------------------*/

var		float									u2m;

var		Canvas									MyCurrentCanvas;

var		PlayerController						MyPlayerController;
var		HardPCM__Vh_SFT							MyPlayerRRC;
//var		HardPCM__UT99_SLHUD						MyPlayerOverHUD;

/* --------------------------------------------------------------------*/

// lists of keybinds that map to the desired commands
var array<name> PrevWeaponKeys;
var array<name> NextWeaponKeys;
var array<name> ForwardKeys;
var array<name> BackwardKeys;
var array<name> StrafeLeftKeys;
var array<name> StrafeRightKeys;
var array<name> JumpKeys;
var array<name> ForwardAxes;
var array<name> StrafeAxes;
var array<name> DuckKeys;

/* --------------------------------------------------------------------*/

// buffered state of the keys
var byte PrevWeaponState;
var byte NextWeaponState;
var byte ForwardState;
var byte BackwardState;
var byte StrafeLeftState;
var byte StrafeRightState;

/* --------------------------------------------------------------------*/

var float	MyLastRenderTime;

/* --------------------------------------------------------------------*/
/*                                                                     */
/* --------------------------------------------------------------------*/

simulated function InitStrangeLove(PlayerController PC, HardPCM__Vh_SFT NewPlayerRRC)
{
	local int i;

///	LogInternal(" --- InitStrangeLove() PC="$PC );
///	ScriptTrace();

	MyPlayerController = PC;
	MyPlayerRRC = NewPlayerRRC;

	if(NewPlayerRRC != None)
	{
//		MyPlayerOverHUD = NewPlayerRRC.Spawn(class'HardPCM__UT99_SLHUD');
//		if(MyPlayerOverHUD != None)
//		{
//			MyPlayerOverHUD.MyVehicle = MyPlayerRRC;
//		}
	}

	/* We are not local? */
	if(PC.PlayerInput == None) return;

	for (i = 0; i < PC.PlayerInput.Bindings.Length; i++)
	{
		if (PC.PlayerInput.Bindings[i].Command ~= "GBA_MoveForward")
		{
			ForwardKeys[ForwardKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_MoveForward assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_Backward")
		{
			BackwardKeys[BackwardKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_Backward assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_StrafeLeft")
		{
			StrafeLeftKeys[StrafeLeftKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_StrafeLeft assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_StrafeRight")
		{
			StrafeRightKeys[StrafeRightKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_StrafeRight assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_Jump")
		{
			JumpKeys[JumpKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_Jump assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_Jump_Gamepad")
		{
			JumpKeys[JumpKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_Jump_Gamepad assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_MoveForward_GamePad")
		{
			ForwardAxes[ForwardAxes.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_MoveForward_GamePad assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_StrafeLeft_GamePad")
		{
			StrafeAxes[StrafeAxes.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_StrafeLeft_GamePad assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_PrevWeapon")
		{
			PrevWeaponKeys[PrevWeaponKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_PrevWeapon assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_NextWeapon")
		{
			NextWeaponKeys[NextWeaponKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_NextWeapon assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
		else if (PC.PlayerInput.Bindings[i].Command ~= "GBA_Duck")
		{
			DuckKeys[NextWeaponKeys.Length] = PC.PlayerInput.Bindings[i].name;
///			LogInternal("found GBA_Duck assigned to : "$PC.PlayerInput.Bindings[i].name);
		}
	}

	return;
}

/* --------------------------------------------------------------------*/

simulated function bool StrangeLoveInputKey(int ControllerId, name Key, EInputEvent EventType, optional float AmountDepressed = 1.f, optional bool bGamepad)
{
	local int i;
	local bool bHandled;

///	LogInternal(" --- StrangeLoveInputKey() ControllerId="$ControllerId );
///	ScriptTrace();

	if(MyPlayerRRC == None)
	{
		return false;
	}

	// handle moving forwards
	for (i = 0; i < ForwardKeys.Length; i++)
	{
		if (Key == ForwardKeys[i])
		{
			if (MyPlayerRRC != none)
			{
				if (EventType == IE_Pressed) ForwardState = 1;
				else if (EventType == IE_Released) ForwardState = 0;
				MyPlayerRRC.ClientProcessLean(ForwardState + BackwardState, StrafeLeftState + StrafeRightState);
			}

			bHandled = true;
			break;
		}
	}
	if (bHandled) return false;

	// handle moving backwards
	for (i = 0; i < BackwardKeys.Length; i++)
	{
		if (Key == BackwardKeys[i])
		{
			if (MyPlayerRRC != none)
			{
				if (EventType == IE_Pressed) BackwardState = -1;
				else if (EventType == IE_Released) BackwardState = 0;
				MyPlayerRRC.ClientProcessLean(ForwardState + BackwardState, StrafeLeftState + StrafeRightState);
			}

			bHandled = true;
			break;
		}
	}
	if (bHandled) return false;

	// handle PrevWeapon
	for (i = 0; i < PrevWeaponKeys.Length; i++)
	{
		if (Key == PrevWeaponKeys[i])
		{
			if (MyPlayerRRC != none)
			{
				if (EventType == IE_Pressed) PrevWeaponState = 1;
				else if (EventType == IE_Released) PrevWeaponState = 0;
				MyPlayerRRC.ServerPrevWeapon(PrevWeaponState);
			}

			bHandled = true;
			break;
		}
	}
	if (bHandled) return false;

	// handle NextWeapon
	for (i = 0; i < NextWeaponKeys.Length; i++)
	{
		if (Key == NextWeaponKeys[i])
		{
			if (MyPlayerRRC != none)
			{
				if (EventType == IE_Pressed) NextWeaponState = -1;
				else if (EventType == IE_Released) NextWeaponState = 0;
				MyPlayerRRC.ServerNextWeapon(NextWeaponState);
			}

			bHandled = true;
			break;
		}
	}
	if (bHandled) return false;

	// handle strafing left
	for (i = 0; i < StrafeLeftKeys.Length; i++)
	{
		if (Key == StrafeLeftKeys[i])
		{
			if (MyPlayerRRC != none)
			{
				if (EventType == IE_Pressed) StrafeLeftState = -1;
				else if (EventType == IE_Released) StrafeLeftState = 0;
				MyPlayerRRC.ClientProcessLean(ForwardState + BackwardState, StrafeLeftState + StrafeRightState);
			}

			bHandled = true;
			break;
		}
	}
	if (bHandled) return false;

	// handle strafing right
	for (i = 0; i < StrafeRightKeys.Length; i++)
	{
		if (Key == StrafeRightKeys[i])
		{
			if (MyPlayerRRC != none)
			{
				if (EventType == IE_Pressed) StrafeRightState = 1;
				else if (EventType == IE_Released) StrafeRightState = 0;
				MyPlayerRRC.ClientProcessLean(ForwardState + BackwardState, StrafeLeftState + StrafeRightState);
			}

			bHandled = true;
			break;
		}
	}
	if (bHandled) return false;

	// handle jumping
	for (i = 0; i < JumpKeys.Length; i++)
	{
		if (Key == JumpKeys[i])
		{
			if (MyPlayerRRC != none)
			{
				if (EventType == IE_Released) MyPlayerRRC.ClientJumpKey(0);
				else if (EventType == IE_Pressed) MyPlayerRRC.ClientJumpKey(1);
			}

			bHandled = true;
			break;
		}
	}
	if (bHandled) return false;

	// handle duck
	for (i = 0; i < DuckKeys.Length; i++)
	{
		if (Key == DuckKeys[i])
		{
			if (MyPlayerRRC != none)
			{
				if (EventType == IE_Released) MyPlayerRRC.ClientDuckKey(0);
				else if (EventType == IE_Pressed) MyPlayerRRC.ClientDuckKey(1);
			}

			bHandled = true;
			break;
		}
	}
	if (bHandled) return false;

	return false;
}

/* --------------------------------------------------------------------*/

simulated function bool StrangeLoveInputAxis(int ControllerId, name Key, float Delta, float DeltaTime, optional bool bGamepad)
{
	local int i;
	local bool bHandled;

///	LogInternal(" --- StrangeLoveInputAxis() ControllerId="$ControllerId );
///	ScriptTrace();

	if(MyPlayerRRC == None)
	{
		return false;
	}

	for (i = 0; i < ForwardAxes.Length; i++)
	{
		if (ForwardAxes[i] == Key)
		{
			if (MyPlayerRRC != none)
			{
				if (Delta > 0.0) MyPlayerRRC.ClientProcessLean(1, 2);
				else if (Delta < 0.0) MyPlayerRRC.ClientProcessLean(-1, 2);
				else MyPlayerRRC.ClientProcessLean(0, 2);
			}
			bHandled = true;
		}
	}
	if (bHandled) return false;

	for (i = 0; i < StrafeAxes.Length; i++)
	{
		if (StrafeAxes[i] == Key)
		{
			if (MyPlayerRRC != none)
			{
				if (Delta > 0.0) MyPlayerRRC.ClientProcessLean(2, -1);
				else if (Delta < 0.0) MyPlayerRRC.ClientProcessLean(2, 1);
				else MyPlayerRRC.ClientProcessLean(2, 0);
			}
			bHandled = true;
		}
	}

	return false;
}

/* --------------------------------------------------------------------*/
/*                                                                     */
/* --------------------------------------------------------------------*/

simulated function Tick(float DeltaTime)
{

}

/* --------------------------------------------------------------------*/
/*                                                                     */
/* --------------------------------------------------------------------*/

/** Inspired by UT99 Botpack.GuidedWarshell. */
function Draw_OneTarget(Actor a, vector x, vector y, vector z)
{
	local float da, dist;
	local int xpos, ypos;
	local vector dir;
	local Color my_color;

	if(a == None) return;

	if(MyPlayerRRC != None) dir = a.location - MyPlayerRRC.Location;
	dist = vsize(dir);
	dir = normal(dir);

	// 1.0 is the middle, 0.7 is edge of screen.
	da = dir dot x;
	if (da > 0.94)
	{
		if( a.isA('PickupFactory') )
		{
			my_color.R = 32;
			my_color.G = 192;
			my_color.B = 32;
			my_color.A = 128;
		}
		else if( a.isA('Pawn') )
		{
			my_color.R = 192;
			my_color.G = 32;
			my_color.B = 32;
			my_color.A = 128;
		}
		else
		{
			my_color.R = 75;
			my_color.G = 200;
			my_color.B = 100;
			my_color.A = 128;
		}

		xpos = 0.5 * MyCurrentCanvas.ClipX * (1 + 1.4 * (dir dot y));
		ypos = 0.5 * MyCurrentCanvas.ClipY * (1 - 1.4 * (dir dot z));

		// Closer is brighter.
		MyCurrentCanvas.drawColor = my_color;

///
		MyCurrentCanvas.SetPos(xpos - 8, ypos + 9);
		MyCurrentCanvas.DrawText(int((dist * u2m)) $ "m");
	}
}

/* --------------------------------------------------------------------*/

function Draw_VisibleTargets()
{
	local Pawn p;
	local PickupFactory i;
	local Objective o;
	local vector x, y, z;

	if(MyPlayerRRC == None) return;
	GetAxes(MyPlayerRRC.Rotation, x, y, z);
	MyCurrentCanvas.font = font'HardPCM_StrangeFlight010_PK.Stuff.sm_Font';

	/* all the fuckers */
	foreach MyPlayerRRC.visibleCollidingActors(class'Pawn', p, 4096,, true)
	{
		Draw_OneTarget(p, x, y, z);
	}

	/* all the pickups */
	foreach MyPlayerRRC.visibleCollidingActors(class'PickupFactory', i, 4096,, true)
	{
		Draw_OneTarget(i, x, y, z);
	}

	/* all the flags */
	foreach MyPlayerRRC.visibleCollidingActors(class'Objective', o, 4096,, true)
	{
		Draw_OneTarget(i, x, y, z);
	}
}

/* --------------------------------------------------------------------*/

event PostRender(Canvas myCanvas)
{
///	LogInternal(" --- PostRender() myCanvas="$myCanvas );

	if(MyPlayerRRC == None) return;
	MyLastRenderTime = MyPlayerRRC.WorldInfo.TimeSeconds;
	MyCurrentCanvas = myCanvas;

	Draw_VisibleTargets();
}

/* --------------------------------------------------------------------*/
/*                                                                     */
/* --------------------------------------------------------------------*/

defaultproperties
{
   u2m=0.024500

   __OnReceivedNativeInputKey__Delegate=Default__HardPCM__Interaction_SFT.StrangeLoveInputKey
   __OnReceivedNativeInputAxis__Delegate=Default__HardPCM__Interaction_SFT.StrangeLoveInputAxis

   Name="Default__HardPCM__Interaction_RedeemerS"
   ObjectArchetype=Interaction'Engine.Default__Interaction'
}

/* --------------------------------------------------------------------*/
/*                                                                     */
/* --------------------------------------------------------------------*/
