class LP_Mutator_Disguise extends UTMutator;

var() StaticMesh playerBox, playerBoxRed, playerBoxBlue;
var() Vector BoxScale;

function ModifyPlayer(Pawn Other)
{
    local StaticMeshComponent BoxAttachment;
    
    if (Other.IsA('UTPawn'))
    {
            BoxAttachment = new(self) class'StaticMeshComponent';
            
            if (WorldInfo.Game.bTeamGame == true)
            {
                if (UTPawn(Other).Controller.PlayerReplicationInfo.Team.TeamIndex == 0)
                {
                    BoxAttachment.SetStaticMesh( playerBoxRed );
                }
                else if (UTPawn(Other).Controller.PlayerReplicationInfo.Team.TeamIndex == 1)
                {
                    BoxAttachment.SetStaticMesh( playerBoxBlue );
                }
            }
            else
            {
                BoxAttachment.SetStaticMesh( playerBox );
            }
            
            UTPawn(Other).AttachComponent(BoxAttachment);
			//UTPawn(Other).Mesh.AttachComponentToSocket(BoxAttachment, UTPawn(Other).GetFamilyInfo().default.HeadShotGoreSocketName); //this is hilarious, but doesn't work quite as well.
            
            BoxAttachment.SetScale3D(boxScale);
    }
    
    super.ModifyPlayer(Other);
}

DefaultProperties
{
    playerBox = StaticMesh'LP_Disguise_Assets.Box'
    playerBoxRed = StaticMesh'LP_Disguise_Assets.Box_Red'
    playerBoxBlue = StaticMesh'LP_Disguise_Assets.Box_Blue'
    boxScale=(X=0.400000,Y=0.400000,Z=0.400000)
}