//=============================================================================
// HealthRegime
//
//everytime one player loses health other or others players receive the same amount of health
//this is how the health is given:
//Vampirism: only the instigator gets the health that the injured loses
//Communism: everyone gets the same amount of extra health (exception made the one who gets injured)
//Meritocracy: the best player gets more health than the second best, and like that until the last one
//Clans: teammates of the injured get the extra amount of health
//Vikings: teammates from the instigator get the extra amount of health
//GoodSamaritan: every player gets health except the injured and the instigator
//
// Contact : theknighteyes@gmail.com
//=============================================================================
class KE_HealthRegime_Rules extends GameRules;

//List of Regimes
const KE_Vampirism = 0;
const KE_Communism = 1;
const KE_GoodSamaritan = 2;
const KE_Clans = 3;
const KE_Vikings = 4;
const KE_Meritocracy = 5;
const KE_MAX_REGIMES = 3; //only implemented counts
//Health top values
const KE_HealthTop = 199;
//Selected Regime
var int KE_SelectedRegime;

function ScoreKill(Controller Killer, Controller Killed)
{
	RandRegime();
	if ( NextGameRules != None )
	{
		NextGameRules.ScoreKill(Killer,Killed);
	}
}

/*
checks the selected regime and gives health following the rules impossed by the regime
*/
function GiveHealth(pawn injured, Controller instigatedBy, int Damage, int SelectedRegime)
{
	`Log("*************HealthRegime Mod GiveHealthSelectedRegime*************"@SelectedRegime);
	switch (SelectedRegime)
	{
		case KE_Vampirism:
			vampirismHealth(injured, instigatedBy, Damage);
			break;
		case KE_Communism:
			communismHealth(injured, instigatedBy, Damage);
			break;
		case KE_GoodSamaritan:
			goodsamaritanHealth(injured, instigatedBy, Damage);
			break;
		case KE_Clans:
			clansHealth(injured, instigatedBy, Damage);
			break;
		case KE_Vikings:
			vikingsHealth(injured, instigatedBy, Damage);
			break;
		case KE_Meritocracy:
			meritocracyHealth(injured, instigatedBy, Damage);
			break;
			default:
			`Log("*************HealthRegime No Regime Selected*************");
			break;
	}
}

/*
vampirism regime
Instigator gets health from damage
*/
function vampirismHealth(pawn injured, Controller instigatedBy, int Damage)
{
	//`Log("*************HealthRegime Mod vampirismhealth*************");
	instigatedBy.Pawn.Health += Damage;
	if (instigatedBy.Pawn.Health > KE_HealthTop)
	{
		instigatedBy.Pawn.Health = KE_HealthTop;
	}
}

/*
communism regime
Every player - except injured - gets equal share of health from damage
*/
function communismHealth(pawn injured, Controller instigatedBy, int Damage)
{
	local Controller aux_controller;
	ForEach DynamicActors(class'Controller', aux_controller)
    {
		if (aux_controller.Pawn != None && aux_controller.Pawn != injured)
		{
			//`Log("*************HealthRegime Mod communismhealth*************");
			aux_controller.Pawn.Health += Damage;
			if (aux_controller.Pawn.Health > KE_HealthTop)
			{
				aux_controller.Pawn.Health = KE_HealthTop;
			}
		}
    }
}

/*
good samaritan regime
Every player - except injured and the instigator- gets equal share of health from damage
*/
function goodsamaritanHealth(pawn injured, Controller instigatedBy, int Damage)
{
	local Controller aux_controller;
	ForEach DynamicActors(class'Controller', aux_controller)
    {
		if (aux_controller.Pawn != None && aux_controller.Pawn != injured && aux_controller.Pawn != instigatedBy.Pawn)
		{
			//`Log("*************HealthRegime Mod goodsamaritanhealth*************");
			aux_controller.Pawn.Health += Damage;
			if (aux_controller.Pawn.Health > KE_HealthTop)
			{
				aux_controller.Pawn.Health = KE_HealthTop;
			}
		}
    }
}

/*
clans regime
teammates of the injured get the extra amount of health
*/
function clansHealth(pawn injured, Controller instigatedBy, int Damage)
{
	//to test
	local Controller aux_controller;
	foreach DynamicActors(class'Controller', aux_controller)
    {
		if (injured.isSameTeam(aux_controller.Pawn))
		{
			aux_controller.Pawn.Health += Damage;
			if (aux_controller.Pawn.Health > KE_HealthTop)
			{
				aux_controller.Pawn.Health = KE_HealthTop;
			}
		}
    }
}

/*
vikings regime
teammates of the instigator get the extra amount of health
*/
function vikingsHealth(pawn injured, Controller instigatedBy, int Damage)
{
	//to test
	local int vikTeamId;
	local Controller aux_controller;
	vikTeamId = instigatedBy.PlayerReplicationInfo.TeamID;
	foreach DynamicActors(class'Controller', aux_controller)
    {
		if (vikTeamId == aux_controller.PlayerReplicationInfo.TeamID)
		{
			aux_controller.Pawn.Health += Damage;
			if (aux_controller.Pawn.Health > KE_HealthTop)
			{
				aux_controller.Pawn.Health = KE_HealthTop;
			}
		}
    }
}

/*
meritocracy regime
A descending amount of health is given to players according to how they are doing
*/
function meritocracyHealth(pawn injured, Controller instigatedBy, int Damage)
{
	//to do
}

/*
over-rides netdamage function. call givehealth and call netdamage for other gamerules
*/
function NetDamage( int OriginalDamage, out int Damage, pawn injured, Controller instigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType )
{
	//`Log( "*************HealthRegime Mod netdamage begin*************");
	if (instigatedBy.Pawn != None)
	{
		//`Log( "*************HealthRegime Mod damage*************" @Damage);
		GiveHealth(injured, instigatedBy, Damage, KE_SelectedRegime);
	}
	if ( NextGameRules != None )
	{
		NextGameRules.NetDamage( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );
	}
	//`Log( "*************HealthRegime Mod netdamage end*************");
}

function RandRegime()
{
	KE_SelectedRegime = rand(KE_MAX_REGIMES);
	`Log("*************HealthRegime Mod RandSelectedRegime*************" @KE_SelectedRegime);
}

defaultproperties
{
	KE_SelectedRegime = KE_Vampirism;
}