//-----------------------------------------------------------
//
//  - Surprise Gift Factory -  EA_SurpriseGift_Rules
//  Written/tested by Erwan Allain (zall1@hotmail.com)
//
//  Coded for Mutator Week/Shee Labs
//
//  The GameRules opens the UIScene and initialises counters
//-----------------------------------------------------------
class EA_SurpriseGift_Rules extends GameRules;


//this represent the fraction of chance to get the surprise  1/nbChance
var int chanceForSurprise;

function ScoreKill(Controller Killer, Controller Killed)
{
 local  UTGameUISceneClient SC;
 local UIScene giftUIscene, outGiftUIScene;
 local EA_SurpriseGift_CounterActor counterTimerActor, updateGiftTimerActor;
 local EA_SurpriseGift_CounterEventObject updateCountDownAction, updateGiftLabelAction;
 local int countDown;
 local float countDownRate, updategiftLabelRate;

 if( PlayerController(killer) != None && killer.PlayerReplicationInfo.PlayerID != killed.PlayerReplicationInfo.PlayerID && Rand(chanceForSurprise) == 0)
 {
    SC = UTGameUISceneClient(class'UIRoot'.static.GetSceneClient());
    if(SC != None)
    {

      //open the scene and retrieve it by the Out Parameter
      giftUIscene = UIScene(DynamicLoadObject("EA_SurpriseGift_Package.EA_SurpriseGift_UIScene", class'Engine.UIScene'));
      SC.OpenScene(giftUIscene, LocalPlayer(PlayerController(killer).Player), outGiftUIScene);

      //set controller
      EA_SurpriseGift_Menu(outGiftUIScene).setPlayerController(PlayerController(killer));

      //initialise rate and countdown
      countDown = class'MWSurprise.EA_SurpriseGift_Mutator'.default.countDownInSecond;
      countDownRate = class'MWSurprise.EA_SurpriseGift_Mutator'.default.counterRateTimer;
      updategiftLabelRate = class'MWSurprise.EA_SurpriseGift_Mutator'.default.giftRateTimer;

      //create the two timers actors
      counterTimerActor = spawn(class'EA_SurpriseGift_CounterActor');
      updateGiftTimerActor  = spawn(class'EA_SurpriseGift_CounterActor');

      //register UIScene and updateLabelCounterTimerActor to the counterTimerActor
      counterTimerActor.addListener(EA_SurpriseGift_CounterEventListener(outGiftUIScene));
      counterTimerActor.addListener(EA_SurpriseGift_CounterEventListener(updateGiftTimerActor));

      //register UIScene to the second timer
      updateGiftTimerActor.addListener(EA_SurpriseGift_CounterEventListener(outGiftUIScene));

      //create the event that will be send through the notify method
      //@see EA_SurpriseGift_CounterEventListener interface
      updateCountDownAction = new(self)class'MWSurprise.EA_SurpriseGift_CounterEventObject';
      updateCountDownAction.eventName="updateCountdown";

      updateGiftLabelAction = new(self)class'MWSurprise.EA_SurpriseGift_CounterEventObject';
      updateGiftLabelAction.eventName="updateGift";

      //launch both timers
      counterTimerActor.initCounter(countDownRate, countDown, updateCountDownAction);
      updateGiftTimerActor.initCounter(updategiftLabelRate, -1, updateGiftLabelAction);

    }
 }

 	if ( NextGameRules != None )
		NextGameRules.ScoreKill(Killer,Killed);

}

defaultproperties
{
  chanceForSurprise = 3;
}