//-----------------------------------------------------------
//
//  - Surprise Gift Factory -  EA_SurpriseGift_Menu
//  Written/tested by Erwan Allain (zall1@hotmail.com)
//
//  Coded for Mutator Week/Shee Labs
//
//  This is the UIScene displayed. It receives notification by
//  counters and update its labels value.
//  It finally gives a gift to the player according to the last
//  gift selection.
//-----------------------------------------------------------
class EA_SurpriseGift_Menu extends UIScene
    implements(EA_SurpriseGift_CounterEventListener);

var UILabel countDownLabel;
var UILabel giftLabel;
var PlayerController pController;

var array<String> giftsLabel[5];

var int selectedGiftIndex;

event SceneActivated(bool bInitialActivation)
{
   super.SceneActivated(bInitialActivation);

   if (bInitialActivation)
   {
     countDownLabel = UILabel(FindChild('EA_SurpriseGift_RemainingTimeLabel_Change', true));
     giftLabel = UILabel(FindChild('EA_SurpriseGift_GiftLabel_Change', true));
   }
}

function setPlayerController(PlayerController PC )
{
  pController = PC;
}

function updateCountDownLabel(String counter)
{
  countDownLabel.setValue(counter);
}

//call every 0.5s to change the gift name
function updateGiftLabel ()
{
  selectedGiftIndex = Rand(5);
  giftLabel.SetValue(giftsLabel[selectedGiftIndex]);
}

function giveGiftToPlayer()
{
   pController.ClientMessage("Player receives the gift: "@giftLabel.getValue());
   switch(selectedGiftIndex)
   {
     case 0: pController.CheatManager.AllAmmo;
             break;
     case 1: pController.CheatManager.GiveWeapon("UTGame.UTWeap_FlakCannon");
             break;
     case 2: pController.CheatManager.GiveWeapon("UTGameContent.UTWeap_Redeemer_Content");
             break;
     case 3: pController.Suicide();
             break;
     case 4: pController.CheatManager.GiveWeapon("UTGame.UTWeap_RocketLauncher");
             break;
   }
   CloseScene(self);
}

//Interface method
function notifyCount(EA_SurpriseGift_CounterEventObject counterEvent)
{
  if(counterEvent.eventName == "updateCountdown")
     updateCountDownLabel(""@counterEvent.countdown@"");

  else if(counterEvent.eventName == "updateGift")
     updateGiftLabel();

  else if(counterEvent.eventName == "stop")
     giveGiftToPlayer();
}


DefaultProperties
{
   giftsLabel[0] = "All Ammo";
   giftsLabel[1] = "Flak Cannon";
   giftsLabel[2] = "Redeemer";
   giftsLabel[3] = "Death";
   giftsLabel[4] = "Rocket Launcher";

   //require if not the window is modal and the counter can't start
   bPauseGameWhileActive=false
}