//-----------------------------------------------------------
//
//  - Surprise Gift Factory -  EA_SurpriseGift_CounterActor
//  Written/tested by Erwan Allain (zall1@hotmail.com)
//
//  Coded for Mutator Week/Shee Labs
//
//  This class uses the mechanism of Listener. It starts a Timer when
//  calling initTimer() then it sends notification to each listeners
//-----------------------------------------------------------
class EA_SurpriseGift_CounterActor extends Actor
   implements (EA_SurpriseGift_CounterEventListener);

var int counter;
var array<EA_SurpriseGift_CounterEventListener>  eventListeners;
var EA_SurpriseGift_CounterEventObject action;

var EA_SurpriseGift_CounterEventObject stopAction;
var bool alwaysLoop;

function postBeginPlay()
{
  super.PostBeginPlay();
  stopAction = new(self)class'MWSurprise.EA_SurpriseGift_CounterEventObject';
  stopAction.eventName="stop";
}

function initCounter(float rate, int nbLoop, EA_SurpriseGift_CounterEventObject act)
{
  counter = nbLoop;
  if(nbLoop == -1)
   alwaysLoop = true;
  else
   alwaysLoop = false;
  action = act;
  setTimer(rate, true);
}

function addListener(EA_SurpriseGift_CounterEventListener listener)
{
  eventListeners.addItem(listener);
}


function Timer()
{
  local int i;
  action.countdown = counter;
  if(counter > -1 || alwaysLoop)
  {
      for(i=0;i<eventListeners.length;i++)
      {
          if( eventListeners[i] != None)
           eventListeners[i].notifyCount(action);
      }
  }
  else
  {
      for(i=0;i<eventListeners.length;i++)
      {
          if( eventListeners[i] != None)
            eventListeners[i].notifyCount(stopAction);
      }
       setTimer(0,false);
  }
  counter --;
}

function notifyCount(EA_SurpriseGift_CounterEventObject counterEvent)
{
  if(counterEvent.eventName == "stop")
     setTimer(0, false);
}

defaultproperties
{
}