//-----------------------------------------------------------
//
//  - Surprise Weapon Factory -  EA_SurpriseFactory_StandardMap
//  Written/tested by Erwan Allain (zall1@hotmail.com)
//
//  Coded for Mutator Week/Shee Labs
//
//  This is the standard implementation of EA_SurpriseFactory_MapInterface
//  It is used to store data which is a pair of key and value
//-----------------------------------------------------------
class EA_SurpriseFactory_StandardMap extends Object
              implements ( EA_SurpriseFactory_MapInterface );

var array<Object> keys;
var array<Object> values;

function Object getValue(Object key)
{
  local int i;
  local int indexFound;

  indexFound = -1;
  for(i=0;i<keys.length;i++)
  {
     if( keys[i] == key)
     {
        indexFound = i;
        break;
     }
  }

  if(indexFound > -1)
    return values[indexFound];

  return none;
}

function put(Object key, Object value)
{
  if(key != None)
  {
    keys.addItem(key);
    values.addItem(value);
  }
}

function int getObjectCount()
{
  return keys.length;
}

function bool containsKey(Object key)
{
   if(keys.find(key) > -1)
     return true;

   return false;
}

function bool containsValue(Object value)
{
   if(values.find(value) > -1)
     return true;

   return false;
}

function dump()
{
  local int i;
  for(i=0;i<keys.length;i++)
    LogInternal("Row "@i@" key: "@keys[i]@" value: "@values[i]);
}
