//-----------------------------------------------------------
//
//  - Surprise Weapon Factory -  EA_SurpriseFactory_Mutator
//  Written/tested by Erwan Allain (zall1@hotmail.com)
//
//  Coded for Mutator Week/Shee Labs
//
//  When the game starts, All WeaponPickup factory are reinitialised
//  randomly. Each new weaponPickup initialised are stored in an array
//  used to initialise randomly AmmoPickup.
//
//  The mutator aims to show how to use, array and interface
//-----------------------------------------------------------
class EA_SurpriseFactory_Mutator extends UTMutator;

var array<class<UTWeapon> > allWeaponClasses[9];
var array<class<UTAmmoPickupFactory> > allAmmoPickupFactory[8];
var EA_SurpriseFactory_MapInterface mapWeaponAmmoClass;

//array filled during WeaponPickupFactory reinitialisation (checkReplacement)
var array<class<UTWeapon> > spawnedWeaponClasses;

event PostBeginPlay()
{
  super.PostBeginPlay();

  initWeaponArray();
  initAmmoArray();
}

/*
 *fill array with weapon class known
 */
function initWeaponArray()
{
	allWeaponClasses[0] = class'UTGameContent.UTWeap_Avril_Content';
	allWeaponClasses[1] = class'UTGameContent.UTWeap_BioRifle_Content';
	allWeaponClasses[2] = class'UTGame.UTWeap_FlakCannon';
	allWeaponClasses[3] = class'UTGame.UTWeap_LinkGun';
	allWeaponClasses[4] = class'UTGame.UTWeap_RocketLauncher';
	allWeaponClasses[5] = class'UTGame.UTWeap_ShockRifle';
    allWeaponClasses[6] = class'UTGame.UTWeap_SniperRifle';
    allWeaponClasses[7] = class'UTGame.UTWeap_Stinger';
  	allWeaponClasses[8] = class'UTGameContent.UTWeap_Redeemer_Content';
}

/*
 *fill array with ammo class known and also linked weapon class to ammo class
 */
function initAmmoArray()
{
    allAmmoPickupFactory[0] = class'UTGameContent.UTAmmo_Avril';
    allAmmoPickupFactory[1] = class'UTGameContent.UTAmmo_BioRifle_Content';
    allAmmoPickupFactory[2] = class'UTGame.UTAmmo_FlakCannon';
    allAmmoPickupFactory[3] = class'UTGame.UTAmmo_LinkGun';
    allAmmoPickupFactory[4] = class'UTGame.UTAmmo_RocketLauncher';
    allAmmoPickupFactory[5] = class'UTGame.UTAmmo_ShockRifle';
    allAmmoPickupFactory[6] = class'UTGame.UTAmmo_SniperRifle';
    allAmmoPickupFactory[7] = class'UTGame.UTAmmo_Stinger';

    mapWeaponAmmoClass = new(self)class'EA_SurpriseFactory_StandardMap';

    mapWeaponAmmoClass.put(allWeaponClasses[0], allAmmoPickupFactory[0]);
    mapWeaponAmmoClass.put(allWeaponClasses[1], allAmmoPickupFactory[1]);
    mapWeaponAmmoClass.put(allWeaponClasses[2], allAmmoPickupFactory[2]);
    mapWeaponAmmoClass.put(allWeaponClasses[3], allAmmoPickupFactory[3]);
    mapWeaponAmmoClass.put(allWeaponClasses[4], allAmmoPickupFactory[4]);
    mapWeaponAmmoClass.put(allWeaponClasses[5], allAmmoPickupFactory[5]);
    mapWeaponAmmoClass.put(allWeaponClasses[6], allAmmoPickupFactory[6]);
    mapWeaponAmmoClass.put(allWeaponClasses[7], allAmmoPickupFactory[7]);
}

function bool CheckReplacement(Actor Other)
{
    local class<UTWeapon> UTNewWeaponClass;
    local class<UTAmmoPickupFactory>  UTNewAmmoPickupFactory;

	if(Other.IsA('UTWeaponPickupFactory'))
    {

       //reinitialise the weapon class
       UTNewWeaponClass = allWeaponClasses[Rand(9)];
       UTWeaponPickupFactory(Other).WeaponPickupClass = UTNewWeaponClass;
       UTWeaponPickupFactory(Other).InitializePickup();

       //store the new weapon class
       if( spawnedWeaponClasses.find(UTNewWeaponClass) == -1)
        spawnedWeaponClasses.addItem(UTNewWeaponClass);
    }
    else if ( Other.IsA('UTAmmoPickupFactory'))
    {
       /* if new weapon classes exist, get randomly one of this weaponclass
        * then in the map<class<UTWeapon>, class<UTAmmoPickupFactory>> retrieve
        * the UTAmmoPickupFactory associated to the current weaponclass
        */
       if(spawnedWeaponClasses.length > 0)
         UTNewAmmoPickupFactory = class<UTAmmoPickupFactory>(mapWeaponAmmoClass.getValue(spawnedWeaponClasses[Rand(spawnedWeaponClasses.Length)]));

       else
         UTNewAmmoPickupFactory =  allAmmoPickupFactory[Rand(8)];

       UTAmmoPickupFactory(Other).TransformAmmoType(UTNewAmmoPickupFactory);
    }

    return true;
}
defaultproperties
{


}