//-----------------------------------------------------------
//
//  - Unreal Heroes -  EA_UnrealHeroes_Mutator
//  Written/tested by Erwan Allain (zall1@hotmail.com)
//
//  Coded for Mutator Week/Shee Labs
//
//  The GameRules that contain all the logic system, attribute or remove
//  Power
//-----------------------------------------------------------
class EA_UnrealHeroes_Rules extends GameRules;

var EA_SurpriseFactory_MapInterface mapControllerPower;
var EA_PowerChooser pChooser;

//affect a power to each controller
function PostBeginPlay()
{
  mapControllerPower = new(self)class'EA_SurpriseFactory_StandardMap';
  pChooser = new(self)class'MWPower.EA_PowerChooser';
  pChooser.initPowers();
}

function ScoreKill(Controller Killer, Controller Killed)
{
  local Controller C;
  local EA_I_HeroesPower power;
  local class<EA_I_HeroesPower> powerClass;

  //Give powers to all controlles if no power found
   ForEach DynamicActors(class'Controller', C)
   {
       if(mapControllerPower.getValue(C) == None)
       {
          powerClass = pChooser.pickAPower();
          if(powerClass != None)
          {
            power =  new(self)powerClass;
            power.applyPower(C);
          }
          mapControllerPower.put(C, power);
       }
   }

   //remove the power of the killed player
   power = mapControllerPower.getValue(Killed);
   if(power != None)
   {
      power.removePower(killed);
      mapControllerPower.removeItemFromKey(killed);
      mapControllerPower.put(killed, none);
   }

  if ( NextGameRules != None )
		NextGameRules.ScoreKill(Killer,Killed);
}


function NetDamage( int OriginalDamage, out int Damage, pawn injured, Controller instigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType )
{

    if ( NextGameRules != None )
		NextGameRules.NetDamage( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );
}

defaultproperties
{

}