//-----------------------------------------------------------
//
//  - Unreal Heroes -  EA_UnrealHeroes_Mutator
//  Written/tested by Erwan Allain (zall1@hotmail.com)
//
//  Coded for Mutator Week/Shee Labs
//
//  When activated, the playerController will receivePower between
//  flying ability, speed and damage increaded. Powers are given randomly
//  at each kill. The power is kept to death.
//-----------------------------------------------------------
class EA_UnrealHeroes_Mutator extends UTMutator
      config(UnrealHeroes);

var class<GameRules> GRClass;

var config int countDownInSecond;
var config float counterRateTimer;
var config float giftRateTimer;


function InitMutator(string Options, out string ErrorMessage)
{
    WorldInfo.Game.AddGameRules(GRClass);

    super.InitMutator(Options, ErrorMessage);
}

DefaultProperties
{
    GRClass=class'MWPower.EA_UnrealHeroes_Rules'
    countDownInSecond = 2
    counterRateTimer = 1.0
    giftRateTimer = 0.2
}