class CH_PowerArmour_GameRules extends GameRules;

var byte DecimalHealth;
var float LastHealth, LastShield, TimeLastHit;
var byte RegenCount[32];

event PreBeginPlay()
{
    SetTimer(0.2, True);
}

function Timer()
{
    local byte i;
    local UTPawn P;
    SetTimer(0.2, true);
    foreach WorldInfo.AllPawns(class'UTPawn', P)
    {
        if (P != none)
        {
            if (P.PlayerReplicationInfo != none)
            {
                i = P.PlayerReplicationInfo.PlayerID;
                `log (""$i);
                RegenCount[i] += 1;
                `log (""$RegenCount[i]);
                if (RegenCount[i] > 25)
                {
                    Regenerate(P);
                }
            }
        }
    }
}

simulated function Regenerate(Pawn P)
{
    if (UTPawn(P) != None)
    {
        if (UTPawn(P).ShieldBeltArmor <= 97)
        {
            UTPawn(P).ShieldBeltArmor += 2;
        }
        else
        {
            if (UTPawn(P).ShieldBeltArmor == 100)
            {
                if (DecimalHealth > 9)
                {
                    UTPawn(P).GiveHealth(1,100);
                    DecimalHealth = 0;
                }
                else
                {
                    DecimalHealth++;
                }
            }
            else
            {
                UTPawn(P).ShieldBeltArmor = 100;
            }
        }
    }
}

function NetDamage( int OriginalDamage, out int Damage, pawn injured, Controller instigatedBy, vector HitLocation, out vector Momentum, class<DamageType> DamageType )
{
    if (instigatedBy.Pawn != none)
    {
        Damage = OriginalDamage * (1 + UTPawn(instigatedBy.Pawn).ShieldBeltArmor / 100);
    }
    if (UTPawn(injured) != none)
    {
        StopRegen(UTPawn(injured));
    }
    if ( NextGameRules != None )
		NextGameRules.NetDamage( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );
}

function StopRegen(Pawn P)
{
    local byte i;
    if (P.PlayerReplicationInfo != none)
    {
        i = P.PlayerReplicationInfo.PlayerID;
        RegenCount[i] = 0;
    }
}

defaultproperties
{
    RegenCount = 0;
    DecimalHealth = 0;
}