//-----------------------------------------------------------
//
//  LP_Flare - Kill Flare
//  Written by Luke 'ambershee' Parkes-Haskell (ambershee@gmail.com)
//
//	Mutator Week One: Light
//	Uses post processing to temporarily flash and blind the player
//-----------------------------------------------------------

class LP_Flare_Rules extends GameRules;

var float FlashTime;
var localplayer LocalPlayer;
var PostProcessSettings FlareSettings, NormalSettings;

function ScoreKill(Controller Killer, Controller Killed)
{
	if ( PlayerController(Killer) != None )
	{
		LocalPlayer = LocalPlayer(PlayerController(Killer).Player);
		LocalPlayer.bOverridePostProcessSettings = true;
		
		NormalSettings.Scene_Highlights.X = LocalPlayer.CurrentPPInfo.LastVolumeUsed.Settings.Scene_Highlights.X;
		NormalSettings.Scene_Highlights.Y = LocalPlayer.CurrentPPInfo.LastVolumeUsed.Settings.Scene_Highlights.Y;
		NormalSettings.Scene_Highlights.Z = LocalPlayer.CurrentPPInfo.LastVolumeUsed.Settings.Scene_Highlights.Z;
		
		FlareSettings.Scene_Highlights.X = 0.f;
		FlareSettings.Scene_Highlights.Y = 0.f;
		FlareSettings.Scene_Highlights.Z = 0.f;

		SetTimer(FlashTime, false);
	}
	if ( NextGameRules != None )
	{
		NextGameRules.ScoreKill(Killer,Killed);
	}
}

function timer()
{
	GotoState('rampup');
}

state Rampup
{
	function Tick(float DeltaTime)
	{
		if (NormalSettings.Scene_Highlights.X < 0)
		{
			if(FlareSettings.Scene_Highlights.X >= NormalSettings.Scene_Highlights.X)
			{
				LocalPlayer.ClearPostProcessSettingsOverride();// - make it compatible with other post process mutators!
				GotoState('');
			}
			else
			{
				FlareSettings.Scene_Highlights.X -= 0.001f;
				FlareSettings.Scene_Highlights.Y -= 0.001f;
				FlareSettings.Scene_Highlights.Z -= 0.001f;
				LocalPlayer.PostProcessSettingsOverride = FlareSettings;
			}
		}
		else
		{
			if(FlareSettings.Scene_Highlights.X <= NormalSettings.Scene_Highlights.X)
			{
				LocalPlayer.ClearPostProcessSettingsOverride();// - make it compatible with other post process mutators!
				GotoState('');
			}
			else
			{
				FlareSettings.Scene_Highlights.X += 0.001f;
				FlareSettings.Scene_Highlights.Y += 0.001f;
				FlareSettings.Scene_Highlights.Z += 0.001f;
				LocalPlayer.PostProcessSettingsOverride = FlareSettings;
			}
		}
	}
}

DefaultProperties
{
	FlashTime = 0.5
}