//-----------------------------------------------------------
//
//  LP_Darkness - Blindness
//  Written by Luke 'ambershee' Parkes-Haskell (ambershee@gmail.com)
//
//	Mutator Week One: Light
//	Uses post processing to artificially darken existing maps and effectively blind the player.
//	Nicked Dave's 'CUSM' AI code to make bots less effective.
//-----------------------------------------------------------

class LP_Darkness_Rules extends GameRules;

var localplayer LocalPlayer;
var PostProcessSettings DarkSettings;

function NavigationPoint FindPlayerStart( Controller Player, optional byte InTeam, optional string incomingName )
{
	if (Player != None)
	{
		LocalPlayer = LocalPlayer(PlayerController(Player).Player);
		
		LocalPlayer.bOverridePostProcessSettings = true;
		
		DarkSettings = LocalPlayer.CurrentPPInfo.LastVolumeUsed.Settings;
		
		DarkSettings.Scene_Desaturation *= 0.5f;
		
		DarkSettings.Scene_HighLights.X -= 0.1f;
		DarkSettings.Scene_HighLights.Y -= 0.1f;
		DarkSettings.Scene_HighLights.Z -= 0.1f;
		
		DarkSettings.Scene_Midtones.X *= 2.5f;
		DarkSettings.Scene_Midtones.Y *= 2.5f;
		DarkSettings.Scene_Midtones.Z *= 2.5f;
		
		DarkSettings.Bloom_Scale *= 5.f;
		
		LocalPlayer.PostProcessSettingsOverride = DarkSettings;
	}
	
	if ( NextGameRules != None )
	{
		return NextGameRules.FindPlayerStart(Player,InTeam,incomingName);
	}

	return None;
}

DefaultProperties
{
}