//-----------------------------------------------------------
//
//  - HTBHTW - Hit The Best Help The Worst
//  Written/tested by Erwan Allain (zall1@hotmail.com)
//
//  Coded for Mutator Week/Shee Labs
//
//  The GameRule Logic works on the scoreKill Method. It gives
//  malus to player who kill the worst player and bonus to player
//  who kill the best player.
//  Malus and Bonus are for now hardCoded in the defaultproperties and have the
//  following values (An UIScene Mutator Configuration could be added):
//    - m_bonus = 2;
//    - m_malus = 2;
//  Each time a scoreKill is performed, the best and worst player are updated
//  They can be recognise into the game by a Green Halo for best player and
//  Red Halo for worst player.
//  This GameRule intends to equilibrate match facing skills player and rookie
//-----------------------------------------------------------
class EA_HTBHTW_Mutator extends UTMutator;

var class<GameRules> GRClass;

function InitMutator(string Options, out string ErrorMessage)
{
    WorldInfo.Game.AddGameRules(GRClass);

    Super.InitMutator(Options, ErrorMessage);
}

DefaultProperties
{
    GRClass=class'MWLight.EA_HTBHTW_Rules'
    name="Default__UTMutator_HTBHTW"
	GroupNames[0]="PLAYERLIGHT"
}