class JetPackAI_default extends JetPackAIBase;

/*
   This is a sample JetPack AI class that does the same default behavior of the
   normal jetpack code.  This can be used as a base for new AI jetpack decision
   making.

   Some notes about custom AI check code by Meowcat

   To use a different AI setup, create a new class that extends JetPackAIBase.uc
   and implement the AIJPTimer function.  In the UT2k4.ini file add a new section
   titled [ym_Jetpack.JetpackYM_Inv] with a setting as follows
   " JetPackAIclass=class'ym_Jetpack.JetPackAI_default' " (for example) or whatever
   custom code package and jetpack decision class is coded.

  The JetPackYM_Inv function "CheckHover()" returns a float value that is roughly
  the height above the ground, after having traced down below the pawn by Hoverheight
  which is only 64uus.  If the return value is postive (> 0.0) then the pawn is
  above the ground (can safely turn off the jetpack), if the return value is negative,
  that means the trace did nto hit anything, and the bot *might be* very high in the
  air (or just a little above the normal hover height....)

  BotActivate() and BotShutdown() turn the jetpack on and off, and also toggles the
  'bCanFly' variable in the bot's pawn, and sets the bot pawn's physics (PHYS_Flying
  or PHYS_Falling), this allows the bot to navigate as if it were flying or back
  to walking.

  The JetpackYM_Inv class has a couple of "spare" variables that can be used by
  subclasses of JetPackAIBase (since this class is never instantiated it cannot
  retain data between function calls...).  These could be used for timers, booleans etc.
  (and yes I understand that with 'bit' manipulator operators (|~^&), you don't really
  need anything aside from floats, but hey I'm trying to make this a little easier
  for folks...)

  access would be like...

  if(JP.fTimerC < JP.Level.TimeSeconds){
     // execute some code
     JP.fTimerC = JP.Level.TimeSeconds + 2.0; // set to execute again in about 2 seconds...
  }

  the variable names are:
  var float fTimerA, fTimerB, fTimerC, fTimerD; // extra floats for custom AI code use
  var int iDataA, iDataB, iDataC, iDataD; // extra ints for custom AI code use
  var bool bBoolA, bBoolB, bBoolC, bBoolD; // extra bools for custom AI code use
*/
// return true if the base class should exit it's own 'tick' function once this
// one is complete. THIS IS NOT CURRENTLY CALLED OR USED....
static function bool AIJPTick(float dt, JetPackYM_Inv JP, Bot MyBot){ return false;}


// return true if the base class should exit it's own 'timer' function once this
// funcrtion is complete... normally this should always return false.
static function bool AIJPTimer(JetPackYM_Inv JP, Bot MyBot, optional out float ReTimer){

    // AI checks for activating
    if(!JP.bJPOn){
         //Activate if falling at a sufficient speed
         if(JP.Instigator.physics==PHYS_Falling && JP.instigator.Velocity.Z < -0.35*JP.instigator.MaxFallSpeed
            && JP.FuelAmt > JP.MINFUELRETRIGGER)
            JP.BotActivate();
         // Activate if enemy is visible, the bot is in combat, the enemy is sort
         // of close (NOT CHECKED YET), we are a kind-of jumpy bot, and randomly do 50% of the time
         if(JP.FuelAmt > JP.MINFUELRETRIGGER && MyBot.Enemy != none && MyBot.EnemyVisible()
           && MyBot.Jumpiness > 0.5 && FRand() > 0.5)
           JP.BotActivate();
    }
    // AI checks for de-activating
    else{
        // turn JP off if we can't see our enemy and are near the ground
        if( (MyBot.Enemy == none || !MyBot.EnemyVisible()) && JP.CheckHover() > 0.0 ){
           JP.BotShutDown();
           return false;
        }
    }
     return false;
}
