class WalkerCraft extends ONSHoverCraft placeable;

#exec OBJ LOAD FILE=..\Sounds\ONSBPSounds.uax
#exec OBJ LOAD FILE=..\Sounds\DW_S.uax

var WalkerLegs Legs;
var DWHinge    LegsHinge;
var float      SpawnHeight;

// want to use my super-cool dynamic skin idea,
// so create clone of shader to deal with it...
var Material RedSpecular,
             BlueSpecular,
             RedIllumination,
             BlueIllumination,
             RedCore,
             BlueCore,
             DamCombiner[6];
var Shader   SourceShader, RunTimeShader;
var Combiner RuntimeSpecular;

// controlled repulsor system
var float     CurrentHeight,
              MaxHeight,
              MinHeight,
              RiseSpeed,
              StandingForce,
              LegLength;

// buffers for position change detect
var vector   Last_Center2D;
var float    Last_Height;
var Material LeftHitMat, RightHitMat, HitMat;

var vector  LegsParkingTargets[3];
var bool    Parking;
var int     MaxShift, MinShift;
var float   NextStepTime, StepDeley;
var Emitter EnergyCore;
var float   LastFireTime, BaroEndTime, NextBaroDamageTime;
var bool    MainLasers;
var vector  RightFireEnd, LeftFireEnd, RightBarrel, LeftBarrel;

var xEmitter LLA, RLA, LLB, RLB;
var Emitter  LLS, RLS, LPB, RPB, BF;
var() Incinerator MainCannon;
var() TurretGun   TurretCannon;

replication
{
 reliable if (Role == ROLE_Authority)
  MainLasers;
}

simulated event PostBeginPlay()
{
 RuntimeSpecular = new class'Combiner';
 RuntimeSpecular.Material1 = Combiner(SourceShader.Specular).Material1;
 RuntimeSpecular.Material2 = Combiner(SourceShader.Specular).Material2;
 RuntimeSpecular.Mask = Combiner(SourceShader.Specular).Mask;
 RuntimeSpecular.CombineOperation = Combiner(SourceShader.Specular).CombineOperation;
 RuntimeSpecular.AlphaOperation = Combiner(SourceShader.Specular).AlphaOperation;
 RunTimeShader = new class'Shader';
 RunTimeShader.Specular = RuntimeSpecular;
 RunTimeShader.Diffuse = SourceShader.Diffuse;
 RunTimeShader.SpecularityMask = SourceShader.SpecularityMask;
 RunTimeShader.SelfIlluminationMask = SourceShader.SelfIlluminationMask;//RuntimeIlluminationMask;
 Skins[0] = RunTimeShader;
 UpdateDiffuse();
 CurrentHeight = MaxHeight;
 Last_Height = CurrentHeight;
 Last_Center2D.X = GetBoneCoords('BodyRoot').Origin.X;
 Last_Center2D.Y = GetBoneCoords('BodyRoot').Origin.Y;
 NextStepTime = Level.TimeSeconds;

 Super.PostBeginPlay();
}

simulated function Tick(float dt)
{
 local byte    NextLeg;
 local float   StepHeight, BestDist, StepSize;
 local vector  StepDestination, TraceStart, TraceEnd, HitNorm;
 local Actor   Ground;
 local rotator Triangulator;
 local float   NewTurretPitch, SelfOffset;
 local rotator NewTurretRot, NewHeadRot, NewTailRot;

 local vector  TrueTargetLoc, TargetLoc, OffsetVector;
 local rotator FireRotator, RightBarrelTurn, LeftBarrelTurn;

 RightBarrelTurn.Roll = Rotation.Roll;
 RightBarrelTurn.Pitch = Rotation.Pitch;
 RightBarrelTurn.Yaw = Rotation.Yaw + 16384;
 LeftBarrelTurn.Roll = Rotation.Roll;
 LeftBarrelTurn.Pitch = Rotation.Pitch;
 LeftBarrelTurn.Yaw = Rotation.Yaw - 16384;

 RightBarrel = GetBoneCoords('PrimaryTurretPitch').Origin + vector(RightBarrelTurn)*120;
 LeftBarrel = GetBoneCoords('PrimaryTurretPitch').Origin  + vector(LeftBarrelTurn)*120;

 if (Controller != none)
  {
   OffsetVector = vect(0, 0, 0);
   OffsetVector.X = -1.0 * TPCamDistance;
   if ((PlayerController(Controller) != none) && (PlayerController(Controller).bBehindView == true))
    TraceStart = Location + (TPCamLookat >> Rotation) + TPCamWorldOffset + (OffsetVector >> Controller.Rotation);
   else
	TraceStart = Location + (FPCamPos >> Rotation) + (FPCamViewOffset >> Controller.Rotation);
   TraceEnd = TraceStart + vector(Controller.Rotation)*60000;
   Trace(TargetLoc, HitNorm, TraceEnd, TraceStart);
   if ((Bot(Controller) != none) && (Bot(Controller).Enemy != none))
    {
     if (Bot(Controller).Enemy.IsA('Vehicle') == true)
      TargetLoc = Bot(Controller).Enemy.Location;
     else
      TargetLoc = Bot(Controller).Enemy.Location + vect(0,0,-1)*Bot(Controller).Enemy.CollisionHeight/2 + Normal(Bot(Controller).Enemy.Velocity)*Bot(Controller).Enemy.CollisionRadius;
    }
   FireRotator.Yaw = Rotation.Yaw;
   FireRotator.Roll = Rotation.Roll;
   FireRotator.Pitch = rotator(TargetLoc - GetBoneCoords('PrimaryTurretPitch').Origin).Pitch;
   SelfOffset = Sqrt(CollisionRadius*CollisionRadius + CollisionHeight*CollisionHeight);
   TraceStart = GetBoneCoords('PrimaryTurretPitch').Origin + vector(FireRotator)*SelfOffset*1.1;
   TraceEnd = TraceStart + vector(FireRotator)*60000;
   Trace(TrueTargetLoc, HitNorm, TraceEnd, TraceStart,,, HitMat);
   if (Trace(RightFireEnd, HitNorm, TrueTargetLoc, RightBarrel + vector(FireRotator)*128,,,RightHitMat) == none)
    {
     RightFireEnd = TrueTargetLoc;
     RightHitMat = HitMat;
    }
   if (Trace(LeftFireEnd, HitNorm, TrueTargetLoc, LeftBarrel + vector(FireRotator)*128,,,LeftHitMat) == none)
    {
     LeftFireEnd = TrueTargetLoc;
     LeftHitMat = HitMat;
    }
   if (MainCannon != none)
    {
     MainCannon.SetLocation(Location);
     MainCannon.LeftFireStart = LeftBarrel + vector(FireRotator)*SelfOffset*1.1;
     MainCannon.RightFireStart = RightBarrel + vector(FireRotator)*SelfOffset*1.1;
     MainCannon.LeftFireDir = Normal(LeftFireEnd - MainCannon.LeftFireStart);
     MainCannon.RightFireDir = Normal(RightFireEnd - MainCannon.RightFireStart);
    }
   NewTurretPitch = Normalize(Rotation).Pitch - Normalize(FireRotator).Pitch;
   NewTurretRot.Pitch = NewTurretPitch;
   NewHeadRot.Pitch = -NewTurretPitch;
   NewTailRot.Pitch = 6000*(CurrentHeight/MaxHeight - 1);
   SetBoneRotation('PrimaryTurret', NewTurretRot);
   SetBoneRotation('Neck1', NewHeadRot);
   SetBoneRotation('Neck2', NewTurretRot);
   SetBoneRotation('head', NewTurretRot);
   SetBoneRotation('Tail', NewTailRot);
  }

 if (BaroEndTime > Level.TimeSeconds)
  {
   if(NextBaroDamageTime < Level.TimeSeconds)
    BaroTrauma();
   if (BF == none)
    BF = Spawn(class'BaroField');
   else
    BF.SetLocation(Location);
  }
 else if (BF != none)
  BF.Kill();

 if (Level.NetMode != NM_Client)
  {
   if (LastFireTime > Level.TimeSeconds)
    MainLasers = true;
   else
    MainLasers = false;
   SetMainLasers(MainLasers);
  }

 if(MainLasers == true)
  UpdateMainLasers();

 if (Legs == none)  // if legs missing
  {
   MakeLegs();
   Legs.TraceParkedLocs(LegsParkingTargets);
   Parking = true;
  }
 else
  {
   if (EnergyCore != none)
    EnergyCore.SetLocation(Legs.Location);
   HeightControll(dt);
   DetectChanges();
   if ((Legs.AreSteady == true) && (Parking == true) && ((bDriving == false) || ((Throttle != 0) || (Steering != 0))))
    ParkLegs();
   if (((Throttle != 0) || (Steering != 0)) && (bDriving == true))
    {
     NextLeg = Legs.ChooseLeg();
     if (NextLeg == 0)
      Triangulator.Yaw = -Rotation.Yaw;
     else if (NextLeg == 1)
      Triangulator.Yaw = Rotation.Yaw - 10923;
     else if (NextLeg == 2)
      Triangulator.Yaw = Rotation.Yaw + 10923;
     BestDist = 128 + Sqrt(LegLength*LegLength - CurrentHeight*CurrentHeight)/2;
     TraceStart = Location + GetWalkDirection()*LegLength + vector(Triangulator)*BestDist;
     TraceStart.Z = TraceStart.Z + LegLength;
     TraceEnd.X = TraceStart.X;
     TraceEnd.Y = TraceStart.Y;
     TraceEnd.Z = TraceStart.Z - 3*LegLength;
     Ground = Trace(StepDestination, HitNorm, TraceEnd, TraceStart);
     if ((Ground == none) || (StepDestination.Z > Location.Z + 256))
      {
       TraceStart = Legs.GetLegLocation(NextLeg) + GetWalkDirection()*LegLength/2;
       TraceEnd.X = TraceStart.X;
       TraceEnd.Y = TraceStart.Y;
       TraceEnd.Z = TraceStart.Z - LegLength;
       Ground = Trace(StepDestination, HitNorm, TraceEnd, TraceStart);
      }
     StepSize = VSize(Legs.GetLegLocation(NextLeg) - StepDestination);
     if ((Ground != none) && (Ground.bWorldGeometry == true) && (StepSize < 6*LegLength) && (StepSize > 0))
      {
       StepHeight = Min(128, VSize(StepDestination - Legs.GetLegLocation(NextLeg)));
       if (NextStepTime < Level.TimeSeconds)
        {
         Legs.StepTo(StepDestination, StepHeight, NextLeg);
         NextStepTime = Level.TimeSeconds + StepDeley;
        }
      }
    }
  }
}

simulated event PostNetReceive()
{
 SetMainLasers(MainLasers);

 Super.PostNetReceive();
}

simulated function SetMainLasers(bool MainLasersState)
{
 if (MainLasersState == true)
  {
   if (LLA == none)
    {
     LLA = Spawn(class'UT3DarkWalker.MainLaserEffectA');
     if (MainCannon != none)
      MainCannon.PlaySound(Sound'CicadaSnds.BellyLaser.BellyLaserFire',,255,,128,32);
    }
   if (RLA == none)
    RLA = Spawn(class'UT3DarkWalker.MainLaserEffectA');
   if (LLB == none)
    LLB = Spawn(class'UT3DarkWalker.MainLaserEffectB');
   if (RLB == none)
    RLB = Spawn(class'UT3DarkWalker.MainLaserEffectB');
   UpdateMainLasers();
  }
 else
  {
   if (LLA != none)
    LLA.Destroy();
   if (RLA != none)
    RLA.Destroy();
   if (LLB != none)
    LLB.Destroy();
   if (RLB != none)
    RLB.Destroy();
   if (LLS != none)
    LLS.Kill();
   if (RLS != none)
    RLS.Kill();
   if (LPB != none)
    {
     LPB.Kill();
     LPB.SoundVolume = 0;
    }
   if (RPB != none)
    {
     RPB.Kill();
     RPB.SoundVolume = 0;
    }
  }
}

simulated function UpdateMainLasers()
{
 if (LLA != none)
  {
   LLA.mSpawnVecA = LeftFireEnd;
   LLA.SetLocation(LeftBarrel);
  }
 if (RLA != none)
  {
   RLA.mSpawnVecA = RightFireEnd;
   RLA.SetLocation(RightBarrel);
  }
 if (LLB != none)
  {
   LLB.mSpawnVecA = LeftFireEnd;
   LLB.SetLocation(LeftBarrel);
  }
 if (RLB != none)
  {
   RLB.mSpawnVecA = RightFireEnd;
   RLB.SetLocation(RightBarrel);
  }

 if ((LeftHitMat != none) && ((LeftHitMat.SurfaceType == EST_Rock) || (LeftHitMat.SurfaceType == EST_Metal)))
  {
   if (LLS == none)
    LLS = Spawn(class'UT3DarkWalker.MetalSparks');
   else
    {
     LLS.SetLocation(LeftFireEnd);
     LLS.SetRotation(Rotator(LeftFireEnd - Location));
    }
  }
 else
  {
   if (LLS != none)
    LLS.Kill();
  }

 if ((RightHitMat != none) && ((RightHitMat.SurfaceType == EST_Rock) || (RightHitMat.SurfaceType == EST_Metal)))
  {
   if (RLS == none)
    RLS = Spawn(class'UT3DarkWalker.MetalSparks');
   else
    {
     RLS.SetLocation(RightFireEnd);
     RLS.SetRotation(Rotator(RightFireEnd - Location));
    }
  }
 else
  {
   if (RLS != none)
    RLS.Kill();
  }

if ((LeftHitMat != none) && (LeftHitMat.SurfaceType != EST_Water))
  {
   if (LPB == none)
    LPB = Spawn(class'UT3DarkWalker.PlasmaBurn',,,LeftFireEnd);
   else
    LPB.SetLocation(LeftFireEnd);
  }
 else
  {
   if (LPB != none)
    {
     LPB.Kill();
     LPB.SoundVolume = 0;
    }
  }

if ((RightHitMat != none) && (RightHitMat.SurfaceType != EST_Water))
  {
   if (RPB == none)
    RPB = Spawn(class'UT3DarkWalker.PlasmaBurn',,,RightFireEnd);
   else
    RPB.SetLocation(RightFireEnd);
  }
 else
  {
   if (RPB != none)
    {
     RPB.Kill();
     RPB.SoundVolume = 0;
    }
  }
}

simulated function vector GetWalkDirection()
{
 local rotator Strafer;
 local vector  WalkDirection;
 if (Controller != none)
  {
   Strafer.Pitch = Controller.Rotation.Pitch;
   Strafer.Roll = Controller.Rotation.Roll;
   Strafer.Yaw = Controller.Rotation.Yaw - 16384;
   WalkDirection = Normal(vector(Controller.Rotation)*Throttle + vector(Strafer)*Steering);
  }
 return WalkDirection;
}

simulated function DetectChanges()
{
 local float  Center2DShift, HeightShift;
 local vector Center2D;

 if (Legs != none)
  {
   Center2D.X = GetBoneCoords('BodyRoot').Origin.X;
   Center2D.Y = GetBoneCoords('BodyRoot').Origin.Y;
   Center2DShift = VSize(Last_Center2D - Center2D);
   HeightShift = abs(Last_Height - CurrentHeight);
   // do something only if parked
   if (Parking != true)
    {
     Legs.TraceParkedLocs(LegsParkingTargets);
     Parking = true;
    }
   if ((Center2DShift > MaxShift) || (HeightShift > MaxShift))
    {

    }
  }
}

// comands to legs here
simulated function ParkLegs()
{
 local float  RealOffsets[3], StepHeights[3];

 RealOffsets[0] = VSize(LegsParkingTargets[0] - Legs.GetLegLocation(0));
 RealOffsets[1] = VSize(LegsParkingTargets[1] - Legs.GetLegLocation(1));
 RealOffsets[2] = VSize(LegsParkingTargets[2] - Legs.GetLegLocation(2));

 StepHeights[0] = Min(128, RealOffsets[0]);
 StepHeights[1] = Min(128, RealOffsets[1]);
 StepHeights[2] = Min(128, RealOffsets[2]);

 if ((RealOffsets[0] >= RealOffsets[1]) && ((RealOffsets[0] >= RealOffsets[2])))
  {
   if (VSize(Legs.GetLegLocation(0) - LegsParkingTargets[0]) > MinShift)
    Legs.StepTo(LegsParkingTargets[0], StepHeights[0], 0);
   Parking = false;
  }
 else if (RealOffsets[1] >= RealOffsets[2])
  {
   if (VSize(Legs.GetLegLocation(1) - LegsParkingTargets[1]) > MinShift)
    Legs.StepTo(LegsParkingTargets[1], StepHeights[1], 1);
   Parking = false;
  }
 else
  {
   if (VSize(Legs.GetLegLocation(2) - LegsParkingTargets[2]) > MinShift)
    Legs.StepTo(LegsParkingTargets[2], StepHeights[2], 2);
   Parking = false;
  }
}

simulated function HeightControll(float dt)
{
 if (bDriving != false)
  {
   if ((Rise > 0) && (CurrentHeight < MaxHeight))
    CurrentHeight = CurrentHeight + RiseSpeed*dt;
   else if ((Rise < 0) && (CurrentHeight > MinHeight))
    CurrentHeight = CurrentHeight - RiseSpeed*dt;
  }
 else
  {
   if (CurrentHeight > MinHeight)
    CurrentHeight = CurrentHeight - RiseSpeed*dt/5;
  }

 KarmaParams(KParams).Repulsors[0].CheckDist = CurrentHeight;
}

simulated event TeamChanged()
{
 Super.TeamChanged();
 UpdateDiffuse();
}

function BaroTrauma()
{
 local Pawn   Victim;
 local float  DistK;
 local vector VMomentum;

 NextBaroDamageTime = Level.TimeSeconds + 0.1;
 foreach RadiusActors(class'Pawn', Victim, 1024, Location - vect(0,0,128))
  {
   if (Victim.GetTeamNum() != GetTeamNum())
    {
     DistK = 1 - VSize(Victim.Location - Location)/1024;
     VMomentum = Normal(Victim.Location - Location)*DistK*10000;
     if (VMomentum.Z < 0)
      VMomentum.Z = -VMomentum.Z;
     if ( (OnsVehicle(Victim) != none) && (Vehicle(Victim).Driver != none) && (OnsVehicle(Victim).VehicleMass < 6))
      Vehicle(Victim).EjectDriver();
     Victim.TakeDamage(30*DistK, self, Victim.Location, VMomentum, class'UT3DarkWalker.Bbarotrauma');
    }
  }
}

function ServerPlayHorn(int HornIndex)
{
 if ( (Level.TimeSeconds > BaroEndTime) && (MainCannon != none))
  {
   if (MainCannon.Charge >= 3)
    {
     PlaySound( Sound'DW_S.Long01',, 255,, 2048);
     MainCannon.Charge = MainCannon.Charge - 3;
     BaroEndTime = Level.TimeSeconds + 7;
    }
   else if (MainCannon.Charge >= 1)
    {
     PlaySound( Sound'DW_S.Short02',, 255,, 2048);
     MainCannon.Charge = MainCannon.Charge - 1;
     BaroEndTime = Level.TimeSeconds + 2;
    }

  }
}
simulated event DrivingStatusChanged()
{
 if (bDriving == true)
  {
   if ((Controller != none) && (Bot(Controller) != none))
    {
     CurrentHeight = MaxHeight*0.75;
     Last_Height = CurrentHeight;
    }
   UpdateDiffuse();
  }
 else
  UpdateDiffuse();
}

function TakeDamage(int Damage, Pawn instigatedBy, Vector Hitlocation, Vector Momentum, class<DamageType> DamageType)
{
 UpdateDiffuse();

 Super.TakeDamage(Damage, instigatedBy, Hitlocation, Momentum, damageType);
}

simulated function UpdateDiffuse()
{
 local byte DamageLevel;

 DamageLevel = byte(5.0*(1.0 - Health/HealthMax));
 if (DamCombiner[DamageLevel] != none)
  RunTimeShader.Diffuse = DamCombiner[DamageLevel];

 if( GetTeamNum() == 0)
  {
   RuntimeSpecular.Material2 = RedSpecular;
   if (bDriving == true)
    RunTimeShader.SelfIllumination = RedIllumination;
   else
    RunTimeShader.SelfIllumination = none;
   if (Legs != none)
    Legs.Skins[1] = RedCore;
  }
 else
  {
   RuntimeSpecular.Material2 = BlueSpecular;
   if (bDriving == true)
    RunTimeShader.SelfIllumination = BlueIllumination;
   else
    RunTimeShader.SelfIllumination = none;
   if (Legs != none)
    Legs.Skins[1] = BlueCore;
  }
}

simulated event SetInitialState()
{
  Super.SetInitialState();

  Enable('Tick');
}

/// here only spawn and attach legs
simulated function MakeLegs()
{
 local vector SpawnLoc;

 SpawnLoc = GetBoneCoords('BodyRoot').Origin;

 Legs = Spawn(class'WalkerLegs', self,, SpawnLoc, Rotation);
 Legs.Skins[0] = Skins[0];
 if (EnergyCore == none)
  EnergyCore = Spawn(class'UT3DarkWalker.CoreFlare',,,GetBoneCoords('BodyRoot').Origin);

 if (LegsHinge == none)
  LegsHinge = Spawn(class'DWHinge', self,, SpawnLoc, Rotation);
 LegsHinge.KConstraintBone1 = 'Root';
 LegsHinge.KConstraintActor1 = Legs;
 LegsHinge.KConstraintBone2 = 'BodyRoot';
 LegsHinge.KConstraintActor2 = self;
 UpdateDiffuse();
 Last_Center2D.X = GetBoneCoords('BodyRoot').Origin.X;
 Last_Center2D.Y = GetBoneCoords('BodyRoot').Origin.Y;
}

simulated function Destroyed()
{
 MainLasers = false;

 Disable('Tick');

 if (LegsHinge != none)
  LegsHinge.Destroy();

 if (EnergyCore != none)
  EnergyCore.Kill();

 if (LLA != none)
  LLA.Destroy();
 if (RLA != none)
  RLA.Destroy();
 if (LLB != none)
  LLB.Destroy();
 if (RLB != none)
  RLB.Destroy();
 if (BF != none)
  BF.Destroy();
 if (LLS != none)
  LLS.Kill();
 if (RLS != none)
  RLS.Kill();
 if (LPB != none)
  {
   LPB.Kill();
   LPB.SoundVolume = 0;
  }
 if (RPB != none)
  {
   RPB.Kill();
   RPB.SoundVolume = 0;
  }

 Super.Destroyed();
}

function bool RecommendLongRangedAttack()
{
	return true;
}

function bool ImportantVehicle()
{
	return true;
}

function AltFire(optional float F)
{
	local PlayerController PC;

	PC = PlayerController(Controller);
	if (PC == None)
		return;

	bWeaponIsAltFiring = true;
    PC.ToggleZoomWithMax(0.5);
}

function ClientVehicleCeaseFire(bool bWasAltFire)
{
	local PlayerController PC;

	if (!bWasAltFire)
	{
		Super.ClientVehicleCeaseFire(bWasAltFire);
		return;
	}

	PC = PlayerController(Controller);
	if (PC == None)
		return;

	bWeaponIsAltFiring = false;
    PC.EndZoom();
}

defaultproperties
{
     SpawnHeight=544.000000
     RedSpecular=Texture'DW_T.textures.DW_Red_Specular'
     BlueSpecular=Texture'DW_T.textures.DW_Blue_Specular'
     RedIllumination=ConstantColor'DW_T.Combiners.Red'
     BlueIllumination=ConstantColor'DW_T.Combiners.Blue'
     RedCore=FinalBlend'DW_T.Cores.RedCore'
     BlueCore=FinalBlend'DW_T.Cores.BlueCore'
     DamCombiner(0)=Texture'DW_T.textures.DW_Diffuse'
     DamCombiner(1)=Combiner'DW_T.Dam_Combiners.Dam_Level_0'
     DamCombiner(2)=Combiner'DW_T.Dam_Combiners.Dam_Level_1'
     DamCombiner(3)=Combiner'DW_T.Dam_Combiners.Dam_Level_2'
     DamCombiner(4)=Combiner'DW_T.Dam_Combiners.Dam_Level_3'
     DamCombiner(5)=Combiner'DW_T.Dam_Combiners.Dam_Level_4'
     SourceShader=Shader'DW_T.Combiners.DefaultSkin'
     MaxHeight=512.000000
     MinHeight=128.000000
     CurrentHeight = 128;
     Last_Height = 128;
     RiseSpeed=256.000000
     StandingForce=1000.000000
     LegLength=600.000000
     MaxShift=64
     MinShift=16
     MaxLights=64
     StepDeley=0.500000
     HoverSoftness=0.0
     HoverPenScale=1.000000
     HoverCheckDist=512.000000
     UprightStiffness=30000.000000
     UprightDamping=300.000000
     MaxThrustForce=600.000000
     LongDamping=0.020000
     MaxStrafeForce=600.000000
     TurnTorqueFactor=5000.000000
     TurnTorqueMax=1000.000000
     TurnDamping=300.000000
     MaxYawRate=1.000000
     bHasAltFire=False
     IdleSound=Sound'GeneralAmbience.aliendrone2'
     StartUpSound=Sound'ONSBPSounds.ShockTank.EngineRampDown'
     ShutDownSound=Sound'ONSBPSounds.ShockTank.EngineRampDown'
     SoundVolume=255
     SoundRadius=600
     SoundPitch=64
     TransientSoundRadius=1200
     DriverWeapons(0)=(WeaponClass=Class'UT3DarkWalker.Incinerator',WeaponBone="BodyRoot")
     PassengerWeapons(0)=(WeaponPawnClass=Class'UT3DarkWalker.TurretPawn',WeaponBone="BodyRoot")
     VehicleMass=6.000000
     bTurnInPlace=True
     bDrawMeshInFP=True
     bFPNoZFromCameraPitch=True
     DrivePos=(X=50.000000,Z=60.000000)
     EntryRadius=380.000000
     FPCamPos=(X=300.000000,Z=150.000000)
     TPCamDistance=700.000000
     TPCamLookat=(X=100.000000,Z=0.000000)
     TPCamWorldOffset=(Z=300.000000)
     TPCamDistRange=(Min=300.000000,Max=2500.000000)
     ShadowCullDistance=8000.000000
     DriverDamageMult=0.000000
     VehiclePositionString="in Dark Walker"
     VehicleNameString="Dark Walker"
     MaxDesireability=0.800000
     bCanStrafe=True
     MeleeRange=1024.000000
     NavigationPointRange=64.000000
     GroundSpeed=800.000000
     HealthMax=1200.000000
     Health=1200
     bAlwaysRelevant=True
     NetUpdateFrequency=30.000000
     Mesh=SkeletalMesh'DW_A.Chassis'
     CollisionRadius=320.000000
     CollisionHeight=128.000000
     bNetNotify=True
     ColLocation=(Z=-450.000000)
     ThrusterOffsets(0)=(X=0.0,Y=0.0,Z=0.0)
     Begin Object Class=KarmaParamsRBFull Name=KParams0
         KInertiaTensor(0)=1.300000
         KInertiaTensor(3)=4.000000
         KInertiaTensor(5)=4.500000
         KLinearDamping=1.000000
         KAngularDamping=1.000000
         KStartEnabled=True
         bHighDetailOnly=False
         bClientOnly=False
         bKDoubleTickRate=True
         bKStayUpright=True
         bKAllowRotate=True
         bDoSafetime=True
         KFriction=1.000000
         KImpactThreshold=1000.000000
     End Object
     KParams=KarmaParamsRBFull'UT3DarkWalker.WalkerCraft.KParams0'

}
