class TurretPawn extends ONSWeaponPawn;

function AltFire(optional float F)
{
	local PlayerController PC;

	PC = PlayerController(Controller);
	if (PC == None)
		return;

	bWeaponIsAltFiring = true;
    PC.ToggleZoomWithMax(0.5);
}

function ClientVehicleCeaseFire(bool bWasAltFire)
{
	local PlayerController PC;

	if (!bWasAltFire)
	{
		Super.ClientVehicleCeaseFire(bWasAltFire);
		return;
	}

	PC = PlayerController(Controller);
	if (PC == None)
		return;

	bWeaponIsAltFiring = false;
    PC.EndZoom();
}

simulated function ClientKDriverLeave(PlayerController PC)
{
	Super.ClientKDriverLeave(PC);

	bWeaponIsAltFiring = false;
	PC.EndZoom();
}

defaultproperties
{
     GunClass=Class'UT3DarkWalker.TurretGun'
     bHasAltFire=False
     CameraBone="SecondaryTurretPitch"
     DrivePos=(X=120.000000,Z=8.000000)
     ExitPositions(0)=(X=-235.000000)
     ExitPositions(1)=(Y=165.000000)
     ExitPositions(2)=(Y=-165.000000)
     ExitPositions(3)=(Z=100.000000)
     EntryPosition=(X=-50.000000)
     EntryRadius=160.000000
     FPCamViewOffset=(X=42.000000)
     TPCamDistance=32.0
     TPCamLookat=(X=300.000000,Z=75.000000)
     DriverDamageMult=0.600000
     bDrawDriverInTP=True
     VehiclePositionString="in a Dark Walker's turret"
     VehicleNameString="Dark Walker Rear Turret"
}
