//-----------------------------------------------------------
//
//-----------------------------------------------------------
class Incinerator extends ONSWeapon;

var float  Charge, MaxCharge, ChargeSpeed, LastFireTime;
var bool   Charged;
var vector LeftFireStart, RightFireStart, LeftFireDir, RightFireDir;

replication
{
 reliable if (Role == ROLE_Authority)
  Charge, Charged;
}

simulated event PostBeginPlay()
{
 WalkerCraft(Owner).MainCannon = self;

 Super.PostBeginPlay();
}

simulated function float ChargeBar()
{
 return Charge/MaxCharge;
}

simulated function Tick(float dt)
{
 if ((Level.NetMode != NM_Client) && (LastFireTime < Level.TimeSeconds))
  {
   if (Charge <= MaxCharge)
    {
     if (Charge > 1)
      {
       Charged = true;
       Charge = Charge + dt*ChargeSpeed;
      }
     else
       Charge = Charge + dt*ChargeSpeed*3;
    }
  }

 Super.Tick(dt);
}

state ProjectileFireMode
{
 function Fire(Controller C)
  {
   if (Level.NetMode != NM_Client)
    {
     if ((Bot(C) != none) && (Bot(C).Enemy != none) && (VSize(Bot(C).Enemy.Location - WalkerCraft(Owner).Location)< 756))
      WalkerCraft(Owner).ServerPlayHorn(0);
     else
      {
       if ((Charged == true) && (Charge > FireInterval))
        {
         LastFireTime = Level.TimeSeconds + FireInterval*2;
         Charge = Charge - FireInterval;
         WalkerCraft(Owner).LastFireTime = LastFireTime;
         Spawn(Class'UT3DarkWalker.HiddenPlasma',,,LeftFireStart,Rotator(LeftFireDir)).Velocity = LeftFireDir*1000000;
         Spawn(Class'UT3DarkWalker.HiddenPlasma',,,RightFireStart,Rotator(RightFireDir)).Velocity = RightFireDir*1000000;
        }
       else
        Charged = false;
      }
    }

   Super.Fire(C);
  }

 function AltFire(Controller C)
  {

  }
}

defaultproperties
{
  AIInfo(0)=(bTrySplash=True,bLeadTarget=True,WarnTargetPct=0.9,RefireRate=1.1)
  Charge=3.000000
  MaxCharge=3.000000
  ChargeSpeed=0.35
  Charged=True
  PitchUpLimit=6000
  PitchDownLimit=55500
  bShowChargingBar=True
  bShowAimCrosshair=False
  FireInterval=0.1
  AltFireInterval=0.1
  bHidden=True
  NetUpdateFrequency=30.000000
  Mesh=SkeletalMesh'DW_A.Chassis'
}
