class HiddenPlasma extends Projectile;

simulated function Landed( vector HitNormal )
{
	Explode(Location,HitNormal);
}

simulated function ProcessTouch (Actor Other, Vector HitLocation)
{
	if ( (Other != instigator) && (!Other.IsA('Projectile') || Other.bProjTarget) )
		Explode(HitLocation, vector(rotation)*-1 );
}

function BlowUp(vector HitLocation)
{
 HurtRadius(Damage, DamageRadius, MyDamageType, MomentumTransfer, HitLocation );
 MakeNoise(1.0);
}

simulated function Explode(vector HitLocation, vector HitNormal)
{
 BlowUp(HitLocation);
 Destroy();
}

defaultproperties
{
 Damage=30.000000
 DamageRadius=256
 MyDamageType=Class'UT3DarkWalker.DamTypeWalkerPlasma'
 LightType=LT_Steady
 LightEffect=LE_QuadraticNonIncidence
 LightHue=28
 LightBrightness=255.000000
 LightRadius=5.000000
 DrawType=DT_StaticMesh
 DrawScale=0
 StaticMesh=StaticMesh'WeaponStaticMesh.RocketProj'
 bDynamicLight=True
 LifeSpan=8.000000
}
