class Drak_Walker_Replacer extends Mutator config;

var() config string ReplacedVehicleClassName;

static function FillPlayInfo(PlayInfo PlayInfo)
{
 local array<CacheManager.VehicleRecord> Recs;
 local string VehicleOptions;
 local int i;

 Super.FillPlayInfo(PlayInfo);

 class'CacheManager'.static.GetVehicleList(Recs);
 for (i = 0; i < Recs.Length; i++)
 {
  if (VehicleOptions != "")
   VehicleOptions $= ";";
  VehicleOptions $= Recs[i].ClassName $ ";" $ Recs[i].FriendlyName;
 }

 PlayInfo.AddSetting(default.RulesGroup, "ReplacedVehicleClassName", "Replace this with Walking Death", 0, 1, "Select", VehicleOptions);
}

function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
 local ONSVehicleFactory Factory;
 local class<Vehicle>    ReplacedVehicleClass;
 local vector            NewSpawnLoc;

 if(ONSVehicleFactory(Other) != none)
  {
   Factory = ONSVehicleFactory(Other);
   if(ReplacedVehicleClassName != "")
    ReplacedVehicleClass = class<SVehicle>(DynamicLoadObject(ReplacedVehicleClassName, class'Class'));
   if (Factory.VehicleClass == ReplacedVehicleClass)
    {
     NewSpawnLoc = Factory.Location;
     NewSpawnLoc.Z = NewSpawnLoc.Z + Class'UT3DarkWalker.WalkerCraft'.default.SpawnHeight;
     Factory.SetLocation(NewSpawnLoc);
     Factory.VehicleClass = Class'UT3DarkWalker.WalkerCraft';
    }
  }

 return true;
}

DefaultProperties
{
 FriendlyName="UT3 Dark Walker"
 Description="Replace any vehicle with the UT3 Dark Walker. Keep in mind that in many maps there is not enough space for Dark Wlker at vehicle spawn places."
}
