//============================================================
// UT3 Viper (NecrisManta)
// Credits: 100GPing100(zeluis)
// Copytight zeluis, 2011
// Contact: zeluis.100@gmail.com
//============================================================
class UT3Viper2v extends ONSHoverBike;

#exec OBJ LOAD FILE=..\Animations\UT3VehiclesAnims.ukx
#exec OBJ LOAD FILE=..\Textures\UT3VehiclesTex.utx
#exec OBJ LOAD FILE=..\StaticMeshes\UT3Vehicles-SM.usx
#exec audio import group=UT3Viper file=..\Sounds\UT3Vehicles\UT3Viper_StartUp.wav
#exec audio import group=UT3Viper file=..\Sounds\UT3Vehicles\UT3Viper_ShutDown.wav
#exec audio import group=UT3Viper file=..\Sounds\UT3Vehicles\UT3Viper_Idle.wav
#exec audio import group=UT3Viper file=..\Sounds\UT3Vehicles\UT3Viper_Jump.wav

var float BoostForce;
var bool bEjected;

var int SelfDestructDamage;
var int SelfDestructDamageRadius;
var class<DamageType> SelfDestructDamageType;
var int SelfDestructMomentum;

// for the airhover stuff
var() float ReducAccelRate;
var() float NormAccelRate;

function selfdestruct()
{
	 if (bWeaponIsAltFiring)
	 {
		 GoToState('Ejecting');
		 return;
	 }
}

simulated state Ejecting{
Begin:
	 SuperEjectDriver();
	 bEjected = True;
	 Sleep(1.0);
	 HurtRadius(SelfDestructDamage, SelfDestructDamageRadius, SelfDestructDamageType, SelfDestructMomentum, Location);
     TakeDamage(SelfDestructDamage*3, Self, Location, vect(0,0,0), SelfDestructDamageType);
}

simulated state EjectReady{
Begin:
	 Sleep(1.0);
	 selfdestruct();
}

function SuperEjectDriver()
{
    local Pawn      OldPawn;
    local vector    EjectVel;
    local UT3ViperSelfDestructInv Inv;
    local UT3ViperEjectionInv Inv2;

    OldPawn = Driver;

    KDriverLeave( true );

    if ( OldPawn == None )
        return;

    EjectVel    = VRand();
    EjectVel.Z  = 0;
    EjectVel    = (Normal(EjectVel)*0.2 + Vect(0,0,1)) * EjectMomentum;

    OldPawn.Velocity = EjectVel;

    //Create our inventory items to absorb the self-destruct damage and some falling damage
    Inv = spawn(class'UT3ViperSelfDestructInv', OldPawn,,, rot(0,0,0));
    Inv.GiveTo(OldPawn);
    Inv2 = spawn(class'UT3ViperEjectionInv', OldPawn,,, rot(0,0,0));
    Inv2.GiveTo(OldPawn);


    OldPawn.SpawnTime = Level.TimeSeconds;
    OldPawn.PlayTeleportEffect( false, false);
}

// END
simulated function KApplyForce(out vector Force, out vector Torque)
{
	local KarmaParams KP;
	local bool bOnGround;
	local int i;

	KP = KarmaParams(KParams);
	 
	bOnGround = false;
	for(i=0; i<KP.Repulsors.Length; i++)
	{
		if( KP.Repulsors[i] != None && KP.Repulsors[i].bRepulsorInContact )
			bOnGround = true;
	}

	Super.KApplyForce(Force, Torque);

	if (bDriving && JumpCountdown > 0.0)
	{
		Force += vect(0,0,1) * JumpForceMag;
	}

	if (bDriving && bHoldingDuck)
	{
		Force += vect(0,0,-1) * DuckForceMag;
	}
	
	if (bEjected)
	{
	//Force += vector(Rotation);
    Force += vector(Rotation); // get direction of vehicle 
		Force += Normal(Force) * BoostForce; // apply force in that direction
	}
}

Function AltFire(optional float F)
{
	 //avoid sending altfire to weapon
	 Super(Vehicle).AltFire(F);
}

Function ClientVehicleCeaseFire(bool bWasAltFire)
{
	 //avoid sending altfire to weapon
	 if (bWasAltFire)
		 Super(Vehicle).ClientVehicleCeaseFire(bWasAltFire);
	 else
		 Super(ONSHoverCraft).ClientVehicleCeaseFire(bWasAltFire);
}

function ChooseFireAt(Actor A)
{
	if (Pawn(A) != None && Vehicle(A) == None && VSize(A.Location - Location) < 1500 && COntroller.LineOfSightTo(A))
	{
		if (!bWeaponIsAltFiring)
			AltFire(0);
	}
	else if (bWeaponIsAltFiring)
		VehicleCeaseFire(true);

	Fire(0);
}

function VehicleCeaseFire(bool bWasAltFire)
{
	 if (bWasAltFire)
	 {
		 bHoldingDuck = False;
	 }
	 else
		 Super.VehicleCeaseFire(bWasAltFire);
}

simulated function CheckJumpDuck() //since this function is called in Tick function, I will add things here instead of adding ot the Tick function.
{
	 local KarmaParams KP;
	 local Emitter JumpEffect, DuckEffect;
	 local bool bOnGround;
	 local int i;

	 KP = KarmaParams(KParams);
	 
	 bOnGround = false;
	 for(i=0; i<KP.Repulsors.Length; i++)
	 {
		 if( KP.Repulsors[i] != None && KP.Repulsors[i].bRepulsorInContact )
			 bOnGround = true;
	 }
	 
	 if (JumpCountdown <= 0.0 && (Rise > 0 || bWeaponIsAltFiring) && bOnGround && !bHoldingDuck && Level.TimeSeconds - JumpDelay >= LastJumpTime)
	 {
		 PlaySound(JumpSound,,1.0);
		 
		 if (Role == ROLE_Authority)
			 DoBikeJump = !DoBikeJump;
			 
		 if(Level.NetMode != NM_DedicatedServer)
		 {
			 JumpEffect = Spawn(class'ONSHoverBikeJumpEffect');
			 JumpEffect.SetBase(Self);
			 CLientPlayForceFeedback(JumpForce);
			 GoToState('EjectReady');
		 }
		 
		 if ( AIController(Controller) != None)
			 Rise = 0;
			 
		 LastJumpTime = Level.TimeSeconds;
	 }
	 else if (DuckCountdown <= 0.0 && Rise < 0)
     {
         if (!bHoldingDuck)
         {
             bHoldingDuck = True;

             PlaySound(DuckSound,,1.0);

			 if(Level.NetMode != NM_DedicatedServer)
			 {
				 DuckEffect = Spawn(class'ONSHoverBikeDuckEffect');
				 DuckEffect.SetBase(Self);
			 }

             if ( AIController(Controller) != None )
    			 Rise = 0;

    		 JumpCountdown = 0.0; // Stops any jumping that was going on.
    	 }
	 }
	 else
		 bHoldingDuck = False;
}

defaultproperties
{
	 Mesh=Mesh'UT3VehiclesAnims.VH_NecrisManta'
	 DestroyedVehicleMesh=StaticMesh'UT3Vehicles-SM.UT3Viper'
	 
	 RedSkin=Shader'UT3VehiclesTex.Viper.ViperSkin'
	 BlueSkin=Shader'UT3VehiclesTex.Viper.ViperSkinBlue'
	 
	 Health=200
	 HealthMax=200

	 VehiclePositionString="in a UT3 Viper"
	 VehicleNameString="UT3 Viper"

	 GroundSpeed=1500.0
	 AirSpeed=1800.0
	 
	 DriverWeapons(0)=(WeaponClass=class'UT3Vehicles.UT3ViperGun',WeaponBone=FrontBody);
	 
	 RanOverDamageType=class'DamTypeHoverBikeHeadshot' //Consider Creating a New Class
	 CrushedDamageType=class'DamTypeHoverBikePancake'  //Consider Creating a New Class
	 
	 IdleSound=sound'UT3Vehicles.UT3Viper.UT3Viper_Idle'
	 StartUpSound=sound'UT3Vehicles.UT3Viper.UT3Viper_StartUp'
	 ShutDownSound=sound'UT3Vehicles.UT3Viper.UT3Viper_ShutDown'
	 MaxPitchSpeed=1000
	 SoundVolume=255
	 SoundRadius=900
	 
	 DrivePos=(X=-18.438,Y=0.0,Z=90.0)
	 
	 EntryRadius=160.0
	 
	 HeadlightCoronaMaxSize=0 //So the Headlight doesn't shows up.
	 
	 CollisionHeight=50
	 CollisionRadius=40
	 
	 HoverCheckDist=100
	 
	 DuckForceMag=150.0
     DuckSound=sound'ONSVehicleSounds-S.HoverBike.HoverBikeTurbo01'
	 
	 JumpDuration=0.17 //0.22
     JumpSound=sound'UT3Vehicles.UT3Viper.UT3Viper_Jump'
     JumpForce="HoverBikeJump"
     JumpDelay=1
	 JumpForceMag=70.0 //100.0
	
	//NEW
	 SelfDestructDamage=300
     SelfDestructDamageRadius=750
     SelfDestructDamageType=Class'UT3Vehicles.DamTypeViperSelfDestruct'
     SelfDestructMomentum=60000
	 BoostForce=50.000000 //1800.000000
	 MaxYawRate=100000.0
}
