/******************************************************************************
MutUT3Vehicles

Creation date: 2008-05-02 17:59
Last change: $Id$
Copyright (c) 2008, Wormbo
******************************************************************************/

class MutUT3NecrisVehicles extends Mutator;

var bool bHasInteraction; //GE: True if a player owns an Interaction object

/**
Modifies vehicle factories that originally spawn Onslaught vehicles to spawn
the corresponding UT3 vehicles instead.
*/
function bool CheckReplacement(Actor Other, out byte bSuperRelevant)
{
	local SVehicleFactory Factory;

	if (SVehicleFactory(Other) != None) {
		Factory = SVehicleFactory(Other);
		switch (Factory.VehicleClass) {
        case class'ONSHoverBike':
			Factory.VehicleClass = class'UT3Vehicles.UT3Viper2v';
			break;
		}
	}
	return Super.CheckReplacement(Other, bSuperRelevant);
}

/*
===========
GE: Spawn an Interaction. UT3 vehicles tend to use special keys, and this is
a great way of replicating such behavioiur. See UT3Scorpion for a use example.
===========
*/

simulated function Tick(float DeltaTime)
{
        local PlayerController PC;

        //UEWiki: If the player has an interaction already, exit function.
        if (bHasInteraction)
                Return;
        PC = Level.GetLocalPlayerController();

        //UEWiki: Run a check to see whether this mutator should create an interaction for the player
        if ( PC != None && !PC.PlayerReplicationInfo.bIsSpectator )  //TODO !!GE: if PC.Pawn.IsA('UT3Scorpion')
        {
        //        PC.Player.InteractionMaster.AddInteraction("UT3Style.UT3ScorpionInteraction", PC.Player); //UEWiki: Create the interaction
                bHasInteraction = True; //UEWiki: Set the variable so this lot isn't called again
        }
}


//=============================================================================
// Default values
//=============================================================================

defaultproperties
{
     GroupName="VehicleArena"
     FriendlyName="UT3 Necris Vehicles"
     Description="Replaces UT2004 vehicles with versions similar to their UT3 Necris counterparts."
     bAlwaysRelevant=True
     RemoteRole=ROLE_SimulatedProxy
}
