//-----------------------------------------------------------------------------
// Name:        MutTimedMessages
// Version:     2.00
// Author:      Infernus <teunjack@hotmail.com>
// Description: This is a server side mutator which allows you to configure
//              timed messages to broadcast based on your settings.
//-----------------------------------------------------------------------------
// Note: NO serverpackages needed to run this mutator.
//-----------------------------------------------------------------------------  

class MutTimedMessages extends Mutator 
	config(MutTimedMessages);

var config bool bLoopMessages;
var config int Interval;
var config array<string> Message;
var int MessageIndex;

function PostBeginPlay()
{
	Super.PostBeginPlay();
    SetTimer(Interval, bLoopMessages);
}

function Timer()
{
	if(Message.Length==0)
	{
		//Do nothing.
		return;
	}
	Level.Game.Broadcast( self, Message[MessageIndex]); 
	if( ++MessageIndex>=Message.Length ) 
		MessageIndex = 0;
}

function Mutate(string Cmd, PlayerController PC)
{
	if( Left(Cmd,Len("AddMessage"))~="AddMessage" )
	{
		if(PC.PlayerReplicationInfo.bAdmin)
		{
			CreateMessage(Mid(Cmd,Len("AddMessage")+1),PC);
		}
		else
			PC.ClientMessage("You do not have access to this command.");
	}
	if( Left(Cmd,Len("RemoveMessage"))~="RemoveMessage" )
	{
		if(PC.PlayerReplicationInfo.bAdmin)
		{
			DeleteMessage(Mid(Cmd,Len("RemoveMessage")+1),PC);
		}
		else
			PC.ClientMessage("You do not have access to this command.");
	}
	if( Left(Cmd,Len("SetInterval"))~="SetInterval" )
	{
		if(PC.PlayerReplicationInfo.bAdmin)
		{
			SetNewInterval(Mid(Cmd,Len("SetInterval")+1),PC);
		}
		else
			PC.ClientMessage("You do not have access to this command.");
	}
	if( Cmd ~= "MessageList" )
	{
		if(PC.PlayerReplicationInfo.bAdmin)
		{
			MessageList(PC);
		}
		else
			PC.ClientMessage("You do not have access to this command.");
	}
	if ( NextMutator != None )
        NextMutator.Mutate(Cmd, PC);
}

function CreateMessage(string Msg, PlayerController PC)
{
	Message[Message.Length] = Msg;
	SaveConfig();
	PC.ClientMessage("Succesfully added message: '" $Msg $"'.");
}

function SetNewInterval(string NewInterval, PlayerController PC)
{
	If( int(NewInterval) < 30 )
		PC.ClientMessage("Please enter a valid value.");
	Interval = int(NewInterval);
	SaveConfig();
	SetTimer(int(NewInterval), bLoopMessages);
	PC.ClientMessage("Succesfully set interval to " $int(NewInterval) $".");
}

function MessageList(PlayerController PC)
{
	local int i;

	if(Message.Length==0)
	{
		PC.ClientMessage("There are currently no messages.");
		return;
	}
	for(i=0; i<Message.Length; i++)
	{
		PC.ClientMessage("Message #" $i $":" @Message[i] );
	}
}

function DeleteMessage(string Slot, PlayerController PC)
{
	local int IntSlot;
	IntSlot = int(Slot);
	
	if( IntSlot<0 || IntSlot>=Message.Length )
	{
		if( Message.Length==0 )
			PC.ClientMessage("There are currently no messages.");
		else PC.ClientMessage("Message slot out of range (0-"$(Message.Length-1)$").");
		return;
	}
	PC.ClientMessage("Removed '" $Message[IntSlot] $"' from the list.");
	Message.Remove(IntSlot, 1);
	SaveConfig();
}


defaultproperties
{
     bLoopMessages=True
     Interval=120
	 FriendlyName="Timed Messages Mutator"
     Description="This is a server side mutator which allows you to configure timed messages to broadcast based on your settings."
	 Message="MutTimedMessages: The global admin hasn't configured this mutator yet."
}
