class SnakeChainPuller extends IChainPuller;

var SnakeChainPuller StaticInstance;

function TickPull(float DeltaTime, Pawn CurrentChainHead, array<xPawn> ChainLinks)
{
    local vector target;
    local int i;
    //The first link is pulled toward the ChainHead
    if(ChainLinks.Length >= 1)
    {
    target = class'RagUtils'.static.LocationBehindActor(CurrentChainHead, RagdollSeparationDistance);
    class'RagUtils'.static.PullRagdollToLocation(ChainLinks[0], target);
    }

    //Second link is pulled based on the 2 infront him (first link & ChainHead)
    if(ChainLinks.Length >= 2)
    {
    target = class'RagUtils'.static.MagicVector(ChainLinks[0], CurrentChainHead, RagdollSeparationDistance);
    class'RagUtils'.static.PullRagdollToLocation(ChainLinks[1], target);
    }

    //Now the rest of the links get pulled just like the second link
    for(i = 2; i < ChainLinks.Length; ++i)
    {
    //i'th link is pulled based on the 2 infront him.
    //This is a location based on the guy in front me's location
    // and the location of the guy infront of him
    //Makes the "chain" more like a "snake" or a slow train
    //Still looks cool.
    target = class'RagUtils'.static.MagicVector(ChainLinks[i-1], ChainLinks[i-2], RagdollSeparationDistance);
    class'RagUtils'.static.PullRagdollToLocation(ChainLinks[i], target);
    }
}

static function IChainPuller NewChainPuller(RagChain chain)
{
    if(default.StaticInstance == None)
    {
        default.StaticInstance = new(None)class'SnakeChainPuller';
        //Log("Making a snake");
    }
    return default.StaticInstance;
}
defaultproperties
{
    MutSelectName="Snake"
}
