Class ONSPlusRulesPage extends FloatingWindow;

var automated GUITabControl MainTab;

// Option status (static labels)
var automated moEditBox l_bSelectableExits;
var automated moEditBox l_bAllowEnhancedRadar;
var automated moEditBox l_bDropChecks;
var automated moEditBox l_bNodeHealScoreFix;
var automated moEditBox l_bVehicleHealScoreFix;
var automated moEditBox l_HealScoreQuota;
var automated moEditBox l_bVehicleDamageScore;
var automated moEditBox l_DamageScoreQuota;
var automated moEditBox l_bIsolateNodeBonus;
var automated moEditBox l_IsolateBonusPctPerNode;
var automated moEditBox l_bAllowPreferredTeam;

// Setup property values
function InitComponent(GUIController MyController, GUIComponent MyComponent)
{
	Super.InitComponent(MyController, MyComponent);


	if (PlayerOwner() != none && PlayerOwner().GameReplicationInfo != none && ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo) != none)
	{
		l_bSelectableExits.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).bSelectableExits));
		l_bSelectableExits.SetReadOnly(True);

		l_bAllowEnhancedRadar.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).bAllowEnhancedRadar));
		l_bAllowEnhancedRadar.SetReadOnly(True);

		l_bDropChecks.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).bDropChecks));
		l_bDropChecks.SetReadOnly(True);

		l_bNodeHealScoreFix.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).bNodeHealScoreFix));
		l_bNodeHealScoreFix.SetReadOnly(True);

		l_bVehicleHealScoreFix.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).bVehicleHealScoreFix));
		l_bVehicleHealScoreFix.SetReadOnly(True);

		l_HealScoreQuota.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).HealScoreQuota));
		l_HealScoreQuota.SetReadOnly(True);

		l_bVehicleDamageScore.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).bVehicleDamageScore));
		l_bVehicleDamageScore.SetReadOnly(True);

		l_DamageScoreQuota.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).DamageScoreQuota));
		l_DamageScoreQuota.SetReadOnly(True);

		l_bIsolateNodeBonus.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).bIsolateNodeBonus));
		l_bIsolateNodeBonus.SetReadOnly(True);

		l_IsolateBonusPctPerNode.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).IsolateBonusPctPerNode));
		l_IsolateBonusPctPerNode.SetReadOnly(True);

		l_bAllowPreferredTeam.SetText(string(ONSPlusGameReplicationInfo(PlayerOwner().GameReplicationInfo).bAllowPreferredTeam));
		l_bAllowPreferredTeam.SetReadOnly(True);
	}

	WindowName="ONSPlus Server Rules";

	t_WindowTitle.SetCaption(WindowName);
}

defaultproperties
{
	Begin Object Class=moEditBox Name=SelectableExitsLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.100000
		ComponentWidth=0.710000
		Caption="Selectable exits"
		Hint="Wether or not the server has selectable exits enabled"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=21
	End Object
	l_bSelectableExits=SelectableExitsLabel

	Begin Object Class=moEditBox Name=EnhancedRadarLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.150000
		ComponentWidth=0.710000
		Caption="Enhanced Radar"
		Hint="Wether or not the server has enabled the enhanced radar"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=22
	End Object
	l_bAllowEnhancedRadar=EnhancedRadarLabel

	Begin Object Class=moEditBox Name=DropCheckLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.200000
		ComponentWidth=0.710000
		Caption="Drop Checks"
		Hint="Wether or not the server has vehicle exit height checks enabled"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=23
	End Object
	l_bDropChecks=DropCheckLabel

	Begin Object Class=moEditBox Name=NodeHealScoreFixLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.250000
		ComponentWidth=0.710000
		Caption="Shared Node Score"
		Hint="Wether or not the server has enabled the sharing of points when linking up to charge a node"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=24
	End Object
	l_bNodeHealScoreFix=NodeHealScoreFixLabel

	Begin Object Class=moEditBox Name=VehicleHealScoreFixLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.300000
		ComponentWidth=0.710000
		Caption="Vehicle Heal Score"
		Hint="Wether or not the server has enabled getting points for healing a vehicle"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=25
	End Object
	l_bVehicleHealScoreFix=VehicleHealScoreFixLabel

	Begin Object Class=moEditBox Name=HealScoreQuotaLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.350000
		ComponentWidth=0.710000
		Caption="Vehicle Heal Quota"
		Hint="The amount of a vehicles health you have to heal before getting one point"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=26
	End Object
	l_HealScoreQuota=HealScoreQuotaLabel

	Begin Object Class=moEditBox Name=VehicleDamageScoreLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.400000
		ComponentWidth=0.710000
		Caption="Vehicle Damage Score"
		Hint="Wether or not the server has enabled getting points for damaging a vehicle"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=27
	End Object
	l_bVehicleDamageScore=VehicleDamageScoreLabel

	Begin Object Class=moEditBox Name=DamageScoreQuotaLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.450000
		ComponentWidth=0.710000
		Caption="Vehicle Damage Quota"
		Hint="The amount of damage you have to give a vehicle before getting one point"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=28
	End Object
	l_DamageScoreQuota=DamageScoreQuotaLabel

	Begin Object Class=moEditBox Name=IsolateNodeBonusLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.500000
		ComponentWidth=0.710000
		Caption="Isolate Score"
		Hint="Wether or not the server has enabled bonus points for isolating a node"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=29
	End Object
	l_bIsolateNodeBonus=IsolateNodeBonusLabel

	Begin Object Class=moEditBox Name=IsolateBonusPctPerNodeLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.550000
		ComponentWidth=0.710000
		Caption="Isolate Bonus"
		Hint="The percentage by which your score is increased for every isolated node (the more nodes you isolated, the bigger this bonus)"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=30
	End Object
	l_IsolateBonusPctPerNode=IsolateBonusPctPerNodeLabel

	Begin Object Class=moEditBox Name=AllowPreferredTeamLabel
		WinWidth=0.550000
		WinHeight=0.040000
		WinLeft=0.0450000
		WinTop=0.600000
		ComponentWidth=0.710000
		Caption="Allow Preferred Team"
		Hint="Wether or not the server is allowing people to use their preferred team"
		CaptionWidth=0.940000
		ComponentJustification=TXTA_Left
		TabOrder=31
	End Object
	l_bAllowPreferredTeam=AllowPreferredTeamLabel

	DefaultWidth=0.250000
	DefaultHeight=0.300000
	DefaultLeft=0.110313
	DefaultTop=0.057916
	WinWidth=0.500000
	WinHeight=0.600000
	WinLeft=0.110313
	WinTop=0.057916

	bRenderWorld=True
	bAllowedAsLast=True
	bCaptureInput=True
	bResizeWidthAllowed=False
	bResizeHeightAllowed=False
}