// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
Class ONSPlusManualGunPawn extends ONSManualGunPawn;

var bool bForcedDuck;
var pawn DuckForcedPawn;

var array<Actor> LockedActors;
var float LastLockCheck;

var ONSPlusGameReplicationInfo OPGRI;

function bool TryToDrive(Pawn P)
{
	if (!bPowered)
	{
		P.ReceiveLocalizedMessage(class'ONSOnslaughtMessage', 13);
		return false;
	}


	if (bNonHumanControl || P.Controller == None || Driver != None || P.DrivenVehicle != None || !P.Controller.bIsPlayer || P.IsA('Vehicle') || Health <= 0)
		return false;

	if(!Level.Game.CanEnterVehicle(self, P))
		return false;

	// Check vehicle Locking....
	if (!bTeamLocked || P.GetTeamNum() == Team)
	{
		if (bEnterringUnlocks && bTeamLocked)
			bTeamLocked = false;

		KDriverEnter(P);


		bForcedDuck = False;

		if (P.bIsCrouched)
		{
			P.bIsCrouched = False;
			bForcedDuck = True;
			DuckForcedPawn = P;
		}

		return true;
	}
	else
	{
		VehicleLocked(P);
		return false;
	}
}

function bool KDriverLeave(bool bForceLeave)
{
	local bool bResult;

	bResult = Super.KDriverLeave(bForceLeave);

	if (bResult && bForcedDuck)
		DuckForcedPawn.bIsCrouched = True;

	return bResult;
}

function bool HealDamage(int Amount, Controller Healer, class<DamageType> DamageType)
{
	if (Super.HealDamage(Amount, Healer, DamageType))
	{
		if (OPGRI == none && Controller != None && PlayerController(Controller) != None && PlayerController(Controller).GameReplicationInfo != None)
			OPGRI = ONSPlusGameReplicationInfo(PlayerController(Controller).GameReplicationInfo);

		if (OPGRI != none && OPGRI.bVehicleHealScoreFix && !IsVehicleEmpty() && Healer != None && Healer.PlayerReplicationInfo != None
			&& ONSPlusPlayerReplicationInfo(Healer.PlayerReplicationInfo) != None)
			ONSPlusPlayerReplicationInfo(Healer.PlayerReplicationInfo).AddVehicleHealBonus(FMin(Amount * LinkHealMult, HealthMax - Health) / OPGRI.HealScoreQuota);

		return True;
	}
	else
		return False;
}

// The person at the front of the link (LinkHead) will get credit for destroying vehicle but the damage credit iterates through the people linking (instigatedBy)
function TakeLinkedDamage(Pawn LinkHead, int Damage, Pawn instigatedBy, Vector Hitlocation, Vector Momentum, class<DamageType> DamageType)
{
	local int PreHealth;

	PreHealth = Health;

	Super.TakeDamage(Damage, LinkHead, HitLocation, Momentum, DamageType);

	if (PreHealth == Health)
		return;

	if (OPGRI == none && Controller != None && PlayerController(Controller) != None && PlayerController(Controller).GameReplicationInfo != None)
		OPGRI = ONSPlusGameReplicationInfo(PlayerController(Controller).GameReplicationInfo);

	if (OPGRI != none && OPGRI.bVehicleDamageScore && !IsVehicleEmpty() && instigatedBy != None && instigatedBy.Controller != None
		&& instigatedBy.Controller.PlayerReplicationInfo != None && ONSPlusPlayerReplicationInfo(instigatedBy.Controller.PlayerReplicationInfo) != None)
	{
		if (instigatedBy.Controller.PlayerReplicationInfo.TeamID != Team)
			ONSPlusPlayerReplicationInfo(instigatedBy.Controller.PlayerReplicationInfo).AddVehicleDamageBonus((float(PreHealth) - float(Health))
							/ OPGRI.DamageScoreQuota);
		else
			ONSPlusPlayerReplicationInfo(instigatedBy.Controller.PlayerReplicationInfo).AddVehicleDamageBonus((float(PreHealth) - float(Health))
				/ OPGRI.DamageScoreQuota * -1.0);
	}
}

// Cleans the list of locked actors (probably not needed but here to be safe)
function CleanLockedActors(optional actor RemoveActor)
{
	local int i;

	for (i=0; i<LockedActors.Length; i++)
	{
		if ((ONSPlusAttackCraftMissle(LockedActors[i]) != None && ONSPlusAttackCraftMissle(LockedActors[i]).HomingTarget != self) ||
			(ONSPlusAVRiL(LockedActors[i]) != None && ONSPlusAVRiL(LockedActors[i]).HomingTarget != self) || LockedActors[i] == RemoveActor)
		{
			LockedActors.Remove(i, 1);
			i--;
		}
	}
}

function NotifyPlusEnemyLockedOn(actor LockedActor)
{
	if ((ONSPlusAttackCraftMissle(LockedActor) != None && ONSPlusAttackCraftMissle(LockedActor).HomingTarget != Self)
		|| (ONSPlusAVRiL(LockedActor) != None && ONSPlusAVRiL(LockedActor).HomingTarget != Self))
		return;

	// Prevent double-instances of actors in list
	CleanLockedActors(LockedActor);

	LockedActors.Length = LockedActors.Length + 1;
	LockedActors[LockedActors.Length-1] = LockedActor;

	bEnemyLockedOn = true;
}

function NotifyPlusEnemyLostLock(optional actor UnLockedActor)
{
	if (UnLockedActor != None)
		CleanLockedActors(UnLockedActor);

	if (LockedActors.Length > 0)
		return;

	bEnemyLockedOn = false;
}

function NotifyEnemyLockedOn();

function NotifyEnemyLostLock();

simulated function Tick(float DeltaTime)
{
	Super.Tick(DeltaTime);

	if (Level.TimeSeconds - LastLockCheck > 10)
	{
		LastLockCheck = Level.TimeSeconds;

		CleanLockedActors();

		if (LockedActors.Length == 0)
			NotifyPlusEnemyLostLock(None);
	}
}