// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
Class ONSPlusHUD extends ONSHUDOnslaught;

#exec Texture Import File=Textures\OPThumbUp.bmp Name=OPThumbUp Mips=Off Masked=1

struct VehicleDescription
{
	var class VehicleClass;
	var color RadarColour;
};

var array<VehicleDescription> VehicleData;
var color TempColour;

var ONSPlusPlayerReplicationInfo OPPRI;

var array<object> DataHolders;

struct BeaconData
{
	var vector PlayerLoc;
	var float FadeMult;
};

var array<BeaconData> BeaconInfo;

// Manages the radar data for specific vehicle classes
//
// I have decided to use a 'slightly' complicated system for managing vehicle radar data (that supports custom packages)
// If you can dynamicly load an object named:	PackageName$"VehicleRadarData" then you use GetPropertyText to obtain the data:
//	VehicleClass$"RadarColour"	if that fails then default the colour
function SetVehicleData(class<Vehicle> VehicleClass, out string VehicleName, out color RadarColour)
{
	local int i, j;
	local class CurDataHolderClass;
	local object CurDataHolder;
	local string sTempStr, CurClass, CurPackage, CurColour;

	for (i=0; i<VehicleData.Length; i++)
	{
		if (VehicleData[i].VehicleClass == VehicleClass)
		{
			VehicleName = VehicleClass.default.VehicleNameString;
			RadarColour = VehicleData[i].RadarColour;

			return;
		}
	}

	// If the code reaches here that means the vehicle is not yet listed
	VehicleData.Length = VehicleData.Length + 1;
	i = VehicleData.Length - 1;

	VehicleData[i].VehicleClass = VehicleClass;

	// Get the raw string representation of the package the current vehicle class is located in and the classname of the vehicle
	sTempStr = string(VehicleClass);

	CurClass = GetItemName(sTempStr);

	CurPackage = Left(sTempStr, Len(sTempStr) - 1 - Len(CurClass));


	CurDataHolder = none;

	// Check if the current package already has a dataholder
	for (j=0; j<DataHolders.Length; j++)
	{
		if (Left(GetItemName(string(DataHolders[j].Class)), Len(CurPackage)) ~= CurPackage)
		{
			CurDataHolder = DataHolders[j];
			break;
		}
	}

	// If the current package is not currently in the dataholder list see if there is a dataholder object in that package and if so, add it to the list
	if (CurDataHolder == none)
	{
		CurDataHolderClass = Class(DynamicLoadObject(CurPackage$"."$CurPackage$"VehicleRadarData", Class'Class'));

		// If the class exists try to create the data object and if that is created successfully then add it to the list
		if (CurDataHolderClass != none)
		{
			CurDataHolder = new CurDataHolderClass;

			if (CurDataHolder != none)
				DataHolders[DataHolders.Length] = CurDataHolder;
		}
	}

	// If this is true then we know that we are dealing with a custom vehicle, default its colour
	if (CurDataHolder == none)
	{
		VehicleData[i].RadarColour.R = 0;
		VehicleData[i].RadarColour.G = 0;
		VehicleData[i].RadarColour.B = 0;

		VehicleName = VehicleClass.default.VehicleNameString;
		RadarColour = VehicleData[i].RadarColour;

		return;
	}

	// If the code reaches this point then we know the DataHolder was created, check if the current vehicle class has an entry in the data holder
	CurColour = CurDataHolder.GetPropertyText(CurClass$"RadarColour");

	// If it does then gather the data and add the data to the list, if not then treat it like a custom vehicle
	if (CurColour != "")
	{
		// If the colour hasn't been entered into the data holder then default it
		if (CurColour != "")
		{
			// A hack for my laziness (actually...upon further thought this is FASTER than any other alternative)
			SetPropertyText("TempColour", CurColour);

			VehicleData[i].RadarColour = TempColour;
		}
		else
		{
			VehicleData[i].RadarColour.R = 0;
			VehicleData[i].RadarColour.G = 0;
			VehicleData[i].RadarColour.B = 0;
		}
	}
	else
	{
		VehicleData[i].RadarColour.R = 0;
		VehicleData[i].RadarColour.G = 0;
		VehicleData[i].RadarColour.B = 0;
	}

	VehicleName = VehicleClass.default.VehicleNameString;
	RadarColour = VehicleData[i].RadarColour;
}

// Fix for the shitty implementation of sprites..system was better in unreal1/ut99 (this is the easiest way for me to add alpha/transparancy to sprites)
simulated function PostRender(canvas Canvas)
{
	local int iTempInt;
	local ONSPlusPlayerReplicationInfo PRI;
	local vector ScreenLoc, BeaconLoc;
	local float Dist, FadeMult;
	local UnrealPawn UPawn;

	if (PlayerOwner == none || ONSPlusxPlayer(PlayerOwner) == none || ONSPlusxPlayer(PlayerOwner).bDisableLiftBeacons)
	{
		Super.PostRender(Canvas);
		return;
	}

	BeaconInfo.Length = 0;


	// Draw the lift beacons, first check: make sure the local player is in a vehicle
	if (PlayerOwner.Pawn != none && Vehicle(PlayerOwner.Pawn) != none)
	{
		// Iterate through all the colliding actors within this distance (this is less efficient than iterating the PRI's, however this is the most simple way of making it work online)
		foreach PlayerOwner.Pawn.CollidingActors(Class'UnrealPawn', UPawn, 12000.0)
		{
			PRI = ONSPlusPlayerReplicationInfo(UPawn.PlayerReplicationInfo);

			if (PRI != none && Level.TimeSeconds - PRI.LastLiftCall < 5.0 && !PRI.bIsSpectator && PlayerOwner.GetTeamNum() == UPawn.GetTeamNum())
			{
				if (Level.TimeSeconds - PRI.LastLiftCall < 1.0)
					FadeMult = Level.TimeSeconds - PRI.LastLiftCall;
				else if (Level.TimeSeconds - PRI.LastLiftCall > 4.0)
					FadeMult = 5.0 - (Level.TimeSeconds - PRI.LastLiftCall);
				else
					FadeMult = 1.0;

				// The beacon will also be displayed on the HUD map, use the BeaconInfo array to save the data from here so it can be drawn when the HUD map is drawn
				iTempInt = BeaconInfo.Length;
				BeaconInfo.Length = BeaconInfo.Length + 1;

				BeaconInfo[iTempInt].PlayerLoc = UPawn.Location;
				BeaconInfo[iTempInt].FadeMult = FadeMult;


				// Line of sight check (for HUD only, beacons will be drawn on radar map regardless of this check)
				if (FastTrace(UPawn.Location, PlayerOwner.CalcViewLocation))
				{
					// Calculate where the beacon should be (tricky and a bit complicated)
					BeaconLoc = UPawn.Location + (vect(0,0,1) * PlayerOwner.Pawn.CollisionHeight * FClamp(0.85 + ((PlayerOwner.FOVBias
						* Canvas.WorldToScreen(UPawn.Location).Z * 0.85) * (1.0 / 1200.0)), 1.1, 1.75));

					if (Normal(BeaconLoc - PlayerOwner.CalcViewLocation) Dot vector(PlayerOwner.GetViewRotation()) >= Cos((Pi * PlayerOwner.DesiredFOV) / 360.0))
					{
						ScreenLoc = Canvas.WorldToScreen(BeaconLoc);

						ScreenLoc.X -= float(Texture'OPThumbUp'.USize) * 0.125;
						ScreenLoc.Y -= float(Texture'OPThumbUp'.VSize) * 0.4;

						// Make sure the beacon isn't 'off' the canvas, if unchecked then WorldToScreen can cause a problem where beacons behind you are drawn on HUD
						if (ScreenLoc.X > 0 || ScreenLoc.Y > 0)
						{
							Canvas.DrawColor.R = 255;
							Canvas.DrawColor.G = 255;
							Canvas.DrawColor.B = 255;

							// Manage the transparancy of the beacon based upon the players distance
							Dist = VSize(UPawn.Location - PlayerOwner.CalcViewLocation);

							if (Dist < 6000.0)
								Canvas.DrawColor.A = 128.0 * FadeMult;
							else
								Canvas.DrawColor.A = 128.0 * ((12000.0 - Dist) / 6000.0) * FadeMult;

							Canvas.Style = ERenderStyle.STY_Alpha;

							Canvas.SetPos(ScreenLoc.X, ScreenLoc.Y);
							Canvas.DrawIcon(Texture'OPThumbUp', 0.25);
						}
					}
				}
			}
		}
	}

	Super.PostRender(Canvas);
}

simulated function ONSPlusDrawRadarMap(Canvas C, float CenterPosX, float CenterPosY, float RadarWidth, bool bShowDisabledNodes, optional bool bShowSpawnedVehicles, optional bool bShowLifts)
{
	local float PawnIconSize, PlayerIconSize, CoreIconSize, MapScale, MapRadarWidth;
	local vector HUDLocation;
	local FinalBlend PlayerIcon;
	local Actor A;
	local ONSPowerCore CurCore;
	local int i;
	local plane SavedModulation;
	local string CurAbbrev;

	SavedModulation = C.ColorModulate;

	C.ColorModulate.X = 1;
	C.ColorModulate.Y = 1;
	C.ColorModulate.Z = 1;
	C.ColorModulate.W = 1;

	// Make sure that the canvas style is alpha
	C.Style = ERenderStyle.STY_Alpha;

	MapRadarWidth = RadarWidth;

	if (PawnOwner != None)
	{
		MapCenter.X = 0.0;
		MapCenter.Y = 0.0;
	}
	else
		MapCenter = vect(0,0,0);

	HUDLocation.X = RadarWidth;
	HUDLocation.Y = RadarRange;
	HUDLocation.Z = RadarTrans;

	DrawMapImage(C, Level.RadarMapImage, CenterPosX, CenterPosY, MapCenter.X, MapCenter.Y, HUDLocation);

	if (Node == None)
		return;

	CurCore = Node;

	do
	{
		if (CurCore.HasHealthBar())
			DrawHealthBar(C, CurCore, CurCore.Health, CurCore.DamageCapacity, HealthBarPosition);

		CurCore = CurCore.NextCore;
	} until (CurCore == None || CurCore == Node);

	CoreIconSize = IconScale * 16 * C.ClipX * HUDScale/1600;
	PawnIconSize = CoreIconSize * 0.5;
	PlayerIconSize = CoreIconSize * 1.5;

	MapScale = MapRadarWidth / RadarRange;
	C.Font = GetConsoleFont(C);

	Node.UpdateHUDLocation(CenterPosX, CenterPosY, RadarWidth, RadarRange, MapCenter);

	for (i=0; i<PowerLinks.Length; i++)
		PowerLinks[i].Render(C, ColorPercent, bShowDisabledNodes);

	CurCore = Node;

	do
	{
		// hide unused powernodes
		if (!bShowDisabledNodes && (CurCore.CoreStage == 255 || CurCore.PowerLinks.Length == 0) && (PlayerOwner == none || !PlayerOwner.bDemoOwner))
		{
			CurCore = CurCore.NextCore;
			continue;
		}

		C.DrawColor = LinkColor[CurCore.DefenderTeamIndex];

		// Draw appropriate icon to represent the current state of this node
		if (CurCore.bUnderAttack || (CurCore.CoreStage == 0 && CurCore.bSevered))
			DrawAttackIcon(C, CurCore, CurCore.HUDLocation, IconScale, HUDScale, ColorPercent);

		if (CurCore.bFinalCore)
			DrawCoreIcon(C, CurCore.HUDLocation, PowerCoreAttackable(CurCore), IconScale, HUDScale, ColorPercent);
		else
			DrawNodeIcon(C, CurCore.HUDLocation, PowerCoreAttackable(CurCore), CurCore.CoreStage, IconScale, HUDScale, ColorPercent);

		CurCore = CurCore.NextCore;

	} until (CurCore == None || CurCore == Node);

	// Tweak, this makes sure the node number is drawn last, so maps like Maelstrom don't have overlapping icon problem (could use some tweaking for speed?)
	CurCore = Node;

	do
	{
		if (!bShowDisabledNodes && (CurCore.CoreStage == 255 || CurCore.PowerLinks.Length == 0) && (PlayerOwner == none || !PlayerOwner.bDemoOwner))
		{
			CurCore = CurCore.NextCore;
			continue;
		}

		if (!CurCore.bFinalCore)
			DrawNodeLabel(C, CurCore.HUDLocation, IconScale, HUDScale, C.DrawColor, CurCore.NodeNum);

		CurCore = CurCore.NextCore;
	} until (CurCore == none || CurCore == Node);


	if (OPPRI == none && PlayerOwner != none && PlayerOwner.PlayerReplicationInfo != none && ONSPlusPlayerReplicationInfo(PlayerOwner.PlayerReplicationInfo) != none)
		OPPRI = ONSPlusPlayerReplicationInfo(PlayerOwner.PlayerReplicationInfo);

	// System for displaying spawned vehicles
	if (bShowSpawnedVehicles && OPPRI != none && (ONSPlusxPlayer(PlayerOwner) == none || !ONSPlusxPlayer(PlayerOwner).bDisableEnhancedRadarMap))
	{
		for (i=0; i<OPPRI.ClientVSpawnList.Length; i++)
		{
			if (OPPRI.ClientVSpawnList[i].CurFactoryTeam == PlayerOwner.GetTeamNum() && OPPRI.ClientVSpawnList[i].bSpawned)
			{
				HUDLocation = OPPRI.ClientVSpawnList[i].Factory.Location - MapCenter;

				SetVehicleData(OPPRI.ClientVSpawnList[i].VehicleClass, CurAbbrev, C.DrawColor);
				C.DrawColor.A = 255;

				C.SetPos(CenterPosX + (HUDLocation.X * MapScale) - (PlayerIconSize * 0.25), CenterPosY + (HUDLocation.Y * MapScale) - (PlayerIconSize * 0.25));
				C.DrawTile(Material'NewHUDIcons', PlayerIconSize * 0.25, PlayerIconSize * 0.25, 0, 0, 32, 32);
			}
		}
	}

	// Draw icons for players that want a lift
	if (bShowLifts && PlayerOwner.Pawn != none && Vehicle(PlayerOwner.Pawn) != None)
	{
		for (i=0; i<BeaconInfo.Length; i++)
		{
			HUDLocation = BeaconInfo[i].PlayerLoc - MapCenter;

			C.DrawColor = C.MakeColor(255, 255, 255, 128.0 * BeaconInfo[i].FadeMult);
			C.SetPos(CenterPosX + (HUDLocation.X * MapScale) - (PlayerIconSize * 0.125), CenterPosY + (HUDLocation.Y * MapScale) - (PlayerIconSize * 0.125));
			C.DrawIcon(Material'OPThumbup', 0.125);
		}
	}

	// Draw PlayerIcon
	if (PawnOwner != None)
		A = PawnOwner;
	else if (PlayerOwner.IsInState('Spectating'))
		A = PlayerOwner;
	else if (PlayerOwner.Pawn != None)
		A = PlayerOwner.Pawn;

	if (A != None)
	{
		PlayerIcon = FinalBlend'CurrentPlayerIconFinal';
		TexRotator(PlayerIcon.Material).Rotation.Yaw = -A.Rotation.Yaw - 16384;
		HUDLocation = A.Location - MapCenter;
		HUDLocation.Z = 0;

		if (HUDLocation.X < (RadarRange * 0.95) && HUDLocation.Y < (RadarRange * 0.95))
		{
			C.SetPos(CenterPosX + HUDLocation.X * MapScale - PlayerIconSize * 0.5, CenterPosY + HUDLocation.Y * MapScale - PlayerIconSize * 0.5);

			C.DrawColor = C.MakeColor(40,255,40);
			C.DrawTile(PlayerIcon, PlayerIconSize, PlayerIconSize, 0, 0, 64, 64);
		}
	}

	// Draw Border
	C.DrawColor = C.MakeColor(200,200,200);
	C.SetPos(CenterPosX - RadarWidth, CenterPosY - RadarWidth);
	C.DrawTile(BorderMat, RadarWidth * 2.0, RadarWidth * 2.0, 0, 0, 256, 256);

	C.ColorModulate = SavedModulation;
}

// Modified 'LocatePowerCore' function that accounts for vehicle spawns
simulated function Actor LocateSpawnArea(float PosX, float PosY, float RadarWidth)
{
	local float WorldToMapScaleFactor, Distance, LowestDistance;
	local vector WorldLocation, DistanceVector;
	local ONSPowerCore Core;
	local int i;
	local actor BestSpawnArea;

	if (Node == none)
		return None;

	WorldToMapScaleFactor = RadarRange / RadarWidth;

	WorldLocation.X = PosX * WorldToMapScaleFactor;
	WorldLocation.Y = PosY * WorldToMapScaleFactor;

	LowestDistance = 2500.0;


	// Search for nearest powercore
	Core = Node;

	do
	{
		DistanceVector = Core.Location - WorldLocation;
		DistanceVector.Z = 0;
		Distance = VSize(DistanceVector);

		if (Distance < LowestDistance)
		{
			BestSpawnArea = Core;
			LowestDistance = Distance;
		}

		Core = Core.NextCore;
	} until (Core == None || Core == Node);


	if (PlayerOwner == none || ONSPlusxPlayer(PlayerOwner) == none || ONSPlusxPlayer(PlayerOwner).bDisableEnhancedRadarMap)
		return BestSpawnArea;

	// If the lowest distance hasn't changed then set it to a half of the original size so that vehicle factory selection area is smaller
	LowestDistance = 1250;

	// See if there is a vehiclespawn even closer-by (note: this will also account for team-based selections)
	for (i=0; i<OPPRI.ClientVSpawnList.Length; i++)
	{
		if (OPPRI.ClientVSpawnList[i].CurFactoryTeam == PlayerOwner.GetTeamNum() && OPPRI.ClientVSpawnList[i].bSpawned)
		{
			DistanceVector = OPPRI.ClientVSpawnList[i].Factory.Location - WorldLocation;
			DistanceVector.Z = 0;
			Distance = VSize(DistanceVector);

			if (Distance < LowestDistance)
			{
				BestSpawnArea = OPPRI.ClientVSpawnList[i].Factory;
				LowestDistance = Distance;
			}
		}
	}

	return BestSpawnArea;
}

simulated function ShowTeamScorePassC(Canvas C)
{
	local float RadarWidth, CenterRadarPosX, CenterRadarPosY;

	if (Level.bShowRadarMap && !bMapDisabled)
	{
		RadarWidth = 0.5 * RadarScale * HUDScale * C.ClipX;
		CenterRadarPosX = (RadarPosX * C.ClipX) - RadarWidth;
		CenterRadarPosY = (RadarPosY * C.ClipY) + RadarWidth;
		ONSPlusDrawRadarMap(C, CenterRadarPosX, CenterRadarPosY, RadarWidth, false, false, !ONSPlusxPlayer(PlayerOwner).bDisableLiftBeacons);
	}
}