// ONSPlus: Coded by Shambler (Shambler__@Hotmail.com or Shambler@OldUnreal.com , ICQ:108730864)
Class ONSPlusAttackCraft extends ONSAttackCraft;

var bool bForcedDuck;
var pawn DuckForcedPawn;

var array<Actor> LockedActors;
var float LastLockCheck;

var ONSPlusGameReplicationInfo OPGRI;

var array<ONSPlusExitMarker> ExitMarkers;

var bool bHasPreferredExit;
var int PreferredExit;

var bool bHasPreferredExits;
var controller DecidingPlayer;
var float PreferenceLife; // The amount of time the preferred exit remains selected
var float PreferenceTime; // Timestamp for the preferred exit
var array<int> PreferredExits;
var array<int> PreferredExitsBackup;
var bool bForceClearBeacons;
var bool bForceClearBeacon;
var bool bCurrentPermenance;
var bool bDodgeTransition;

var bool bVehicleActive;

replication
{
	reliable if (bNetOwner && Role == ROLE_Authority)
		bHasPreferredExits, bHasPreferredExit, PreferredExit, DecidingPlayer;
}

function bool TryToDrive(Pawn P)
{
	local int x;

	if (FlipTimeLeft > 0)
		return false;

	if (NeedsFlip())
	{
		Flip(vector(P.Rotation), 1);
		return false;
	}

	// Don't allow vehicle to be stolen when somebody is in a turret
	if (!bTeamLocked && P.GetTeamNum() != Team)
	{
		for (x = 0; x<WeaponPawns.length; x++)
		{
			if (WeaponPawns[x].Driver != None)
			{
				VehicleLocked(P);
				return false;
			}
		}
	}


	if (bNonHumanControl || P.Controller == None || Driver != None || P.DrivenVehicle != None || !P.Controller.bIsPlayer || P.IsA('Vehicle') || Health <= 0)
		return false;

	if(!Level.Game.CanEnterVehicle(self, P))
		return false;

	// Check vehicle Locking....
	if (!bTeamLocked || P.GetTeamNum() == Team)
	{
		if (bEnterringUnlocks && bTeamLocked)
			bTeamLocked = false;

		KDriverEnter(P);

		bForcedDuck = False;

		if (P.bIsCrouched)
		{
			P.bIsCrouched = False;
			bForcedDuck = True;
			DuckForcedPawn = P;
		}

		return true;
	}
	else
	{
		VehicleLocked(P);
		return false;
	}
}

simulated function ClientKDriverEnter(PlayerController PC)
{
	bVehicleActive = True;

	Super.ClientKDriverEnter(PC);
}

function bool KDriverLeave(bool bForceLeave)
{
	local bool bResult;

	bResult = Super.KDriverLeave(bForceLeave);

	if (bResult && bForcedDuck)
		DuckForcedPawn.bIsCrouched = True;

	return bResult;
}

simulated function ClientKDriverLeave(PlayerController PC)
{
	local int i;

	bVehicleActive = False;

	for (i=0; i<ExitMarkers.Length; i++)
		if (ExitMarkers[i] != none)
			ExitMarkers[i].mRegen = False;

	Super.ClientKDriverLeave(PC);
}

// TODO: If drop checks are off SO IS THE FIX FOR EXITING FLAT-ON-GROUND RAPTORS
function bool PlaceExitingDriver()
{
	local int i, j;
	local vector tryPlace, Extent, HitLocation, HitNormal, ZOffset;
	local bool bTrace0, bTrace1;
	local array<vector> PreferredPositions, SecondaryPositions;
	local array<byte> ValidExitPoints;

	if (OPGRI == none && Controller != None && PlayerController(Controller) != None && PlayerController(Controller).GameReplicationInfo != None)
		OPGRI = ONSPlusGameReplicationInfo(PlayerController(Controller).GameReplicationInfo);

	if (OPGRI == none || (!OPGRI.bDropChecks && !OPGRI.bSelectableExits))
		return Super.PlaceExitingDriver();

	Extent = Driver.default.CollisionRadius * vect(1,1,0);
	Extent.Z = Driver.default.CollisionHeight;
	Extent *= 2;
	ZOffset = Driver.default.CollisionHeight * vect(0,0,1);

	// This was the code that stops you getting out of a raptor if it's too close to the ground...I'm not sure what it's purpose was so leave commented for now
	if (Trace(HitLocation, HitNormal, Location + (ZOffset * 5), Location + vect(0,0,19), false, Extent) != None)
		return false;

	// Avoid running driver over by placing in direction perpendicular to velocity
	if (VSize(Velocity) > 100 && (!OPGRI.bSelectableExits || (!bHasPreferredExits && !bHasPreferredExit) || DecidingPlayer != Controller))
	{
		tryPlace = Normal(Velocity cross vect(0,0,1)) * (CollisionRadius + Driver.default.CollisionRadius ) * 1.25;

		if (FRand() < 0.5)
			tryPlace *= -1; // Randomly prefer other side


		// Checks to see if drop location is 'clear'
		bTrace0 = Trace(HitLocation, HitNormal, Location + tryPlace + ZOffset, Location + ZOffset, false, Extent) == None;
		bTrace1 = Trace(HitLocation, HitNormal, Location - tryPlace + ZOffset, Location + ZOffset, false, Extent) == None;

		// If both drop locations are clear, check for long-falls
		if (bTrace0 && bTrace1)
		{
			bTrace0 = Trace(HitLocation, HitNormal, Location + tryPlace + ZOffset - vect(0,0,750), Location + tryPlace + ZOffset, false, Extent) == None;
			bTrace1 = Trace(HitLocation, HitNormal, Location - tryPlace + ZOffset - vect(0,0,750), Location - tryPlace + ZOffset, false, Extent) == None;

			// If both have long falls or both hit ground then it doesn't matter which one you pick
			if (bTrace0 == bTrace1)
			{
				// Check if driver can be dropped at either locations
				if (Driver.SetLocation(Location + tryPlace + ZOffset))
					return True;
				else if (Driver.SetLocation(Location - tryPlace + ZOffset))
					return True;
			}
			// If the first trace is a long drop, let the player out at the other side
			else if (bTrace0)
			{
				if (Driver.SetLocation(Location - tryPlace + ZOffset))
					return True;
			}
			// Same as above, except this is for the second trace
			else if (Driver.SetLocation(Location + tryPlace + ZOffset))
				return True;
		}
		// If this is the only clear drop location you MUST drop out here regardless of fall
		else if (bTrace0)
		{
			if (Driver.SetLocation(Location + tryPlace + ZOffset))
				return True;
		}
		// Same as above
		else if (bTrace1)
		{
			if (Driver.SetLocation(Location - tryPlace + ZOffset))
				return True;
		}
	}

	ValidExitPoints.Length = ExitPositions.Length;

	// Gather positions
	for (i=0; i<ExitPositions.Length; i++)
	{
		if (ExitPositions[0].Z != 0)
			ZOffset = Vect(0,0,1) * ExitPositions[0].Z;
		else
			ZOffset = Driver.default.CollisionHeight * vect(0,0,2);

		tryPlace = Location + ((ExitPositions[i] - ZOffset) >> Rotation) + ZOffset;

		// First, do a line check (stops us passing through things on exit).
		if (Trace(HitLocation, HitNormal, tryPlace, Location + ZOffset, false, Extent) != None)
			continue;

		ValidExitPoints[i] = 1;

		if (Trace(HitLocation, HitNormal, tryPlace - vect(0,0,750), tryPlace, false, Extent) == None)
		{
			SecondaryPositions.Length = SecondaryPositions.Length + 1;
			SecondaryPositions[SecondaryPositions.Length - 1] = tryPlace;
		}
		else
		{
			PreferredPositions.Length = PreferredPositions.Length + 1;
			PreferredPositions[PreferredPositions.Length - 1] = tryPlace;
		}
	}

	// A single preferred exit will override any others
	if (OPGRI.bSelectableExits && bHasPreferredExit && DecidingPlayer == Controller && bool(ValidExitPoints[PreferredExit]))
	{
		if (ExitPositions[0].Z != 0)
			ZOffset = Vect(0,0,1) * ExitPositions[0].Z;
		else
			ZOffset = Driver.default.CollisionHeight * vect(0,0,2);

		tryPlace = Location + ((ExitPositions[PreferredExit] - ZOffset) >> Rotation) + ZOffset;

		if (Driver.SetLocation(tryPlace))
			return True;
	}

	if (OPGRI.bSelectableExits && bHasPreferredExits && DecidingPlayer == Controller)
	{
		for (j=0; j<PreferredExits.Length; j++)
		{
			if (bool(ValidExitPoints[PreferredExits[j]]))
			{
				if (ExitPositions[0].Z != 0)
					ZOffset = Vect(0,0,1) * ExitPositions[0].Z;
				else
					ZOffset = Driver.default.CollisionHeight * vect(0,0,2);

				tryPlace = Location + ((ExitPositions[PreferredExits[j]] - ZOffset) >> Rotation) + ZOffset;

				if (Driver.SetLocation(tryPlace))
					return True;
			}
		}
	}

	// Iterate positions
	for (i=0; i<PreferredPositions.Length; i++)
		if (Driver.SetLocation(PreferredPositions[i]))
			return True;

	for (i=0; i<SecondaryPositions.Length; i++)
		if (Driver.SetLocation(SecondaryPositions[i]))
			return True;

	return false;
}

// Cleans the list of locked actors (probably not needed but here to be safe)
function CleanLockedActors(optional actor RemoveActor)
{
	local int i;

	for (i=0; i<LockedActors.Length; i++)
	{
		if ((ONSPlusAttackCraftMissle(LockedActors[i]) != None && ONSPlusAttackCraftMissle(LockedActors[i]).HomingTarget != self) ||
			(ONSPlusAVRiL(LockedActors[i]) != None && ONSPlusAVRiL(LockedActors[i]).HomingTarget != self) || LockedActors[i] == RemoveActor)
		{
			LockedActors.Remove(i, 1);
			i--;
		}
	}
}

function NotifyPlusEnemyLockedOn(actor LockedActor)
{
	local int i;

	if ((ONSPlusAttackCraftMissle(LockedActor) != None && ONSPlusAttackCraftMissle(LockedActor).HomingTarget != Self)
		|| (ONSPlusAVRiL(LockedActor) != None && ONSPlusAVRiL(LockedActor).HomingTarget != Self))
		return;

	// Prevent double-instances of actors in list
	CleanLockedActors(LockedActor);

	LockedActors.Length = LockedActors.Length + 1;
	LockedActors[LockedActors.Length-1] = LockedActor;

	bEnemyLockedOn = true;

	if (LockedOnSound != None)
		PlaySound(LockedOnSound);

	for (i = 0; i < WeaponPawns.length; i++)
		WeaponPawns[i].NotifyEnemyLockedOn();
}

function NotifyPlusEnemyLostLock(optional actor UnLockedActor)
{
	local int i;

	if (UnLockedActor != None)
		CleanLockedActors(UnLockedActor);

	if (LockedActors.Length > 0)
		return;

	bEnemyLockedOn = false;

	for (i = 0; i<WeaponPawns.length; i++)
		WeaponPawns[i].NotifyEnemyLostLock();
}

function NotifyEnemyLockedOn();

function NotifyEnemyLostLock();

simulated function Tick(float DeltaTime)
{
	local int i, j;
	local bool bIsPreferred;
	local vector HitLocation, HitNormal, Extent;
	local vector ZOffset, tryPlace, TempVect, TempVect2;

	Super.Tick(DeltaTime);

	if (PreferenceLife > 0 && PreferenceTime + PreferenceLife <= Level.TimeSeconds)
		ClearPreferredExits();

	if (Level.TimeSeconds - LastLockCheck > 10)
	{
		LastLockCheck = Level.TimeSeconds;

		CleanLockedActors();

		if (LockedActors.Length == 0)
			NotifyPlusEnemyLostLock(None);
	}

	if (OPGRI == none && Controller != None && PlayerController(Controller) != None && PlayerController(Controller).GameReplicationInfo != None)
		OPGRI = ONSPlusGameReplicationInfo(PlayerController(Controller).GameReplicationInfo);

	if (bVehicleActive && OPGRI != none && OPGRI.bSelectableExits && (Role < ROLE_Authority || Level.Netmode == NM_Standalone) && ONSPlusxPlayer(Controller) != None
		&& !ONSPlusxPlayer(Controller).bDisableExitPointDisplay && (ONSPlusxPlayer(Controller).bDisplayExitPoints || bForceClearBeacons || bForceClearBeacon))
	{
		if (ExitMarkers.Length != ExitPositions.Length)
			ExitMarkers.Length = ExitPositions.Length;

		for (i=0; i<ExitMarkers.Length; i++)
		{
			if (Driver == None)
			{
				ExitMarkers[i].mRegen = False;
				continue;
			}

			if (bForceClearBeacons && !ONSPlusxPlayer(Controller).bDisplayExitPoints)
			{
				bIsPreferred = False;

				for (j=0; j<PreferredExits.Length; j++)
					if (i == PreferredExits[j])
						bIsPreferred = True;

				if (!bIsPreferred)
				{
					if (ExitMarkers[i] != None)
						ExitMarkers[i].mRegen = False;

					continue;
				}
			}

			if (bForceClearBeacon && !ONSPlusxPlayer(Controller).bDisplayExitPoints)
			{
				if (PreferredExit != i)
				{
					if (ExitMarkers[i] != None)
						ExitMarkers[i].mRegen = False;

					continue;
				}
			}

			if (ExitMarkers[i] == none)
				ExitMarkers[i] = Spawn(Class'ONSPlusExitMarker', Self);

			//ExitMarkers[i].mRegen = True;

			if (!ExitMarkers[i].mRegen)
				ExitMarkers[i].Nudge(PreferenceLife);

			Extent = Driver.default.CollisionRadius * vect(1,1,0);
			Extent.Z = Driver.default.CollisionHeight;

			if (ExitPositions[0].Z != 0)
				ZOffset = Vect(0,0,1) * ExitPositions[0].Z;
			else
				ZOffset = Driver.default.CollisionHeight * vect(0,0,2);

			tryPlace = Location + ((ExitPositions[i] - ZOffset) >> Rotation) + ZOffset;

			TempVect = Driver.default.CollisionHeight * vect(0,0,0.5);
			TempVect2 = Driver.Default.CollisionRadius * vect(1,1,0);
			TempVect2.Z = Driver.default.CollisionHeight;

			if (Trace(HitLocation, HitNormal, tryPlace, Location + ZOffset, True, Extent) == None
				&& Trace(HitNormal, HitNormal, tryPlace + TempVect, tryPlace - TempVect, True, TempVect2) == None)
			{
				HitLocation = tryPlace;

				bIsPreferred = False;

				if ((bHasPreferredExits || bHasPreferredExit) && DecidingPlayer == Controller)
				{
					if (bHasPreferredExit && PreferredExit == i)
						bIsPreferred = True;
					else if (bHasPreferredExits)
						for (j=0; j<PreferredExits.Length; j++)
							if (PreferredExits[j] == i)
								bIsPreferred = True;
				}

				if (bIsPreferred)
				{
					ExitMarkers[i].mColorRange[0].R = 16;
					ExitMarkers[i].mColorRange[0].G = 64;
					ExitMarkers[i].mColorRange[0].B = 255;

					ExitMarkers[i].mColorRange[1].R = 16;
					ExitMarkers[i].mColorRange[1].G = 64;
					ExitMarkers[i].mColorRange[1].B = 255;
				}
				else
				{
					ExitMarkers[i].mColorRange[0].R = 64;
					ExitMarkers[i].mColorRange[0].G = 255;
					ExitMarkers[i].mColorRange[0].B = 16;

					ExitMarkers[i].mColorRange[1].R = 64;
					ExitMarkers[i].mColorRange[1].G = 255;
					ExitMarkers[i].mColorRange[1].B = 16;
				}
			}
			else
			{
				bIsPreferred = False;

				if ((bHasPreferredExits || bHasPreferredExit) && DecidingPlayer == Controller)
				{
					if (bHasPreferredExit && PreferredExit == i)
						bIsPreferred = True;
					else if (bHasPreferredExits)
						for (j=0; j<PreferredExits.Length; j++)
							if (PreferredExits[j] == i)
								bIsPreferred = True;
				}

				if (bIsPreferred)
				{
					ExitMarkers[i].mColorRange[0].R = 255;
					ExitMarkers[i].mColorRange[0].G = 48;
					ExitMarkers[i].mColorRange[0].B = 255;

					ExitMarkers[i].mColorRange[1].R = 255;
					ExitMarkers[i].mColorRange[1].G = 48;
					ExitMarkers[i].mColorRange[1].B = 255;
				}
				else
				{
					ExitMarkers[i].mColorRange[0].R = 255;
					ExitMarkers[i].mColorRange[0].G = 48;
					ExitMarkers[i].mColorRange[0].B = 16;

					ExitMarkers[i].mColorRange[1].R = 255;
					ExitMarkers[i].mColorRange[1].G = 48;
					ExitMarkers[i].mColorRange[1].B = 16;
				}
			}

			ExitMarkers[i].SetLocation(HitLocation);
		}
	}
	else if (ExitMarkers.Length > 0)
	{
		for (i=0; i<ExitMarkers.Length; i++)
		{
			if (ExitMarkers[i] == none)
			{
				ExitMarkers.Remove(i, 1);
				i--;
			}
			else
				ExitMarkers[i].mRegen = False;
		}
	}
}

function bool HealDamage(int Amount, Controller Healer, class<DamageType> DamageType)
{
	if (Super.HealDamage(Amount, Healer, DamageType))
	{
		if (OPGRI == none && Controller != None && PlayerController(Controller) != None && PlayerController(Controller).GameReplicationInfo != None)
			OPGRI = ONSPlusGameReplicationInfo(PlayerController(Controller).GameReplicationInfo);

		if (OPGRI != none && OPGRI.bVehicleHealScoreFix && !IsVehicleEmpty() && Healer != None && Healer.PlayerReplicationInfo != None
			&& ONSPlusPlayerReplicationInfo(Healer.PlayerReplicationInfo) != None)
			ONSPlusPlayerReplicationInfo(Healer.PlayerReplicationInfo).AddVehicleHealBonus(FMin(Amount * LinkHealMult, HealthMax - Health) / OPGRI.HealScoreQuota);

		return True;
	}
	else
		return False;
}

// The person at the front of the link (LinkHead) will get credit for destroying vehicle but the damage credit iterates through the people linking (instigatedBy)
function TakeLinkedDamage(Pawn LinkHead, int Damage, Pawn instigatedBy, Vector Hitlocation, Vector Momentum, class<DamageType> DamageType)
{
	local int PreHealth;

	PreHealth = Health;

	Super.TakeDamage(Damage, LinkHead, HitLocation, Momentum, DamageType);

	if (PreHealth == Health)
		return;

	if (OPGRI == none && Controller != None && PlayerController(Controller) != None && PlayerController(Controller).GameReplicationInfo != None)
		OPGRI = ONSPlusGameReplicationInfo(PlayerController(Controller).GameReplicationInfo);

	if (OPGRI != none && OPGRI.bVehicleDamageScore && !IsVehicleEmpty() && instigatedBy != None && instigatedBy.Controller != None
		&& instigatedBy.Controller.PlayerReplicationInfo != None && ONSPlusPlayerReplicationInfo(instigatedBy.Controller.PlayerReplicationInfo) != None)
	{
		if (instigatedBy.Controller.PlayerReplicationInfo.TeamID != Team)
			ONSPlusPlayerReplicationInfo(instigatedBy.Controller.PlayerReplicationInfo).AddVehicleDamageBonus((float(PreHealth) - float(Health))
							/ OPGRI.DamageScoreQuota);
		else
			ONSPlusPlayerReplicationInfo(instigatedBy.Controller.PlayerReplicationInfo).AddVehicleDamageBonus((float(PreHealth) - float(Health))
				/ OPGRI.DamageScoreQuota * -1.0);
	}
}

function TogglePreferredExit(optional int ExpireTime)
{
	if (OPGRI == none || !OPGRI.bSelectableExits)
		return;

	bHasPreferredExit = True;
	DecidingPlayer = Controller;

	PreferredExit++;

	if (PreferredExit >= ExitPositions.Length)
	{
		PreferredExit = -1;
		bHasPreferredExit = False;
	}
	else
		ClearPreferredExits(True);

	if (ExpireTime > 0)
	{
		bForceClearBeacon = True;
		bForceClearBeacons = False;
		PreferenceLife = ExpireTime;
		PreferenceTime = Level.TimeSeconds;
	}
}

function ClearPreferredExits(optional bool bCleanAll, optional bool bIncSingleMode)
{
	if (bCleanAll)
	{
		PreferredExitsBackup.Length = 0;
		bCurrentPermenance = False;
		bDodgeTransition = False;
	}

	if (bIncSingleMode)
	{
		PreferredExit = -1;
		bHasPreferredExit = False;
	}

	if (!bCurrentPermenance)
	{
		bHasPreferredExits = False;
		PreferredExits.Length = 0;
	}

	PreferenceLife = 0;
	PreferenceTime = 0;
	bForceClearBeacons = False;
	bForceClearBeacon = False;

	if (bDodgeTransition)
	{
		PreferredExits = PreferredExitsBackup;
		bDodgeTransition = False;
	}
}

// 1-left, 2-right, 3-forward, 4-back
function SelectDirectionalExit(byte Direction, optional int ExpireTime, optional bool bPermenant)
{
	local array<int> RemainingPositions;
	local int i, j, InsertionPoint;
	local bool bSwitchXY, bMinusA;
	local float A, B, C;

	if (OPGRI == none || !OPGRI.bSelectableExits)
		return;

	// If 5, clear all selections
	if (Direction == 5)
	{
		ClearPreferredExits(True, True);
		return;
	}

	// Forward has no direction changes
	if (Direction == 1)
	{
		bSwitchXY = True;
		bMinusA = True;
	}
	else if (Direction == 2)
	{
		bSwitchXY = True;
	}
	else if (Direction == 4)
	{
		bMinusA = True;
	}

	for (i=0; i<ExitPositions.Length; i++)
	{
		for (i=0; i<ExitPositions.Length; i++)
		{
			if (bSwitchXY)
			{
				A = ExitPositions[i].Y * (1 - (2 * int(bMinusA)));
				B = ExitPositions[i].X;
			}
			else
			{
				A = ExitPositions[i].X * (1 - (2 * int(bMinusA)));
				B = ExitPositions[i].Y;
			}

			if (A > 0.0)
			{
				for (j=0; j<RemainingPositions.Length; j++)
				{
					if (bSwitchXY)
						C = ExitPositions[j].X;
					else
						C = ExitPositions[j].Y;

					if (Abs(B) < Abs(C))
					{
						RemainingPositions.Insert(j, 1);
						InsertionPoint = j;
						Break;
					}
					else
						InsertionPoint = RemainingPositions.Length;
				}

				RemainingPositions[InsertionPoint] = i;
			}
		}
	}

	if (RemainingPositions.Length > 0)
	{
		// Make this preferred selection permenant
		if (bPermenant)
		{
			PreferredExits = RemainingPositions;

			bCurrentPermenance = True;

			// Clear single permenant preference
			bHasPreferredExit = False;
			PreferredExit = -1;
		}
		// In a permenant selection, transition to dodge selection
		else if (bCurrentPermenance)
		{
			// Already in dodge selection, replace current dodge selection
			if (bDodgeTransition)
			{
				PreferredExits = RemainingPositions;
			}
			else
			{
				bDodgeTransition = True;
				PreferredExitsBackup = PreferredExits;

				PreferredExits = RemainingPositions;
			}
		}
		else
			PreferredExits = RemainingPositions;

		if (Role == ROLE_Authority)
		{
			bHasPreferredExits = True;
			DecidingPlayer = Controller;
		}

		if (ExpireTime > 0)
		{
			PreferenceLife = ExpireTime;
			PreferenceTime = Level.TimeSeconds;
		}

		if (Role < ROLE_Authority || Level.Netmode == NM_Standalone)
		{
			bForceClearBeacons = True;
			bForceClearBeacon = False;
		}
	}
}

// Fix for raptors/cicada's spinning when you look down too low
function int LimitPitch(int pitch)
{
	local int Result;

	Result = Super.LimitPitch(pitch);

	if (Result > 32768)
		return Clamp(Result, 49156, 65536);
	else
		return Clamp(Result, 0, 16380);
}

defaultproperties
{
	DriverWeapons(0)=(WeaponClass=Class'ONSPlusAttackCraftGun',WeaponBone=PlasmaGunAttachment);
	PreferredExit=-1
}