class MutRealBods extends Mutator;

var config float RagFriction;
var config float RagRestitution;
var config float RagBuoyancy;
var config float RagTime;

var localized string OptDesc[4];

function PostBeginPlay()
{
	Level.RagdollTimeScale = RagTime;
}

function ModifyPlayer(Pawn Other)
{
    local xPawn x;
    local KarmaParams k;
    x = xPawn(Other);
    if (x != None)
    {
        x.KParams.KFriction = RagFriction;
        x.KParams.KRestitution = RagRestitution;
        k = KarmaParams(x.KParams);
        k.KBuoyancy = RagBuoyancy;
        k.bKNonSphericalInertia = true;
    }
}

static event string GetDescriptionText(string PropName)
{
    switch(PropName)
    {
        case "RagFriction": return default.OptDesc[0];
        case "RagRestitution": return default.OptDesc[1];
        case "RagBuoyancy": return default.OptDesc[2];
        case "RagTime": return default.OptDesc[3];
    }
    return Super.GetDescriptionText(PropName);
}

static function FillPlayInfo(PlayInfo PlayInfo)
{
    Super.FillPlayInfo(PlayInfo);
    
    PlayInfo.AddSetting(default.GameGroup, "RagFriction", "Ragdoll Friction", 0, 0, "Text", "4;0.0:20.0", "", False, True);
    PlayInfo.AddSetting(default.GameGroup, "RagRestitution", "Ragdoll Restitution", 0, 1, "Text", "4;0.0:1.0", "", False, True);
    PlayInfo.AddSetting(default.GameGroup, "RagBuoyancy", "Ragdoll Buoyancy", 0, 2, "Text", "4;0.0:2.0", "", False, True);
    PlayInfo.AddSetting(default.GameGroup, "RagTime", "Ragdoll Timescale", 0, 3, "Text", "4;0.1:2.0", "", False, True);
}

defaultproperties
{
    OptDesc[0]="Increases ragdoll friction. Default 1.8"
    OptDesc[1]="Increases ragdoll restitution (i.e. 'bounciness'). Default 0.1"
    OptDesc[2]="Increases ragdoll buoyancy; values higher than 1.0 make bodies float. Default 0.9"
    OptDesc[3]="Changes the rate at which ragdoll physics is simulated. Default 1.0"
    RagFriction=+1.8
    RagRestitution=+0.1
    RagBuoyancy=+0.9
    RagTime=+1.0
    Friendlyname="Modified Corpses"
    Description="Modify ragdoll friction, restitution, and buoyancy."
}