//=============================================================================
// LIPVehicleAtomicToiletCar.
//=============================================================================
class LIPVehicleAtomicToiletCar extends ONSRV;

#exec OBJ LOAD FILE=..\sounds\ONSVehicleSounds-S.uax
#exec OBJ LOAD FILE=..\textures\ONSFullTextures.utx

var()	int		CloseSeatRotation;

simulated event Tick(float DeltaSeconds)
{
	local rotator SeatRot;

	Super.Tick(DeltaSeconds);

	if(!bDriving)
		SeatRot.Pitch = CloseSeatRotation;

	SetBoneRotation('Object05', SeatRot, 0, 1.0);
}

defaultproperties
{
	WheelSoftness=0.025000
	WheelPenScale=1.200000
	WheelLongFrictionScale=1.100000
	WheelSuspensionOffset=0.000000
	GearRatios(0)=-0.250000
	GearRatios(1)=0.100000
	GearRatios(2)=0.400000
	GearRatios(3)=1.600000
	GearRatios(4)=3.200000
	TransRatio=0.200000
	MaxJumpForce=2000000.000000
	MaxJumpSpin=300000.000000
	DriverWeapons(0)=(WeaponClass=Class'LIPATC.LIPATCDualTankCannon',WeaponBone="ToiletSeat01")
	bHasAltFire=True
	RedSkin=Shader'LIPATCTex.Shaders.ATCShaderRedTex'
	BlueSkin=Shader'LIPATCTex.Shaders.ATCShaderBlueTex'
	DestructionEffectClass=Class'Onslaught.ONSTankHitRockEffect'
	DisintegrationEffectClass=Class'Onslaught.ONSTankHitRockEffect'
	DisintegrationHealth=-250.0
	ExplosionSounds(0)=Sound'ONSVehicleSounds-S.Explosions.Explosion01'
	ExplosionSounds(1)=Sound'ONSVehicleSounds-S.Explosions.Explosion02'
	ExplosionSounds(2)=Sound'ONSVehicleSounds-S.Explosions.Explosion03'
	ExplosionSounds(3)=Sound'ONSVehicleSounds-S.Explosions.Explosion04'
	ExplosionSounds(4)=Sound'ONSVehicleSounds-S.Explosions.Explosion05'
	ExplosionSounds(5)=Sound'ONSVehicleSounds-S.Explosions.Explosion06'
	ExplosionSounds(6)=Sound'ONSVehicleSounds-S.Explosions.Explosion07'
	ExplosionSounds(7)=Sound'ONSVehicleSounds-S.Explosions.Explosion08'
	ExplosionSounds(8)=Sound'ONSVehicleSounds-S.Explosions.Explosion09'
	ExplosionSounds(9)=Sound'ONSVehicleSounds-S.Explosions.Explosion10'
	ExplosionSounds(10)=Sound'ONSVehicleSounds-S.Explosions.Explosion11'
	ExplosionSoundRadius=512.000000
	ExplosionDamage=512.000000
	ExplosionRadius=660.000000
	ExplosionMomentum=500000.000000
	ExplosionDamageType=Class'LIPATC.LIPDamTypeATCRanOver'
	DamagedEffectFireDamagePerSec=10.000000
	ImpactDamageMult=0.010000
	CrossHairColor=(G=160,R=255,A=0)
	Begin Object Class=SVehicleWheel Name=SVehicleWheel4
		bPoweredWheel=True
		bHandbrakeWheel=True
		BoneName="Object02"
		BoneRollAxis=AXIS_Y
		BoneOffset=(Y=7.000000)
		WheelRadius=13.000000
	End Object
	Wheels(0)=SVehicleWheel'LIPATC.SVehicleWheel4'

	Begin Object Class=SVehicleWheel Name=SVehicleWheel5
		bPoweredWheel=True
		bHandbrakeWheel=True
		BoneName="Object07"
		BoneRollAxis=AXIS_Y
		BoneOffset=(Y=-7.000000)
		WheelRadius=13.000000
	End Object
	Wheels(1)=SVehicleWheel'LIPATC.SVehicleWheel5'

	Begin Object Class=SVehicleWheel Name=SVehicleWheel6
		bPoweredWheel=True
		SteerType=VST_Steered
		BoneName="Object03"
		BoneRollAxis=AXIS_Y
		BoneOffset=(Y=7.000000)
		WheelRadius=10.000000
	End Object
	Wheels(2)=SVehicleWheel'LIPATC.SVehicleWheel6'

	Begin Object Class=SVehicleWheel Name=SVehicleWheel7
		bPoweredWheel=True
		SteerType=VST_Steered
		BoneName="Object08"
		BoneRollAxis=AXIS_Y
		BoneOffset=(Y=-7.000000)
		WheelRadius=10.000000
	End Object
	Wheels(3)=SVehicleWheel'LIPATC.SVehicleWheel7'

	VehicleMass=5.000000
	bEjectDriver=True
	EntryRadius=128.000000
	TPCamDistance=275.000000
	DriverDamageMult=+0.01
	VehiclePositionString="indisposed in a ATC"
	VehicleNameString="Atomic Toilet Car"
	RanOverDamageType=Class'LIPATC.LIPDamTypeATCRanOver'
	CrushedDamageType=Class'LIPATC.LIPDamTypeATCPANCAKE'
	HornSounds(0)=Sound'LIPATCSounds.Horn.AHOOGA-Horn'
	HornSounds(1)=Sound'LIPATCSounds.Horn.AHOOGA-Horn'
	WaterDamage=50.000000
	HealthMax=500
	Health=500
	Mesh=SkeletalMesh'LIPATCMesh.LIPAtomicToiletCar'
	Begin Object Class=KarmaParamsRBFull Name=KarmaParamsRBFull1
		KInertiaTensor(0)=1.000000
		KInertiaTensor(3)=3.000000
		KInertiaTensor(5)=3.000000
		KLinearDamping=0.050000
		KAngularDamping=0.050000
		KStartEnabled=True
		bKNonSphericalInertia=True
		KMaxSpeed=10000.000000
		bHighDetailOnly=False
		bClientOnly=False
		bKDoubleTickRate=True
		bDestroyOnWorldPenetrate=True
		bDoSafetime=True
		KFriction=0.500000
		KImpactThreshold=700.000000
	End Object
	KParams=KarmaParamsRBFull'LIPATC.KarmaParamsRBFull1'
	
	// drom genericSD
	CloseSeatRotation=16384

	DestroyedVehicleMesh=StaticMesh'GenericSD.TCDead'
	DestructionLinearMomentum=(Min=200000,Max=300000)
    DestructionAngularMomentum=(Min=100,Max=150)

	CollisionHeight=+40.0
	CollisionRadius=+100.0

	DrawScale=1.0
	DrawScale3D=(X=1.0,Y=1.0,Z=1.0)
	
	FPCamPos=(X=7,Y=0,Z=52)
	TPCamLookat=(X=0,Y=0,Z=0)

	TPCamWorldOffset=(X=0,Y=0,Z=100)

	bDoStuntInfo=true
	DaredevilThreshInAirSpin=180.0
	DaredevilThreshInAirPitch=300.0
	DaredevilThreshInAirRoll=300.0
	DaredevilThreshInAirTime=2.0
	DaredevilThreshInAirDistance=24.0

	AirTurnTorque=35.0
	AirPitchTorque=55.0
	AirPitchDamping=35.0
	AirRollTorque=35.0
	AirRollDamping=35.0

	bDrawDriverInTP=True
	bDrawMeshInFP=True
	bHasHandbrake=true
	bAllowBigWheels=true

	DrivePos=(X=9.0,Y=0.0,Z=70.0)

	MaxViewYaw=16000
	MaxViewPitch=16000

	IdleSound=sound'ONSVehicleSounds-S.RV.RVEng01'
	StartUpSound=sound'ONSVehicleSounds-S.RV.RVStart01'
	ShutDownSound=sound'ONSVehicleSounds-S.Laser24'
	EngineRPMSoundRange=9000
	SoundVolume=128
	IdleRPM=500
	RevMeterScale=4000

	ExitPositions(0)=(X=0,Y=-165,Z=100)
	ExitPositions(1)=(X=0,Y=165,Z=100)
	ExitPositions(2)=(X=0,Y=-165,Z=-100)
	ExitPositions(3)=(X=0,Y=165,Z=-100)

	bMakeBrakeLights=false

	DamagedEffectOffset=(X=-32,Y=0,Z=20)
	DamagedEffectScale=1.0

	WheelPenOffset=0.01
	WheelRestitution=0.1
	WheelAdhesion=0.0
	WheelLongFrictionFunc=(Points=((InVal=0,OutVal=0.0),(InVal=100.0,OutVal=1.0),(InVal=200.0,OutVal=0.9),(InVal=10000000000.0,OutVal=0.9)))
	WheelLatFrictionScale=1.35
	WheelLongSlip=0.001
	WheelLatSlipFunc=(Points=((InVal=0.0,OutVal=0.0),(InVal=30.0,OutVal=0.009),(InVal=45.0,OutVal=0.00),(InVal=10000000000.0,OutVal=0.00)))
	WheelHandbrakeSlip=0.01
	WheelHandbrakeFriction=0.1
	WheelSuspensionTravel=15.0
	WheelSuspensionMaxRenderTravel=15.0
	TurnDamping=35

	HandbrakeThresh=200
	FTScale=0.03
	ChassisTorqueScale=0.1

	MinBrakeFriction=1.5
	MaxBrakeTorque=20.0
	MaxSteerAngleCurve=(Points=((InVal=0,OutVal=25.0),(InVal=1500.0,OutVal=11.0),(InVal=1000000000.0,OutVal=11.0)))
	SteerSpeed=160
	StopThreshold=100
	TorqueCurve=(Points=((InVal=0,OutVal=9.0),(InVal=200,OutVal=10.0),(InVal=1500,OutVal=11.0),(InVal=2800,OutVal=0.0)))
	EngineBrakeFactor=0.0001
	EngineBrakeRPMScale=0.1
	EngineInertia=0.1
	WheelInertia=0.1

	ChangeUpPoint=2000
	ChangeDownPoint=1000
	LSDFactor=1.0

	GroundSpeed=940
	CenterSpringForce="SpringONSSRV"

	// to remove some stuff that comes from the scorpion
	ArmExtendSound=None // remove arm extend sound
    ArmRetractSound=None // remove arm retract sound
    BladeBreakSound=None // remove arm break sound
	
	HeadlightProjectorScale=+0.0 // to remove the lights on the front of the vehicle
	HeadlightProjectorMaterial=None // to remove the lights on the front of the vehicle
	HeadlightCoronaMaxSize=+0.0 // to remove the lights on the front of the vehicle
	HeadlightCoronaMaterial=None // to remove the lights on the front of the vehicle
}
