//=============================================================================
// LIPATCDualTankCannon.
//=============================================================================
class LIPATCDualTankCannon extends ONSHoverTankCannon;

// value for the max distance for the bot to fire the primary fire
var int BotEnemyDistanceToFire;
var int BotEnemyDistanceToAltFire;


//=========================
// AI Interface
//=========================
function byte BestMode()
{
	local float EnemyDist;
	local bot B;
	
	B = Bot(Instigator.Controller);
	if (B == None)
		return 0;
	
	EnemyDist = VSize(B.Enemy.Location - Instigator.Location);
	if ( EnemyDist < BotEnemyDistanceToFire )
		return 0;
	
	// here if the enemy is between the max Fire and max Alt fire distance, set in the default properties, they will use the altfire
	if ( EnemyDist > BotEnemyDistanceToFire && EnemyDist < BotEnemyDistanceToAltFire)
		return 1;
}
//=========================
// End AI Interface
//=========================

defaultproperties
{
	// BotEnemyDistanceToFire needs to be smaller than BotEnemyDistanceToAltFire
	BotEnemyDistanceToFire=+2000 // change this value so bots fire with primary fire at enemies that are more distant
	BotEnemyDistanceToAltFire=+3750 // change this value so bots fire with alt fire at enemies that are more distant

	YawBone="RocketPivot"
	PitchBone="RocketPacks"
	PitchUpLimit=14000
	PitchDownLimit=50000
	WeaponFireAttachmentBone="RocketPackFirePoint"
	WeaponFireOffset=32.000000
	DualFireOffset=32.000000
	RotationsPerSecond=1.000000
	bDualIndependantTargeting=True
	Spread=0.000000
	RedSkin=None
	BlueSkin=None
	FireInterval=1.250000
	AltFireInterval=5.000000
	FireSoundClass=SoundGroup'WeaponSounds.RocketLauncher.RocketLauncherFire'
	FireSoundVolume=256.000000
	FireSoundRadius=256.000000
	AltFireSoundClass=Sound'WeaponSounds.Misc.redeemer_shoot'
	AltFireSoundVolume=512.000000
	AltFireSoundRadius=512.000000
	AltFireForce="Explosion05"
	ProjectileClass=Class'LIPATC.LIPATCRocketProjectile'
	AltFireProjectileClass=Class'LIPATC.LIPATCNuclearProjectile'
	ShakeRotMag=(Z=0.000000)
	ShakeRotRate=(Z=0.000000)
	ShakeRotTime=0.000000
	ShakeOffsetMag=(Z=0.000000)
	ShakeOffsetRate=(Z=0.000000)
	ShakeOffsetTime=0.000000
	AIInfo(0)=(WarnTargetPct=1.000000,RefireRate=0.500000)
	AIInfo(1)=(bTrySplash=True,bLeadTarget=True,WarnTargetPct=1.000000,RefireRate=0.250000)
	Mesh=SkeletalMesh'LIPATCMesh.LIPATCRocketPack'
}
