// ============================================================================
// Copyright 2005 by Michael "_Lynx" Sokolkov <unreal-pz@narod.ru>
// Date      : 04.15.2005
// Revision  : 4
//
// The release switch blocker that is spawned, when the OT starts.
// ============================================================================
class JBDecoOTSwitchBlocker extends Actor;

var actor LastToucher;
var JBGameObjectiveSwitch RelatedSwitch;		// the release switch that is covered by this blocker

var int MyTimerInt;

var bool bSetColor;
var bool bDebug;

#exec OBJ LOAD FILE=XGameShaders.utx
#exec OBJ LOAD FILE=XGame_rc.usx

// replication
replication
{
	// replicating vars to client
  reliable if ( Role == ROLE_Authority)
    RelatedSwitch;
}


// ============================================================================
// PostBeginPlay()
//
// Sets up the blocker
// ============================================================================

simulated event PostBeginPlay()
{
  Super.PostBeginPlay();

  bSetColor = false;
 	SetTimer(0.5, True);
}


// ============================================================================
// Timer
//
// Sets skin texture and clears LastToucher. Called twice a second
// ============================================================================

simulated function Timer(){

 	local JBEmitterBasket myEmitter;
 	local int i;

	super.Timer();

	// this made to make bump message show second time, if no
	// one touches the release switch inbetween two players' bumps
	if (MyTimerInt > 0 && LastToucher != None){
		if (MyTimerInt > 3){
			LastToucher = None;
     	MyTimerInt = 0;
    }
    else
    	MyTimerInt++;
	}
	else
		MyTimerInt++;


	if (Level.NetMode != NM_DedicatedServer && !bSetColor && RelatedSwitch != None){

		for (i = 0; i < RelatedSwitch.ListDecoration.Length; i++){

  		if (RelatedSwitch.ListDecoration[i] != None && RelatedSwitch.ListDecoration[i].IsA('JBDecoSwitchBasket') && JBDecoSwitchBasket(RelatedSwitch.ListDecoration[i]).Emitter != None){

				myEmitter = JBDecoSwitchBasket(RelatedSwitch.ListDecoration[i]).Emitter;

				if (myEmitter.Emitters[0] != None && !myEmitter.IsInState('Disabled')){
          if (myEmitter.Emitters[0].ColorScale[1].Color == myEmitter.ColorBlue){
           	Skins[0]  = Shader'XGameShaders.BombIconRS';
           	bSetColor = True;
          }
          else if (myEmitter.Emitters[0].ColorScale[1].Color == myEmitter.ColorRed){
           	Skins[0] =  Shader'XGameShaders.BombIconBS';
           	bSetColor = True;
          }
        }

			}
		}

	}

}

static function PrecacheGameTextures(LevelInfo myLevel)
{
	myLevel.AddPrecacheMaterial(Material'XGameShaders.BombIconYELLOW');
	myLevel.AddPrecacheMaterial(Material'XGameShaders.BombIconRED');
	myLevel.AddPrecacheMaterial(Material'XGameShaders.BombIconBLUE');
}

static function PrecacheGameStaticMeshes(LevelInfo myLevel)
{
	myLevel.AddPrecacheStaticMesh(StaticMesh'XGame_rc.BombEffectMesh');
}

// ===========================================================================
//	Bump
//
// called when an actor touches the blocker
// if it's a player - tell him that releasing is not possible in overtime and
// tell the other players that he tried to release
// ===========================================================================

event Bump ( Actor Other )
{

  local Controller C;

	// something tells me that this thing might be called several times during 1 touch
	// so we'd better check if the one who touched it now != LastToucher
	if (Level.NetMode != NM_Client && xPawn(Other) != None && Pawn(Other).PlayerReplicationInfo.Team.TeamIndex != RelatedSwitch.DefenderTeamIndex && (LastToucher == None || Other != LastToucher)){

    if (PlayerController(pawn(Other).Controller) != None)
 	 	  Level.Game.BroadcastHandler.BroadcastLocalized(Self,PlayerController(pawn(Other).Controller),class'JBLocalMessageOTLockJam', 200);

    // tell everyone else that this player tried to release his team;
    for (C = Level.ControllerList; C.nextController != None; C = C.nextController){
      if (PlayerController(C) != None && C != pawn(Other).Controller){
        Level.Game.BroadcastHandler.BroadcastLocalized(Self,PlayerController(C),class'JBLocalMessageOTLockJam', 300, pawn(Other).Controller.PlayerReplicationInfo);
      }
    }

 	 	LastToucher = Other;
 	 	MyTimerInt = 0;
 	}

}

DefaultProperties
{
	bDebug=false

	Skins(0)=Shader'XGameShaders.BombIconYS'
  DrawType=DT_StaticMesh
  StaticMesh=StaticMesh'XGame_rc.BombEffectMesh'
  bStatic=False
  Physics=PHYS_Rotating
  DrawScale=0.775
  AmbientGlow=255
  bFixedRotationDir=True
  RotationRate=(Pitch=30000,Yaw=30000,Roll=30000)
  Style=STY_Masked
  bUnlit=True

  bBlockNonZeroExtentTraces=True
  CollisionRadius=75.000000
  CollisionHeight=80.000000
  bBlockActors=True
  bBlockKarma=True
  bCollideActors=True
  bUseCylinderCollision=True

	RemoteRole=ROLE_SimulatedProxy
	bAlwaysRelevant=True
	bOnlyDirtyReplication=True
}
