/**********************************************************************************************
***									Game Speed Compensator									***
***																							***
*** My first mutator - I will probably be ashamed to look back at this in some years - Sly. ***
***																							***
**********************************************************************************************/
class MutGameSpeedCompensatorBeta extends Mutator;

var config float CompensationFactor;			//This variable is what changes the movement of the Pawn's settings.
var localized string CompensationFactorText;	//A text for my setting will surely be handy - not just for me.

simulated function PostBeginPlay()
{
	super.PostBeginPlay();
}

static function FillPlayInfo(PlayInfo PI)
{
	super.FillPlayInfo(PI);
	
	PI.AddSetting(default.RulesGroup, "CompensationFactor", default.CompensationFactorText, 0, 0, "Text", "8;0.2:3.5");	//This creates the configurable setting. Note to myself: 0.2 is the minimum due to the dodge-crash issue, 3.5 defines the maximum there.
}

static event string GetDescriptionText(string PropName)						//This static event will get the string PropName, which is the description text.
{
	switch(PropName)
	{
		case "CompensationFactor": return default.CompensationFactorText;	//This returns the text for the settings that was created for CompensationFactor.
	}
	
	return super.GetDescriptionText(PropName);								//return PropName here
	
}

function ModifyPlayer(Pawn Dirkledong)	//"Dirkledong" = same as "Other" in the code of others = Variable name of player's Pawn. I just used something else than the 101 solution of using "Other" so I learn this.
{

	/*I'm checking if Dirkledongs get changed in other mutators in the chain too,
	if I wouldn't do this, then Dirkledong won't be changed in other mutators
	because Dirkledong will be overwritten with this ModifyPlayer function*/
	
	if(NextMutator != None)
	{
		super.ModifyPlayer(Dirkledong);						//super is same as NextMutator here. This allows other mutators to modify the player after this mutator in the chain. Seems legit.
	}
	
	if(PlayerController(Dirkledong.Controller)==None)		//This check is badly necessary, otherwise bots would be affected too. I make sure that Dirkledong is the player by checking for the PlayerController. If the player is not a human player, the game won't proceed doing the stuff below.
		return;
	
	/*When the GameInfo calls this function, it passes a variable into the Dirkledong property of this function
	which is a Pawn. Now, in case Dirkledong dies or gets destroyed for some reason, I need	to clarify that
	Dirkledong still can be changed. Best to check before I change stuff because logic obviously.*/
	
	if(Dirkledong != None)									//Dirkledong exists, so Dirkledong gets changed!
	{
		Dirkledong.GroundSpeed /= CompensationFactor;		//This block redefines the default properties of the pawn of the player.
		Dirkledong.AirSpeed /= CompensationFactor;			//The /= means that I divide what I wrote there, e.g. Dirkledong's GroundSpeed, by the stuff behind the =
		Dirkledong.WaterSpeed /= CompensationFactor;		//Swimming is still an important part of the game.
		Dirkledong.LadderSpeed /= CompensationFactor;		//Never forget the ladders!
		Dirkledong.AccelRate /= CompensationFactor;			//It seemed to have been better to have the AccelRate get changed too.
		Dirkledong.AirControl /= CompensationFactor;		//Because floating in midair can be really exhausting...
	}
}

DefaultProperties
{
	CompensationFactorText="Input Game Speed's value here"	//Game Speed alone might have been too confusing.
	Description="BETA 1 - This mutator is intended to be used with the Game Speed mutator. It will speed up or slow down your character movement to compensate for the slower or faster passing of time, depending on Game Speed's settings. For this, simply add the same value into the mutator's textfield as you did in Game Speed mutator and it will neutralize the effect of too slow or too fast movement for you. Have fun, Sly."
	GroupName="Player Properties"							//Since this mutator alters the player, it should not be used with others of its kind thus excluding usage of those.
	FriendlyName="Game Speed Compensator - Beta 1"			//I believe I could have come up with a better name here, but I'll just let it be.
}
