// ====================================================================
//  Class: AvrilKick.AvrilKickFire
//
//  Written by Rajliv in March 2013
//  Contact: rlv@miasma.org
// ====================================================================
class AvrilKickFire extends ONSAVRiLFire
	config(AvrilKick);

var config float KickModifier;
var config bool bDisableIfCrouched,
                bDisableOnGround;

event PreBeginPlay() {
	// modify kickmomentum, default: X=-350,Y=0,Z=175
	KickMomentum.X *= KickModifier;
	KickMomentum.Z *= KickModifier;
}

function DoFireEffect() {
	Super.DoFireEffect();
	
	if (Instigator != None && (!bDisableOnGround || Instigator.Base == None)
	&& (!bDisableIfCrouched || !Instigator.bIsCrouched))
		Instigator.AddVelocity(KickMomentum >> Instigator.GetViewRotation());
}

defaultproperties
{
	KickModifier=1.000000
}