class SlipSuitActivate extends InstantFire;

var shader SlipSuitMaterial, TeamRedMaterial, TeamBlueMaterial;

simulated function bool AllowFire()
{
    return ( SlipSuit(Weapon).AmmoCharge >= 1.0 );
}

function DoFireEffect()
{
 local Pawn P;

  P = Instigator;

  P.GroundSpeed *= 1.8;
  P.AirControl *= 2.5;
  P.WaterSpeed *= 1.8;
  P.AirSpeed *= 2.5;
  P.JumpZ *= 2.5;

  SlipSuit(Weapon).ReduceAmmo();

  if(xPawn(P)!=None && Instigator.PlayerReplicationInfo != none ) {

						 if (Instigator.PlayerReplicationInfo.Team == None || Instigator.PlayerReplicationInfo.Team.TeamIndex == 0)
                xPawn(P).SetOverlayMaterial(TeamRedMaterial, 20.0, false);
            else
                xPawn(P).SetOverlayMaterial(TeamBlueMaterial, 20.0, false);

  }

		SetTimer(15.0,false);
}

function unDoFireEffect(Pawn P) {

		if(P != none) {

		if(xPawn(P)!=None){
		   xPawn(P).SetOverlayMaterial(None, 0.0f, true);
					}

		if(Level.Game != none) {
    Level.Game.SetPlayerDefaults(P);
    }

		}
}

function Timer() {
  local Pawn P;

 P = Instigator;

 UnDoFireEffect(P);
}

defaultproperties{
SlipSuitMaterial=Shader'XGameShaders.PlayerShaders.PlayerShieldSh'
TeamRedMaterial=Shader'XGameShaders.PlayerShaders.PlayerTransRed'
TeamBlueMaterial=Shader'XGameShaders.PlayerShaders.PlayerTrans'
}

