//=============================================================================
// Translocator Launcher  w/ watered down effect
//=============================================================================
class SlipSuit extends TransLauncher;

var xEmitter HeadTrail;
var shader SlipSuitMaterial;

function StartEffect()
{
				local xPawn P;
				P = xPawn(Owner);
    HeadTrail = Spawn(class'SpeedTrail', P,, P.Location, P.Rotation);
				P.AttachToBone(HeadTrail, 'head');
}

function StopEffect()
{
    if (HeadTrail != None)
        HeadTrail.Destroy();
}

function KeepEffect()
{
    if (HeadTrail != None)
        HeadTrail.LifeSpan = 99;
}


simulated function Tick(float dt)
{
  if ( Bot(Pawn(Owner).Controller) != none ){
		    if(FireMode[0].AllowFire()){
		    SlipSuitActivate(FireMode[0]).DoFireEffect();
						}
				}

		  if (Role == ROLE_Authority)
    {
		if ( AmmoCharge >= AmmoChargeMax )
		{
			if ( RepAmmo != int(AmmoCharge) ) // condition to avoid unnecessary bNetDirty of ammo
				RepAmmo = int(AmmoCharge);
			disable('Tick');
			return;
		}
		AmmoCharge += dt*AmmoChargeRate;
		AmmoCharge = FMin(AmmoCharge, AmmoChargeMax);
        if ( RepAmmo != int(AmmoCharge) ) // condition to avoid unnecessary bNetDirty of ammo
			RepAmmo = int(AmmoCharge);
    }
    else
    {
        // client simulation of the charge bar
        AmmoCharge = FMin(AmmoCharge+dt*AmmoChargeRate, AmmoChargeMax);
        if (OldAmmo > RepAmmo)
            AmmoCharge -= 1.0;
        OldAmmo = RepAmmo;
    }
				if(HeadTrail != none){KeepEffect();}
    if(AmmoCharge == AmmoChargeMax) { SlipSuitActivate(FireMode[0]).UnDoFireEffect(Pawn(Owner)); }

}

function bool ShouldTranslocatorHop(Bot B)
{
	StartFire(0); // bot cheat
	B.TranslocationTarget = None;
	B.RealTranslocationTarget = None;
	B.bPreparingMove=false;
	return false;
}

// AI Interface...
function GiveTo(Pawn Other, optional Pickup Pickup)
{
	Super.GiveTo(Other, Pickup);

	if ( Bot(Other.Controller) != None )
		Bot(Other.Controller).bHasTranslocator = false;
}





defaultproperties
{
     ItemName="SlipSuit"
					FireModeClass(0)=Class'XPakII.SlipSuitActivate'
     FireModeClass(1)=Class'XPakII.SlipSuitDeActivate'
				 AmmoCharge=1.000000
     RepAmmo=1
     AmmoChargeMax=1.000000
     AmmoChargeRate=0.02500
					SlipSuitMaterial=Shader'XGameShaders.PlayerShaders.PlayerShieldSh'
}
