//=============================================================================
// MutSpeciesStats - species specific stats for players
//=============================================================================
class MutComboBurningMan extends Mutator;

function string RecommendCombo(string ComboName)
{
	local int i;

 i = Rand( ArrayCount( Class'xGame.xPlayer'.Default.ComboNameList ) );
	ComboName =  Class'xGame.xPlayer'.Default.ComboNameList[i];

	if ( NextMutator != None )
		return NextMutator.RecommendCombo(ComboName);
	return ComboName;
}

function ModifyPlayer(Pawn Other)
{
    local xPawn xp;
				local xPlayer xpl;
				local int c;

    xp = xPawn(Other);
    if(xp == None)
        return;
    xpl = xPlayer(xp.Controller);
    if (xpl == none)
        return;
    for (c = 0; c < ArrayCount(xpl.ComboList); c++)
    {
        if ( xpl.ComboNameList[c] == "" ) {
        			xpl.ComboNameList[c] = "XPakII.ComboBurningMan";
    							xpl.ComboList[c] = class<Combo>(DynamicLoadObject("XPakII.ComboBurningMan",class'Class'));
		  							xpl.MinAdrenalineCost = FMin(xpl.MinAdrenalineCost,xpl.ComboList[c].Default.AdrenalineCost);
           break;
											}
    }

    Super.ModifyPlayer(Other);
}

defaultproperties
{
     GroupName="2121"
     FriendlyName="Burning Man Combo"
     Description="light yourself on fire with forward back forward back    ||Net Support: none |Bot Support: Not really"
}
