class FireFire extends BeamCannonFire;

var int counter;
var() int ProjPerFire;
var() Vector ProjSpawnOffset; // +x forward, +y right, +z up

state Paint
{
	function Rotator AdjustAim(Vector Start, float InAimError)
	{
		if ( Bot(Instigator.Controller) != None )
		{
			if ( bAlreadyMarked )
				return Rotator(MarkLocation - Start);
			else
				return rotator(Painter(Instigator.Weapon).MarkLocation - Instigator.Location + Instigator.CollisionHeight * vect(0,0,1));
		}
		else
			return Global.AdjustAim(Start, InAimError);
	}

    function BeginState()
    {
     local bool bAmmo;
     local Vector StartTrace;
     local Rotator R, Aim;

					   IonCannon = None;
        bAmmo = Weapon.Ammo[0].AmmoAmount > 0;

        ClientPlayForceFeedback(TAGFireForce);
        bIsFiring=true;

    }

    function ModeTick(float dt)
    {

    local Vector StartTrace;
    local Rotator R, Aim;

				if(counter <= 0) {
    if(Weapon.Ammo[0].AmmoAmount > 0 && bIsFiring){
      if (Beam == None){Beam = Spawn(class'PainterBeamEffect');}
						StartTrace = Instigator.Location + Instigator.EyePosition();
    		Aim = AdjustAim(StartTrace, AimError);
						R = rotator(vector(Aim) + VRand()*FRand()*Spread);
    		DoTrace(StartTrace, R);
    		Weapon.Ammo[0].useAmmo(1);
						}else{StopFiring();}

    if (!bIsFiring)
        {
            StopFiring();
        }
    counter = default.counter;
				}else{counter--;}
    }

    function StopFiring()
    {
		      bMarkStarted = false;
        if (Beam != None)
        {
            Beam.SetTargetState(PTS_Cancelled);
        }
    }

    function EndState()
    {
		      bAlreadyMarked = false;
        StopForceFeedback(TAGFireForce);
    }
}


function DoTrace(Vector Start, Rotator Dir)
{
    local Vector StartProj, StartTrace, X,Y,Z;
    local Rotator R, Aim;
    local Vector HitLocation, HitNormal;
    local Actor Other;
    local int p;
    local int SpawnCount;
    local float theta;

    Instigator.MakeNoise(1.0);
    Weapon.GetViewAxes(X,Y,Z);

    StartTrace = Instigator.Location + Instigator.EyePosition();// + X*Instigator.CollisionRadius;
    StartProj = StartTrace + X*ProjSpawnOffset.X + Z*ProjSpawnOffset.Z;
    if ( !Weapon.WeaponCentered() )
	    StartProj = StartProj + Y*ProjSpawnOffset.Y;

    // check if projectile would spawn through a wall and adjust start location accordingly
    Other = Trace(HitLocation, HitNormal, StartProj, StartTrace, false);
    if (Other != None)
    {
        StartProj = HitLocation;
    }

    Aim = AdjustAim(StartProj, AimError);

    SpawnCount = Max(1, ProjPerFire * int(Load));

    switch (SpreadStyle)
    {
    case SS_Random:
        X = Vector(Aim);
        for (p = 0; p < SpawnCount; p++)
        {
            R.Yaw = Spread * (FRand()-0.5);
            R.Pitch = Spread * (FRand()-0.5);
            R.Roll = Spread * (FRand()-0.5);
            Spawn(class'FireFlameBig',,, StartProj, Rotator(X >> R));
        }
        break;
    case SS_Line:
        for (p = 0; p < SpawnCount; p++)
        {
            theta = Spread*PI/32768*(p - float(SpawnCount-1)/2.0);
            X.X = Cos(theta);
            X.Y = Sin(theta);
            X.Z = 0.0;
            Spawn(class'FireFlameBig',,, StartProj, Rotator(X >> Aim));
        }
        break;
    default:
        Spawn(class'FireFlameBig',,, StartProj, Aim);
    }
}



defaultproperties {
	TraceRange=150.000000
	AmmoPerFire=1
	counter=10
	ProjSpawnOffset=(X=150,Y=0,Z=-10)
	ProjPerFire=1
	}
