class DamTypeBurningMan extends WeaponDamageType
	abstract;

var class<LocalMessage> KillerMessage;
var sound HeadHunter;

static function IncrementKills(Controller Killer)
{
	local xPlayerReplicationInfo xPRI;

	if ( PlayerController(Killer) == None )
		return;

	PlayerController(Killer).ReceiveLocalizedMessage( Default.KillerMessage, 0, Killer.PlayerReplicationInfo, None, None );

}

static function GetHitEffects(out class<xEmitter> HitEffects[4], int VictemHealth )
{
    HitEffects[0] = class'HitSmoke';
    HitEffects[1] = class'HitFlameBig';
}

defaultproperties
{
     DeathString="%o stood too close to %k's fire."
     FemaleSuicide="%o immolated herself."
     MaleSuicide="%o immolated himself."
     bAlwaysSevers=True
     bSpecial=True
     bCauseConvulsions=True
     PawnDamageEffect=HitFlameBig
     PawnDamageEmitter=HitSmoke
     bSkeletize=true
}
