class ComboSlipSuit extends Combo;

var xEmitter LeftTrail, RightTrail;

function StartEffect(xPawn P)
{
    LeftTrail = Spawn(class'SpeedTrail', P,, P.Location, P.Rotation);
    P.AttachToBone(LeftTrail, 'lfoot');

    RightTrail = Spawn(class'SpeedTrail', P,, P.Location, P.Rotation);
    P.AttachToBone(RightTrail, 'rfoot');

    P.AirControl *= 2.5;
    P.GroundSpeed *= 2.5;
    P.WaterSpeed *= 2.5;
    P.AirSpeed *= 1.2;
    P.JumpZ *= 2.5;
}

function StopEffect(xPawn P)
{
    if (LeftTrail != None)
        LeftTrail.Destroy();

    if (RightTrail != None)
        RightTrail.Destroy();

    Level.Game.SetPlayerDefaults(P);
}

defaultproperties
{
     ExecMessage="Speed!"
     Duration=20.000000
     ComboAnnouncement=Sound'AnnouncerMain.Speed'
     keys(0)=1
     keys(1)=1
     keys(2)=1
     keys(3)=1
}
