class BeamCannonFire extends PainterFire;

var() class<xEmitter> HitEmitterClass;
var() class<xEmitter> SecHitEmitterClass;
var() int NumArcs;
var() float SecDamageMult;
var() float SecTraceDist;
var() float HeadShotDamageMult;
var() float HeadShotRadius;
var() class<DamageType> DamageTypeHeadShot;

var PainterBeamEffect Beam;
var float UpTime;
var bool bDoHit;
var bool bValidMark;
var bool bInitialMark;
var bool bAlreadyMarked;

var IonCannon IonCannon;
var float MarkTime;
var Vector MarkLocation;
var() float TraceRange;
var() float PaintDuration;
var Vector EndEffect;
var   class<DamageType>	   DamageType;
var   class<DamageType>	   MyDamageType;

var() Sound MarkSound;
var() sound AquiredSound;

var() string TAGFireForce;
var() string TAGMarkForce;
var() string TAGAquiredForce;
var bool bMarkStarted;

function Destroyed()
{
    if (Beam != None)
    {
        Beam.Destroy();
    }

    Super.Destroyed();
}

state Waiting
{
   function EndState()
    {
		      GotoState('Paint');
    }
}

state Paint
{
	function Rotator AdjustAim(Vector Start, float InAimError)
	{
		if ( Bot(Instigator.Controller) != None )
		{
			if ( bAlreadyMarked )
				return Rotator(MarkLocation - Start);
			else
				return rotator(Painter(Instigator.Weapon).MarkLocation - Instigator.Location + Instigator.CollisionHeight * vect(0,0,1));
		}
		else
			return Global.AdjustAim(Start, InAimError);
	}

    function BeginState()
    {
     local bool bAmmo;
     local Vector StartTrace;
     local Rotator R, Aim;

					   IonCannon = None;
        bAmmo = Weapon.Ammo[0].AmmoAmount > 0;

								if (Weapon.Role == ROLE_Authority)
        {
            if (Beam == None)
            {
                Beam = Spawn(class'PainterBeamEffect');
            }
        }

        ClientPlayForceFeedback(TAGFireForce);
        bIsFiring=true;

    }

    function ModeTick(float dt)
    {

    local Vector StartTrace;
    local Rotator R, Aim;


    if(Weapon.Ammo[0].AmmoAmount > 0 && bIsFiring){
      if (Beam == None){Beam = Spawn(class'PainterBeamEffect');}
						StartTrace = Instigator.Location + Instigator.EyePosition();
    		Aim = AdjustAim(StartTrace, AimError);
						R = rotator(vector(Aim) + VRand()*FRand()*Spread);
    		DoTrace(StartTrace, R);
    		Weapon.Ammo[0].useAmmo(1);
						}else{StopFiring();}

    if (!bIsFiring)
        {
            StopFiring();
        }

    }

    function StopFiring()
    {
		      bMarkStarted = false;
        if (Beam != None)
        {
            Beam.SetTargetState(PTS_Cancelled);
        }
    }

    function EndState()
    {
		      bAlreadyMarked = false;
        StopForceFeedback(TAGFireForce);
    }
}

function StartFiring()
{
  ModeHoldFire();
}

function DoFireEffect()
{
}

function ModeHoldFire()
{
    GotoState('Paint');
}

function StartBerserk()
{
}

function StopBerserk()
{
}

function vector GetFireStart(vector X, vector Y, vector Z)
{
    return Instigator.Location + Instigator.EyePosition() + X*Instigator.CollisionRadius;
}

function DoTrace(Vector Start, Rotator Dir)
{
    local Vector X,Y,Z, End, HitLocation, HitNormal, RefNormal;
    local Actor Other, mainArcHitTarget;
    local int Damage, ReflectNum, arcsRemaining;
    local bool bDoReflect;
    local xEmitter hitEmitter;
    local class<Actor> tmpHitEmitClass;
    local float tmpTraceRange, dist;
    local vector arcEnd, mainArcHit;

    Weapon.GetViewAxes(X, Y, Z);
    arcEnd = (Instigator.Location +
        Instigator.CalcDrawOffset(Weapon) +
        Weapon.EffectOffset.X * X +
        Weapon.EffectOffset.Y * Y +
        Weapon.EffectOffset.Z * Z);

    arcsRemaining = NumArcs;

    tmpHitEmitClass = HitEmitterClass;
    tmpTraceRange = TraceRange;


        X = Vector(Dir);
        End = Start + tmpTraceRange * X;
        Other = Trace(HitLocation, HitNormal, End, Start, true);

        if ( Other != None && Other != Instigator  )
        {
            if ( !Other.bWorldGeometry )
                {
                    Damage = (75 + Rand(750 - 75)) * DamageAtten;
					if ( (Pawn(Other) != None)
						&& Other.GetClosestBone( HitLocation, X, dist, 'head', HeadShotRadius ) == 'head' )  {
                        Other.TakeDamage(750 * HeadShotDamageMult, Instigator, HitLocation, 250*X, DamageTypeHeadShot);
                    } else {
																				Damage *= SecDamageMult;
                    Other.TakeDamage(750, Instigator, HitLocation, 250*X, DamageType);
																				}
                } else  {
																HitLocation = HitLocation + 2.0 * HitNormal;
																}

								}
        else
        {
            HitLocation = End;
            HitNormal = Normal(Start - End);
								}

								Beam.SetTargetState(PTS_Marked);
								Beam.EndEffect = HitLocation;
								Painter(Weapon).EndEffect = HitLocation;

}

defaultproperties
{
     TraceRange=10000.000000
     PaintDuration=2.000000
     MarkSound=Sound'WeaponSounds.TAGRifle.TAGFireB'
     AquiredSound=Sound'WeaponSounds.TAGRifle.TAGTargetAquired'
     TAGFireForce="TAGFireA"
     TAGMarkForce="TAGFireB"
     TAGAquiredForce="TAGAquire"
     FireEndAnim="None"
     FireRate=0.600000
     bFireOnRelease=True
     AmmoClass=Class'XPakII.BeamCannonAmmo'
     AmmoPerFire=1
     BotRefireRate=1.000000
     WarnTargetPct=0.100000
     bSplashDamage=False
     bRecommendSplashDamage=False
     HitEmitterClass=Class'XEffects.IonLightBeam'
     SecHitEmitterClass=Class'XWeapons.PainterBeamEffect'
     NumArcs=4
     SecDamageMult=0.500000
     SecTraceDist=300.000000
     HeadShotDamageMult=2.000000
     HeadShotRadius=8.000000
     DamageTypeHeadShot=Class'XPakII.DamTypeBeamHeadShot'
     DamageType=Class'XPakII.DamTypeBeam'
}
