class TVelocityGameRules extends GameRules;

var() float DeathVelocityAdd;

function PostBeginPlay()
{
	// Change the overall speed at which karma is evolved for in the level.
	Level.RagdollTimeScale = 2.0;
}

function ModifyPlayer(Pawn Other)
{
	local xPawn x;
	x = xPawn(Other);

	if(x != None)
	{
		// Increase the amount of time that ragdolls hang around for as well...
		x.RagdollLifeSpan = 64;
	}
}

function Killed( Controller Killer, Controller Killed, Pawn KilledPawn, class<DamageType> damageType )
{
 local xPawn x;
	x = xPawn(KilledPawn);
 if(x != None)
	{
	x.RagDeathVel+=7000.000000;
 x.RagDeathUpKick+=7000.000000;
 }
}

defaultproperties
{
	DeathVelocityAdd=25000.00
}
