class SurgeGameRules extends GameRules;

var() int BigDamageAdd;
var() int KillAdd;
var() int DistanceAdd;
var() int HeadShotAdd;
var() int EndLifeAdd;
var() int DumbShotAdd;

function int NetDamage( int OriginalDamage, int Damage, pawn injured, pawn instigatedBy, vector HitLocation, vector Momentum, class<DamageType> DamageType )
{
if ( NextGameRules != None )
		Damage = NextGameRules.NetDamage( OriginalDamage,Damage,injured,instigatedBy,HitLocation,Momentum,DamageType );
if(instigatedBy != none && injured != none){
if(instigatedBy != injured) {
	if(OriginalDamage > 50) {instigatedBy.Controller.AwardAdrenaline(BigDamageAdd);}
	if(OriginalDamage > injured.Health) {instigatedBy.Controller.AwardAdrenaline(KillAdd);}
	if(VSize(injured.Location - instigatedBy.Location) > 1000) {instigatedBy.Controller.AwardAdrenaline(DistanceAdd);}
	if(DamageType.isA('DamTypeSniperHeadShot')) {instigatedBy.Controller.AwardAdrenaline(HeadShotAdd);}
	if(injured.PlayerReplicationInfo.numLives == 1) {instigatedBy.Controller.AwardAdrenaline(EndLifeAdd);}
	instigatedBy.Controller.AwardAdrenaline(injured.PlayerReplicationInfo.Score);
	}else{
	 instigatedBy.Controller.AwardAdrenaline(DumbShotAdd);
	 }
	}

	return Damage;
}

defaultproperties
{
	BigDamageAdd=10
	KillAdd=15
	DistanceAdd=15
	HeadShotAdd=20
	EndLifeAdd=25
	DumbShotAdd=-10
}
