class RocketMagnumMultiFire extends RocketMultiFire;

function PlayFiring()
{
    if (Load > 1.0)
        FireAnim = 'AltFire';
    else
        FireAnim = 'Fire';
    Super.PlayFiring();
    RocketLauncher(Weapon).PlayFiring((Load == 3.0));
	Weapon.OutOfAmmo();
}

event ModeDoFire()
{
    Spread = TightSpread;
		  SpreadStyle = SS_Ring;

    RocketLauncher(Weapon).bTightSpread = true;
    Super.ModeDoFire();
}

function DoFireEffect()
{
    local Vector StartProj, StartTrace, X,Y,Z;
    local Rotator Aim;
    local Vector HitLocation, HitNormal,FireLocation;
    local Actor Other;
    local int p,q, SpawnCount, i;
	local RocketMagnumProj FiredRockets[8];
	local bool bCurl;

/*
	if ( (SpreadStyle == SS_Line) || (Load < 5) )
	{
		Super.DoFireEffect();
		return;
	}
*/
    Instigator.MakeNoise(1.0);
    Weapon.GetViewAxes(X,Y,Z);

    StartTrace = Instigator.Location + Instigator.EyePosition();// + X*Instigator.CollisionRadius;
    StartProj = StartTrace + X*ProjSpawnOffset.X + Y*ProjSpawnOffset.Y + Z*ProjSpawnOffset.Z;

    // check if projectile would spawn through a wall and adjust start location accordingly
    Other = Trace(HitLocation, HitNormal, StartProj, StartTrace, false);

				if (Other != None)
    {
        StartProj = HitLocation;
    }

    Aim = AdjustAim(StartProj, AimError);

//    SpawnCount = Max(1, int(Load));
   SpawnCount = 3;
			Load = 3;

    for ( p=0; p<SpawnCount; p++ )
    {
 		     Firelocation = StartProj - 2*((Sin(p*2*PI/3)*8 - 7)*Y - (Cos(p*2*PI/3)*8 - 7)*Z) - X * 8 * FRand();
        FiredRockets[p] = RocketMagnumProj(SpawnProjectile(FireLocation, Aim));
    }

    if ( SpawnCount < 1 )
		return;

	FlockIndex++;
	if ( FlockIndex == 0 )
		FlockIndex = 1;

    // To get crazy flying, we tell each projectile in the flock about the others.
    for ( p = 0; p < SpawnCount; p++ )
    {
		if(FiredRockets[p] != none) {
		FiredRockets[p].bCurl = true;
		FiredRockets[p].FlockIndex = FlockIndex;
		i = 0;
		for ( q=0; q<SpawnCount; q++ )
			if ( p != q )
			{
				FiredRockets[p].Flock[i] = FiredRockets[q];
				i++;
			}
		bCurl = !bCurl;
		if ( Level.NetMode != NM_DedicatedServer )
			FiredRockets[p].SetTimer(0.1, true);
	}
	}
}

defaultproperties {
  AmmoPerFire=3
  FireRate=0.30
  AmmoClass=class'RocketMagnumAmmo'

  ProjectileClass=class'XPak.RocketMagnumProj'
  }
